/*
 * Decompiled with CFR 0.152.
 */
package dk.brics.automaton;

import dk.brics.automaton.BasicAutomata;
import dk.brics.automaton.BasicOperations;
import dk.brics.automaton.MinimizationOperations;
import dk.brics.automaton.ShuffleOperations;
import dk.brics.automaton.SpecialOperations;
import dk.brics.automaton.State;
import dk.brics.automaton.StatePair;
import dk.brics.automaton.Transition;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Automaton
implements Serializable,
Cloneable {
    static final long serialVersionUID = 10001L;
    public static final int MINIMIZE_HUFFMAN = 0;
    public static final int MINIMIZE_BRZOZOWSKI = 1;
    public static final int MINIMIZE_HOPCROFT = 2;
    static int minimization = 2;
    State initial = new State();
    boolean deterministic = true;
    transient Object info;
    int hash_code;
    String singleton = null;
    static boolean minimize_always = false;
    static boolean allow_mutation = false;
    static Boolean is_debug = null;

    boolean isDebug() {
        if (is_debug == null) {
            is_debug = System.getProperty("dk.brics.automaton.debug") != null;
        }
        return is_debug;
    }

    public static void setMinimization(int algorithm) {
        minimization = algorithm;
    }

    public static void setMinimizeAlways(boolean flag) {
        minimize_always = flag;
    }

    public static boolean setAllowMutate(boolean flag) {
        boolean b = allow_mutation;
        allow_mutation = flag;
        return b;
    }

    static boolean getAllowMutate() {
        return allow_mutation;
    }

    void checkMinimizeAlways() {
        if (minimize_always) {
            this.minimize();
        }
    }

    boolean isSingleton() {
        return this.singleton != null;
    }

    public String getSingleton() {
        return this.singleton;
    }

    public void setInitialState(State s) {
        this.initial = s;
        this.singleton = null;
    }

    public State getInitialState() {
        this.expandSingleton();
        return this.initial;
    }

    public boolean isDeterministic() {
        return this.deterministic;
    }

    public void setDeterministic(boolean deterministic) {
        this.deterministic = deterministic;
    }

    public void setInfo(Object info) {
        this.info = info;
    }

    public Object getInfo() {
        return this.info;
    }

    public Set<State> getStates() {
        this.expandSingleton();
        HashSet visited = this.isDebug() ? new LinkedHashSet() : new HashSet();
        LinkedList<State> worklist = new LinkedList<State>();
        worklist.add(this.initial);
        visited.add(this.initial);
        while (worklist.size() > 0) {
            State s = (State)worklist.removeFirst();
            Collection<Transition> tr = this.isDebug() ? s.getSortedTransitions(false) : s.transitions;
            for (Transition t : tr) {
                if (visited.contains(t.to)) continue;
                visited.add(t.to);
                worklist.add(t.to);
            }
        }
        return visited;
    }

    public Set<State> getAcceptStates() {
        this.expandSingleton();
        HashSet<State> accepts = new HashSet<State>();
        HashSet<State> visited = new HashSet<State>();
        LinkedList<State> worklist = new LinkedList<State>();
        worklist.add(this.initial);
        visited.add(this.initial);
        while (worklist.size() > 0) {
            State s = (State)worklist.removeFirst();
            if (s.accept) {
                accepts.add(s);
            }
            for (Transition t : s.transitions) {
                if (visited.contains(t.to)) continue;
                visited.add(t.to);
                worklist.add(t.to);
            }
        }
        return accepts;
    }

    static void setStateNumbers(Set<State> states) {
        int number = 0;
        for (State s : states) {
            s.number = number++;
        }
    }

    void totalize() {
        State s = new State();
        s.transitions.add(new Transition('\u0000', '\uffff', s));
        for (State p : this.getStates()) {
            int maxi = 0;
            for (Transition t : p.getSortedTransitions(false)) {
                if (t.min > maxi) {
                    p.transitions.add(new Transition((char)maxi, (char)(t.min - '\u0001'), s));
                }
                if (t.max + '\u0001' <= maxi) continue;
                maxi = t.max + '\u0001';
            }
            if (maxi > 65535) continue;
            p.transitions.add(new Transition((char)maxi, '\uffff', s));
        }
    }

    public void restoreInvariant() {
        this.removeDeadTransitions();
    }

    public void reduce() {
        if (this.isSingleton()) {
            return;
        }
        Set<State> states = this.getStates();
        Automaton.setStateNumbers(states);
        for (State s : states) {
            List<Transition> st = s.getSortedTransitions(true);
            s.resetTransitions();
            State p = null;
            int min = -1;
            char c = '\uffffffff';
            for (Transition t : st) {
                if (p == t.to) {
                    if (t.min <= c + 1) {
                        if (t.max <= c) continue;
                        c = t.max;
                        continue;
                    }
                    if (p != null) {
                        s.transitions.add(new Transition((char)min, c, p));
                    }
                    min = t.min;
                    c = t.max;
                    continue;
                }
                if (p != null) {
                    s.transitions.add(new Transition((char)min, c, p));
                }
                p = t.to;
                min = t.min;
                c = t.max;
            }
            if (p == null) continue;
            s.transitions.add(new Transition((char)min, c, p));
        }
        this.clearHashCode();
    }

    char[] getStartPoints() {
        HashSet<Character> pointset = new HashSet<Character>();
        for (State s : this.getStates()) {
            pointset.add(Character.valueOf('\u0000'));
            for (Transition t : s.transitions) {
                pointset.add(Character.valueOf(t.min));
                if (t.max >= '\uffff') continue;
                pointset.add(Character.valueOf((char)(t.max + '\u0001')));
            }
        }
        char[] points = new char[pointset.size()];
        int n = 0;
        for (Character m : pointset) {
            points[n++] = m.charValue();
        }
        Arrays.sort(points);
        return points;
    }

    public Set<State> getLiveStates() {
        this.expandSingleton();
        return this.getLiveStates(this.getStates());
    }

    private Set<State> getLiveStates(Set<State> states) {
        HashMap map = new HashMap();
        for (State s : states) {
            map.put(s, new HashSet());
        }
        for (State s : states) {
            for (Transition t : s.transitions) {
                ((Set)map.get(t.to)).add(s);
            }
        }
        HashSet<State> live = new HashSet<State>(this.getAcceptStates());
        LinkedList<State> worklist = new LinkedList<State>(live);
        while (worklist.size() > 0) {
            State s = worklist.removeFirst();
            for (State p : (Set)map.get(s)) {
                if (live.contains(p)) continue;
                live.add(p);
                worklist.add(p);
            }
        }
        return live;
    }

    public void removeDeadTransitions() {
        this.clearHashCode();
        if (this.isSingleton()) {
            return;
        }
        Set<State> states = this.getStates();
        Set<State> live = this.getLiveStates(states);
        for (State s : states) {
            Set<Transition> st = s.transitions;
            s.resetTransitions();
            for (Transition t : st) {
                if (!live.contains(t.to)) continue;
                s.transitions.add(t);
            }
        }
        this.reduce();
    }

    static Transition[][] getSortedTransitions(Set<State> states) {
        Automaton.setStateNumbers(states);
        Transition[][] transitions = new Transition[states.size()][];
        for (State s : states) {
            transitions[s.number] = s.getSortedTransitionArray(false);
        }
        return transitions;
    }

    public void expandSingleton() {
        if (this.isSingleton()) {
            State p;
            this.initial = p = new State();
            int i = 0;
            while (i < this.singleton.length()) {
                State q = new State();
                p.transitions.add(new Transition(this.singleton.charAt(i), q));
                p = q;
                ++i;
            }
            p.accept = true;
            this.deterministic = true;
            this.singleton = null;
        }
    }

    public int getNumberOfStates() {
        if (this.isSingleton()) {
            return this.singleton.length() + 1;
        }
        return this.getStates().size();
    }

    public int getNumberOfTransitions() {
        if (this.isSingleton()) {
            return this.singleton.length();
        }
        int c = 0;
        for (State s : this.getStates()) {
            c += s.transitions.size();
        }
        return c;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Automaton)) {
            return false;
        }
        Automaton a = (Automaton)obj;
        if (this.isSingleton() && a.isSingleton()) {
            return this.singleton.equals(a.singleton);
        }
        return this.hashCode() == a.hashCode() && this.subsetOf(a) && a.subsetOf(this);
    }

    public int hashCode() {
        if (this.hash_code == 0) {
            this.minimize();
        }
        return this.hash_code;
    }

    void recomputeHashCode() {
        this.hash_code = this.getNumberOfStates() * 3 + this.getNumberOfTransitions() * 2;
        if (this.hash_code == 0) {
            this.hash_code = 1;
        }
    }

    void clearHashCode() {
        this.hash_code = 0;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        if (this.isSingleton()) {
            b.append("singleton: ");
            char[] cArray = this.singleton.toCharArray();
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                Transition.appendCharString(c, b);
                ++n2;
            }
            b.append("\n");
        } else {
            Set<State> states = this.getStates();
            Automaton.setStateNumbers(states);
            b.append("initial state: ").append(this.initial.number).append("\n");
            for (State s : states) {
                b.append(s.toString());
            }
        }
        return b.toString();
    }

    public String toDot() {
        StringBuilder b = new StringBuilder("digraph Automaton {\n");
        b.append("  rankdir = LR;\n");
        Set<State> states = this.getStates();
        Automaton.setStateNumbers(states);
        for (State s : states) {
            b.append("  ").append(s.number);
            if (s.accept) {
                b.append(" [shape=doublecircle,label=\"\"];\n");
            } else {
                b.append(" [shape=circle,label=\"\"];\n");
            }
            if (s == this.initial) {
                b.append("  initial [shape=plaintext,label=\"\"];\n");
                b.append("  initial -> ").append(s.number).append("\n");
            }
            for (Transition t : s.transitions) {
                b.append("  ").append(s.number);
                t.appendDot(b);
            }
        }
        return b.append("}\n").toString();
    }

    Automaton cloneExpanded() {
        Automaton a = this.clone();
        a.expandSingleton();
        return a;
    }

    Automaton cloneExpandedIfRequired() {
        if (allow_mutation) {
            this.expandSingleton();
            return this;
        }
        return this.cloneExpanded();
    }

    public Automaton clone() {
        try {
            Automaton a = (Automaton)super.clone();
            if (!this.isSingleton()) {
                HashMap<State, State> m = new HashMap<State, State>();
                Set<State> states = this.getStates();
                for (State s : states) {
                    m.put(s, new State());
                }
                for (State s : states) {
                    State p = (State)m.get(s);
                    p.accept = s.accept;
                    if (s == this.initial) {
                        a.initial = p;
                    }
                    for (Transition t : s.transitions) {
                        p.transitions.add(new Transition(t.min, t.max, (State)m.get(t.to)));
                    }
                }
            }
            return a;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    Automaton cloneIfRequired() {
        if (allow_mutation) {
            return this;
        }
        return this.clone();
    }

    public static Automaton load(URL url) throws IOException, OptionalDataException, ClassCastException, ClassNotFoundException, InvalidClassException {
        return Automaton.load(url.openStream());
    }

    public static Automaton load(InputStream stream) throws IOException, OptionalDataException, ClassCastException, ClassNotFoundException, InvalidClassException {
        ObjectInputStream s = new ObjectInputStream(stream);
        return (Automaton)s.readObject();
    }

    public void store(OutputStream stream) throws IOException {
        ObjectOutputStream s = new ObjectOutputStream(stream);
        s.writeObject(this);
        s.flush();
    }

    public static Automaton makeEmpty() {
        return BasicAutomata.makeEmpty();
    }

    public static Automaton makeEmptyString() {
        return BasicAutomata.makeEmptyString();
    }

    public static Automaton makeAnyString() {
        return BasicAutomata.makeAnyString();
    }

    public static Automaton makeAnyChar() {
        return BasicAutomata.makeAnyChar();
    }

    public static Automaton makeChar(char c) {
        return BasicAutomata.makeChar(c);
    }

    public static Automaton makeCharRange(char min, char max) {
        return BasicAutomata.makeCharRange(min, max);
    }

    public static Automaton makeCharSet(String set) {
        return BasicAutomata.makeCharSet(set);
    }

    public static Automaton makeInterval(int min, int max, int digits) throws IllegalArgumentException {
        return BasicAutomata.makeInterval(min, max, digits);
    }

    public static Automaton makeString(String s) {
        return BasicAutomata.makeString(s);
    }

    public static Automaton makeStringUnion(CharSequence ... strings) {
        return BasicAutomata.makeStringUnion(strings);
    }

    public static Automaton makeMaxInteger(String n) {
        return BasicAutomata.makeMaxInteger(n);
    }

    public static Automaton makeMinInteger(String n) {
        return BasicAutomata.makeMinInteger(n);
    }

    public static Automaton makeTotalDigits(int i) {
        return BasicAutomata.makeTotalDigits(i);
    }

    public static Automaton makeFractionDigits(int i) {
        return BasicAutomata.makeFractionDigits(i);
    }

    public static Automaton makeIntegerValue(String value) {
        return BasicAutomata.makeIntegerValue(value);
    }

    public static Automaton makeDecimalValue(String value) {
        return BasicAutomata.makeDecimalValue(value);
    }

    public static Automaton makeStringMatcher(String s) {
        return BasicAutomata.makeStringMatcher(s);
    }

    public Automaton concatenate(Automaton a) {
        return BasicOperations.concatenate(this, a);
    }

    public static Automaton concatenate(List<Automaton> l) {
        return BasicOperations.concatenate(l);
    }

    public Automaton optional() {
        return BasicOperations.optional(this);
    }

    public Automaton repeat() {
        return BasicOperations.repeat(this);
    }

    public Automaton repeat(int min) {
        return BasicOperations.repeat(this, min);
    }

    public Automaton repeat(int min, int max) {
        return BasicOperations.repeat(this, min, max);
    }

    public Automaton complement() {
        return BasicOperations.complement(this);
    }

    public Automaton minus(Automaton a) {
        return BasicOperations.minus(this, a);
    }

    public Automaton intersection(Automaton a) {
        return BasicOperations.intersection(this, a);
    }

    public boolean subsetOf(Automaton a) {
        return BasicOperations.subsetOf(this, a);
    }

    public Automaton union(Automaton a) {
        return BasicOperations.union(this, a);
    }

    public static Automaton union(Collection<Automaton> l) {
        return BasicOperations.union(l);
    }

    public void determinize() {
        BasicOperations.determinize(this);
    }

    public void addEpsilons(Collection<StatePair> pairs) {
        BasicOperations.addEpsilons(this, pairs);
    }

    public boolean isEmptyString() {
        return BasicOperations.isEmptyString(this);
    }

    public boolean isEmpty() {
        return BasicOperations.isEmpty(this);
    }

    public boolean isTotal() {
        return BasicOperations.isTotal(this);
    }

    public String getShortestExample(boolean accepted) {
        return BasicOperations.getShortestExample(this, accepted);
    }

    public boolean run(String s) {
        return BasicOperations.run(this, s);
    }

    public void minimize() {
        MinimizationOperations.minimize(this);
    }

    public static Automaton minimize(Automaton a) {
        a.minimize();
        return a;
    }

    public Automaton overlap(Automaton a) {
        return SpecialOperations.overlap(this, a);
    }

    public Automaton singleChars() {
        return SpecialOperations.singleChars(this);
    }

    public Automaton trim(String set, char c) {
        return SpecialOperations.trim(this, set, c);
    }

    public Automaton compress(String set, char c) {
        return SpecialOperations.compress(this, set, c);
    }

    public Automaton subst(Map<Character, Set<Character>> map) {
        return SpecialOperations.subst(this, map);
    }

    public Automaton subst(char c, String s) {
        return SpecialOperations.subst(this, c, s);
    }

    public Automaton homomorph(char[] source, char[] dest) {
        return SpecialOperations.homomorph(this, source, dest);
    }

    public Automaton projectChars(Set<Character> chars) {
        return SpecialOperations.projectChars(this, chars);
    }

    public boolean isFinite() {
        return SpecialOperations.isFinite(this);
    }

    public Set<String> getStrings(int length) {
        return SpecialOperations.getStrings(this, length);
    }

    public Set<String> getFiniteStrings() {
        return SpecialOperations.getFiniteStrings(this);
    }

    public Set<String> getFiniteStrings(int limit) {
        return SpecialOperations.getFiniteStrings(this, limit);
    }

    public String getCommonPrefix() {
        return SpecialOperations.getCommonPrefix(this);
    }

    public void prefixClose() {
        SpecialOperations.prefixClose(this);
    }

    public static Automaton hexCases(Automaton a) {
        return SpecialOperations.hexCases(a);
    }

    public static Automaton replaceWhitespace(Automaton a) {
        return SpecialOperations.replaceWhitespace(a);
    }

    public static String shuffleSubsetOf(Collection<Automaton> ca, Automaton a, Character suspend_shuffle, Character resume_shuffle) {
        return ShuffleOperations.shuffleSubsetOf(ca, a, suspend_shuffle, resume_shuffle);
    }

    public Automaton shuffle(Automaton a) {
        return ShuffleOperations.shuffle(this, a);
    }
}

