/*
 * Decompiled with CFR 0.152.
 */
package me.tuke.sktuke.expressions;

import ch.njol.skript.command.Commands;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.help.HelpTopic;

@Name(value="All commands")
@Description(value={"Used to get all registered commands.\nNew in 1.7.1: You can get only script commands if you need it."})
@Examples(value={"command /help [<text>]:\n\ttrigger:\n\t\tif all commands doesn't contain arg:\n\t\t\tsend \"Unknown command!\""})
@Since(value="1.6.9.7")
public class ExprAllCommand
extends SimpleExpression<String> {
    private boolean scriptsOnly = false;

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    public boolean isSingle() {
        return false;
    }

    public boolean init(Expression<?>[] arg, int arg1, Kleenean arg2, SkriptParser.ParseResult arg3) {
        this.scriptsOnly = arg3.expr.toLowerCase().contains("script");
        return true;
    }

    public String toString(@Nullable Event arg0, boolean arg1) {
        return this.scriptsOnly ? "all scripts command" : "all commands";
    }

    @Nullable
    protected String[] get(Event e) {
        if (this.scriptsOnly) {
            try {
                Field commands = Commands.class.getDeclaredField("commands");
                commands.setAccessible(true);
                Map cmds = (Map)commands.get(null);
                return cmds.keySet().toArray(new String[cmds.size()]);
            }
            catch (Exception commands) {}
        } else {
            ArrayList<String> cmds = new ArrayList<String>();
            for (HelpTopic ht : Bukkit.getHelpMap().getHelpTopics()) {
                cmds.add(ht.getName().startsWith("/") ? ht.getName().substring(1) : ht.getName());
            }
            return cmds.toArray(new String[cmds.size()]);
        }
        return null;
    }
}

