/*
 * Decompiled with CFR 0.152.
 */
package me.tuke.sktuke.customenchantment;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.tuke.sktuke.TuSKe;
import me.tuke.sktuke.customenchantment.AcceptedItems;
import me.tuke.sktuke.customenchantment.CustomEnchantment;
import org.apache.commons.lang.WordUtils;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;

public class EnchantConfig {
    public static File file = new File(TuSKe.getInstance().getDataFolder(), "enchantments.yml");
    public static YamlConfiguration y = new YamlConfiguration();
    public static Pattern p = Pattern.compile("(\\s+)?(.+)(\\s+)?$");
    public static final int MAX_LEVEL = 3999;
    public static final int DEFAULT_NUMBER = 3;
    public static final int MIN_NUMBER = 1;
    public static final int MAX_RARITY = 5;
    public static final boolean ENABLED = false;
    public static final boolean ENABLED_ON_ANVIL = true;
    public static final AcceptedItems ACCEPTED_ITEMS = AcceptedItems.ALL;

    public static void loadEnchants() {
        if (!file.exists()) {
            EnchantConfig.createNewFile();
        } else if (file.exists() && EnchantConfig.loadFile() && y.isConfigurationSection("Enchantments")) {
            try {
                for (String enchants : y.getConfigurationSection("Enchantments").getKeys(false)) {
                    ConfigurationSection cs = y.getConfigurationSection("Enchantments." + enchants);
                    if (cs.getString("Name") != null) {
                        int max;
                        if (CustomEnchantment.getByID(enchants) != null || CustomEnchantment.getByName(cs.getString("Name")) != null) {
                            TuSKe.log("Couldn't register the enchantment '" + enchants + "' because it has a repeated name or lore name.", Level.WARNING);
                            continue;
                        }
                        int rarity = max = 3;
                        boolean enabled = false;
                        boolean enabledOnAnvil = true;
                        if (cs.isSet("MaxLevel") && (!cs.isInt("MaxLevel") || cs.getInt("MaxLevel") <= 0 || cs.getInt("MaxLevel") > 3999)) {
                            TuSKe.log("The value of 'MaxLevel' from enchantment '" + enchants + "' is not between 1 and " + 20 + " or is not a valid value. Using the default value (" + 3 + ").", Level.WARNING);
                            cs.set("MaxLevel", (Object)3);
                        } else {
                            max = cs.getInt("MaxLevel");
                        }
                        if (cs.isSet("Rarity") && (!cs.isInt("Rarity") || cs.getInt("Rarity") <= 0 || cs.getInt("Rarity") > 5)) {
                            TuSKe.log("The value of 'Rarity' from enchantment '" + enchants + "' is not between 1 and 5 or is not a valid value. Using the default value (" + 3 + ").", Level.WARNING);
                            cs.set("Rarity", (Object)3);
                        } else {
                            rarity = cs.getInt("Rarity");
                        }
                        if (cs.isSet("AcceptedItems")) {
                            if (cs.getString("AcceptedItems").contains(",") || cs.getString("AcceptedItems").contains(" and ")) {
                                List<String> list = Arrays.asList(EnchantConfig.getArray(cs.getString("AcceptedItems")));
                                int x = 0;
                                while (x < list.size()) {
                                    if (!AcceptedItems.isValue(list.get(x).toUpperCase())) {
                                        list.remove(x);
                                        if (list.size() < 1) {
                                            cs.set("AcceptedItems", (Object)WordUtils.capitalize((String)ACCEPTED_ITEMS.name().toLowerCase()));
                                            TuSKe.log("There aren't any valid values for 'AcceptedItems'. Using the default value (" + WordUtils.capitalize((String)ACCEPTED_ITEMS.name().toLowerCase()) + ")", Level.WARNING);
                                        } else {
                                            TuSKe.log("'" + list.get(x) + "' is not a valid value for 'AcceptedItems'. Ignoring it...", Level.WARNING);
                                        }
                                    }
                                    ++x;
                                }
                            } else if (!AcceptedItems.isValue(cs.getString("AcceptedItems").toUpperCase().replaceAll(" ", ""))) {
                                TuSKe.log("The value of 'AcceptedItems' from enchantment '" + enchants + "' is not a valid value. Using the default value (" + WordUtils.capitalize((String)ACCEPTED_ITEMS.name().toLowerCase()) + ").");
                                cs.set("AcceptedItems", null);
                            }
                        }
                        if (cs.isSet("Enabled") && !cs.isBoolean("Enabled")) {
                            cs.set("Enabled", null);
                        } else if (cs.isBoolean("Enabled")) {
                            enabled = cs.getBoolean("Enabled");
                        }
                        if (cs.isSet("Enabled") && !cs.isBoolean("Enabled")) {
                            cs.set("EnabledOnAnvil", null);
                        } else if (cs.isBoolean("Enabled")) {
                            enabledOnAnvil = cs.getBoolean("Enabled");
                        }
                        CustomEnchantment.registerNewEnchantment(enchants, cs.getString("Name"), max, rarity, AcceptedItems.getArrayList(EnchantConfig.getArray(cs.isSet("AcceptedItems") ? cs.getString("AcceptedItems") : "")), enabled, enabledOnAnvil, EnchantConfig.getArray(cs.isSet("Conflicts") ? cs.getString("Conflicts") : ""));
                        continue;
                    }
                    TuSKe.log("The enchantment '" + enchants + "' doesn't have a correct name. Skipping it.", Level.WARNING);
                }
                CustomEnchantment.stopRegistration();
                if (!y.isInt("Config.MaxEnchantmentsPerItem")) {
                    if (y.isInt("Config.MaxEnchantsPerItem")) {
                        y.set("Config.MaxEnchantsPerItem", null);
                    } else {
                        TuSKe.log("Wrong value for 'MaxEnchantPerItem'. Using the default value (4).", Level.WARNING);
                    }
                    y.set("Config.MaxEnchantmentsPerItem", (Object)4);
                    EnchantConfig.save();
                }
                if (!y.isBoolean("Config.CompatibilityMode")) {
                    y.set("Config.CompatibilityMode", (Object)false);
                    TuSKe.log("Wrong value for 'CompatibilityMode'. Using the default value (false).", Level.WARNING);
                }
                if (!y.isInt("Config.GlobalRarity")) {
                    y.set("Config.GlobalRarity", (Object)5);
                    EnchantConfig.save();
                } else if (y.getInt("Config.GlobalRarity") < 1 || y.getInt("Config.GlobalRarity") > 5) {
                    y.set("Config.GlobalRarity", (Object)5);
                    TuSKe.log("Wrong value for 'GlobalRarity', only accepts integers between 1 and 5. Using the default value (5).", Level.WARNING);
                }
            }
            catch (Exception e) {
                TuSKe.log("A error has occured when trying to load the enchantments file. Checks if hasn't any wrong values. \n" + e, Level.SEVERE);
            }
        }
    }

    public static boolean loadFile() {
        if (file.exists()) {
            try {
                y.load(file);
                return true;
            }
            catch (Exception e) {
                TuSKe.log("Couldn't load the enchantments file, probably there are wrong values. But if you think everything is right, ask for support using this message and the enchantment file. \n\n" + e.getMessage(), Level.SEVERE);
            }
        }
        return false;
    }

    public static void createNewFile() {
        if (!file.exists()) {
            try {
                TuSKe.getInstance().saveResource("enchantments.yml", false);
            }
            catch (Exception e) {
                TuSKe.log("Error occurred when creating a new enchantment file: \n" + e.getMessage(), Level.SEVERE);
            }
        }
    }

    public static void save() {
        if (file.exists()) {
            try {
                y.save(file);
            }
            catch (Exception e) {
                TuSKe.log("Error occurred when saving enchantment file: \n" + e.getMessage(), Level.SEVERE);
            }
        }
    }

    public static int getGlobalRarity() {
        return y.getInt("Config.GlobalRarity");
    }

    public static void reload() {
        file = new File(TuSKe.getInstance().getDataFolder(), "enchantments.yml");
        CustomEnchantment.clear();
        CustomEnchantment.acceptRegistration(true);
        if (EnchantConfig.loadFile()) {
            EnchantConfig.loadEnchants();
        }
    }

    public static String[] getArray(String str) {
        String[] res = str.replaceAll(" and ", ",").split(",");
        int x = 0;
        while (x < res.length) {
            Matcher m = p.matcher(res[x]);
            if (m.find()) {
                res[x] = m.group(2);
            }
            ++x;
        }
        return res;
    }
}

