/*
 * Decompiled with CFR 0.152.
 */
package me.tuke.sktuke;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import me.tuke.sktuke.GitHubUpdater;
import me.tuke.sktuke.Metrics;
import me.tuke.sktuke.SimpleConfig;
import me.tuke.sktuke.customenchantment.CustomEnchantment;
import me.tuke.sktuke.customenchantment.EnchantConfig;
import me.tuke.sktuke.customenchantment.EnchantManager;
import me.tuke.sktuke.documentation.Documentation;
import me.tuke.sktuke.gui.GUIManager;
import me.tuke.sktuke.nms.NMS;
import me.tuke.sktuke.nms.ReflectionNMS;
import me.tuke.sktuke.recipe.RecipeManager;
import me.tuke.sktuke.register.Register;
import me.tuke.sktuke.util.LegendConfig;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class TuSKe
extends JavaPlugin {
    private static NMS nms;
    private static TuSKe plugin;
    private static long time;
    private static GUIManager gui;
    private static RecipeManager recipes;
    private GitHubUpdater updater;
    private static Register reg;
    private static Documentation docs;

    static {
        time = System.currentTimeMillis();
        gui = new GUIManager();
        recipes = new RecipeManager();
    }

    public void onEnable() {
        plugin = this;
        reg = new Register(this);
        if (reg.hasPlugin("Skript")) {
            this.loadConfig();
            TuSKe.getNMS();
            docs = new Documentation(this, this.getConfig().getBoolean("documentation.enabled"));
            Integer[] result = reg.load();
            if (result == null) {
                return;
            }
            this.updater = new GitHubUpdater(this, this.getFile(), "Tuke-Nuke/TuSKe");
            if (this.getConfig().getBoolean("use_metrics")) {
                try {
                    Metrics metrics = new Metrics((Plugin)this);
                    metrics.start();
                    TuSKe.log("Enabling Metrics... Done!");
                }
                catch (IOException e) {
                    TuSKe.log("A error occured while trying to start the Metrics.");
                }
            }
            double d = result[4] / 1000;
            TuSKe.log("Loaded sucessfully a total of " + result[0] + " events, " + result[1] + " conditions, " + result[2] + " expressions and " + result[3] + " effects in " + d + " seconds. Enjoy ^-^");
            if (this.getConfig().getBoolean("updater.check_for_new_update")) {
                this.checkUpdate();
            }
            Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)this, new Runnable(){

                @Override
                public void run() {
                    docs.generateDocs();
                    if (docs.isEnabled()) {
                        TuSKe.log("Documentation was generated correctly.");
                    }
                    docs = null;
                }
            }, 100L);
        } else {
            TuSKe.log("Error 404 - Skript not found.", Level.SEVERE);
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
        }
    }

    public void onDisable() {
        gui.clearAll();
        HandlerList.unregisterAll((Plugin)this);
        Bukkit.getScheduler().cancelTasks((Plugin)this);
        if (this.getConfig().getBoolean("updater.check_for_new_update") && this.getConfig().getBoolean("updater.auto_update") && this.updater.hasDownloadReady(true)) {
            this.updater.updatePlugin();
        }
    }

    public boolean onCommand(final CommandSender sender, Command cmd, String label, String[] arg) {
        if (cmd.getName().equalsIgnoreCase("tuske")) {
            if (arg.length > 0 && arg[0].equalsIgnoreCase("update")) {
                if (arg.length > 1 && arg[1].equalsIgnoreCase("download")) {
                    if (this.updater.hasDownloadReady(false) && this.getConfig().getBoolean("updater.auto_update")) {
                        sender.sendMessage("\u00a7e[\u00a7cTuSKe\u00a7e] \u00a73Already have a downloaded file ready to be updated.");
                    } else if (!this.updater.isLatestVersion()) {
                        sender.sendMessage("\u00a7e[\u00a7cTuSKe\u00a7e] \u00a73Downloading the latest version...");
                        if (!this.updater.downloadLatest()) {
                            sender.sendMessage("\u00a73A error occured when trying to download latest version. Maybe SkUnity is down?");
                        } else {
                            sender.sendMessage("\u00a73The latest version was been dowloaded to TuSKe's folder.");
                        }
                    } else {
                        sender.sendMessage("\u00a7e[\u00a7cTuSKe\u00a7e] \u00a73The plugin is already running the latest version!");
                    }
                } else if (arg.length > 1 && arg[1].equalsIgnoreCase("plugin")) {
                    if (!this.getConfig().getBoolean("updater.check_for_new_update")) {
                        sender.sendMessage("\u00a7e[\u00a7cTuSKe\u00a7e] \u00a73The option 'check_for_new_update', in config file, needs to be true to check for updates.");
                    } else if (!this.updater.isLatestVersion() || this.updater.hasDownloadReady(true)) {
                        if (!this.updater.hasDownloadReady(false) && !this.updater.downloadLatest()) {
                            sender.sendMessage("\u00a7e[\u00a7cTuSKe\u00a7e] \u00a73A error occured when trying to download latest version. Maybe SkUnity is down?");
                            return true;
                        }
                        this.getConfig().set("updater.auto_update", (Object)true);
                        sender.sendMessage("\u00a7e[\u00a7cTuSKe\u00a7e] \u00a73The plugin will update when the server restarts.");
                    } else {
                        sender.sendMessage("\u00a7e[\u00a7cTuSKe\u00a7e] \u00a73The plugin is already running the latest version!");
                    }
                } else if (arg.length > 1 && arg[1].equalsIgnoreCase("check")) {
                    sender.sendMessage("\u00a7e[\u00a7cTuSKe\u00a7e] \u00a73Checking for update...");
                    this.updater.checkForUpdate(true);
                    Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)this, new Runnable(){

                        @Override
                        public void run() {
                            if (!TuSKe.this.updater.isLatestVersion()) {
                                sender.sendMessage("\u00a7e[\u00a7cTuSKe\u00a7e] \u00a73New update available: \u00a7cv" + TuSKe.this.updater.getLatestVersion());
                                if (sender instanceof Player) {
                                    TuSKe.this.sendDownloadRaw(sender);
                                } else {
                                    sender.sendMessage(new String[]{"\u00a73Check what's new: \u00a7c" + TuSKe.this.updater.getDownloadURL(), "\u00a73You can download and update it with \u00a7c/tuske update\u00a73."});
                                }
                            } else {
                                sender.sendMessage("\u00a7e[\u00a7cTuSKe\u00a7e] \u00a73You are running the latest version: \u00a7cv" + TuSKe.this.updater.getLatestVersion());
                            }
                        }
                    }, 1L);
                } else {
                    sender.sendMessage(new String[]{"\u00a7e[\u00a7cTuSKe\u00a7e] \u00a73Main commands of \u00a7c" + arg[0] + "\u00a73:", "\u00a74/\u00a7c" + label + " " + arg[0] + " check \u00a7e> \u00a73Check for latest update.", "\u00a74/\u00a7c" + label + " " + arg[0] + " download \u00a7e> \u00a73Download the lateast update.", "\u00a74/\u00a7c" + label + " " + arg[0] + " plugin \u00a7e> \u00a73Update the plugin after the server restarts."});
                }
            } else if (arg.length > 0 && arg[0].equalsIgnoreCase("reload")) {
                if (arg.length > 1 && arg[1].equalsIgnoreCase("config")) {
                    this.reloadConfig();
                    this.loadConfig();
                    sender.sendMessage("\u00a7e[\u00a7cTuSKe\u00a7e] \u00a73Config reloaded!");
                } else if (arg.length > 1 && arg[1].equalsIgnoreCase("enchantments")) {
                    EnchantConfig.reload();
                    if (CustomEnchantment.getEnchantments().size() == 0) {
                        sender.sendMessage("\u00a7e[\u00a7cTuSKe\u00a7e] \u00a73No enchantments were loaded. :(");
                    } else {
                        sender.sendMessage("\u00a7e[\u00a7cTuSKe\u00a7e] \u00a73A total of \u00a7c" + CustomEnchantment.getEnchantments().size() + "\u00a73custom enchantments were loaded succesfully.");
                    }
                } else {
                    sender.sendMessage(new String[]{"\u00a7e[\u00a7cTuSKe\u00a7e] \u00a73Main commands of \u00a7c" + arg[0] + "\u00a73:", "\u00a74/\u00a7c" + label + " " + arg[0] + " config \u00a7e> \u00a73Reload the config.", "\u00a74/\u00a7c" + label + " " + arg[0] + " enchantments \u00a7e> \u00a73Reload the enchantments' file."});
                }
            } else if (arg.length > 0 && arg[0].matches("ench(antment)?")) {
                if (arg.length > 1 && arg[1].equalsIgnoreCase("list")) {
                    sender.sendMessage(new String[]{"\u00a7e[\u00a7cTuSKe\u00a7e] \u00a73All registred enchantments:", "      \u00a7eName       \u00a7c-\u00a7e ML \u00a7c-\u00a7e R \u00a7c-\u00a7e Enabled?"});
                    for (CustomEnchantment c : CustomEnchantment.getEnchantments()) {
                        sender.sendMessage("\u00a7c" + this.left(c.getId(), 15) + " \u00a74-\u00a7c  " + c.getMaxLevel() + "  \u00a74-\u00a7c " + c.getRarity() + " \u00a74- " + (c.isEnabledOnAnvil() ? "\u00a7a" : "\u00a7c") + c.isEnabledOnTable());
                    }
                } else if (arg.length > 1 && arg[1].equalsIgnoreCase("toggle")) {
                    String ench = this.getEnchantment(arg, 2);
                    if (arg.length > 2 && EnchantManager.isCustomByID(ench)) {
                        CustomEnchantment ce;
                        ce.setEnabledOnTable(!(ce = CustomEnchantment.getByID(ench)).isEnabledOnTable());
                        sender.sendMessage("\u00a7e[\u00a7cTuSKe\u00a7e] \u00a73The enchantment \u00a7c" + ce.getId() + "\u00a73 was " + (ce.isEnabledOnTable() ? "\u00a7aenabled" : "\u00a7cdisabled") + "!");
                    } else if (arg.length > 2 && !EnchantManager.isCustomByID(ench)) {
                        sender.sendMessage("\u00a7e[\u00a7cTuSKe\u00a7e] \u00a73There isn't any registred enchantment with ID \u00a7c" + ench + "\u00a73.");
                    } else {
                        sender.sendMessage(new String[]{"\u00a7e[\u00a7cTuSKe\u00a7e] \u00a73Use this command to enable/disable a enchantment.", "\u00a74/\u00a7c" + label + " " + arg[0] + " toggle \u00a74<\u00a7cID\u00a74> \u00a7e> \u00a73Enable/disable a enchantment."});
                    }
                } else if (arg.length > 1 && arg[1].equalsIgnoreCase("give")) {
                    if (sender instanceof Player) {
                        String ench = this.getEnchantment(arg, 2);
                        if (arg.length > 2 && EnchantManager.isCustomByID(ench)) {
                            Integer lvl = arg.length > 3 && this.isInteger(arg[arg.length - 1]) ? Integer.valueOf(arg[arg.length - 1]) : 1;
                            CustomEnchantment ce = CustomEnchantment.getByID(ench);
                            Player p = (Player)sender;
                            ItemStack i = p.getInventory().getItem(p.getInventory().getHeldItemSlot());
                            if (i != null && !i.getType().equals((Object)Material.AIR)) {
                                if (ce.isCompatible(i)) {
                                    if (!EnchantManager.addToItem(p.getInventory().getItem(p.getInventory().getHeldItemSlot()), ce, lvl, true)) {
                                        sender.sendMessage("\u00a7e[\u00a7cTuSKe\u00a7e] \u00a73The enchantment \u00a7c" + ce.getId() + "\u00a73 couldn't be added to your held item.");
                                    } else {
                                        sender.sendMessage("\u00a7e[\u00a7cTuSKe\u00a7e] \u00a73The enchantment \u00a7c" + ce.getId() + "\u00a73 was added to your held item.");
                                    }
                                } else {
                                    sender.sendMessage("\u00a7e[\u00a7cTuSKe\u00a7e] \u00a73The enchantment \u00a7c" + ce.getId() + "\u00a73 doesn't accept this item.");
                                }
                            } else {
                                sender.sendMessage("\u00a7e[\u00a7cTuSKe\u00a7e] \u00a73You have to hold a item first.");
                            }
                        } else if (arg.length > 2 && !EnchantManager.isCustomByID(ench)) {
                            sender.sendMessage("\u00a7e[\u00a7cTuSKe\u00a7e] \u00a73There isn't any registred enchantment with ID \u00a7c" + ench + "\u00a73.");
                        } else {
                            sender.sendMessage(new String[]{"\u00a7e[\u00a7cTuSKe\u00a7e] \u00a73Use this command to enchant your held item.", "\u00a74/\u00a7c" + label + " " + arg[0] + " give \u00a74<\u00a7cID\u00a74> \u00a7c[\u00a74<\u00a7cLevel\u00a74>\u00a7c] \u00a7e> \u00a73Add a enchantment to your held item."});
                        }
                    } else {
                        sender.sendMessage("\u00a7e[\u00a7cTuSKe\u00a7e] \u00a73This command is only for players.");
                    }
                } else {
                    sender.sendMessage(new String[]{"\u00a7e[\u00a7cTuSKe\u00a7e] \u00a73Main commands of \u00a7c" + arg[0] + "\u00a73:", "\u00a74/\u00a7c" + label + " " + arg[0] + " list \u00a7e> \u00a73Shows a list of registred items.", "\u00a74/\u00a7c" + label + " " + arg[0] + " toggle \u00a7e> \u00a73Enable/disable a enchantment.", "\u00a74/\u00a7c" + label + " " + arg[0] + " give \u00a7e> \u00a73Add a enchantment to your held item."});
                }
            } else {
                sender.sendMessage(new String[]{"\u00a7e[\u00a7cTuSKe\u00a7e] \u00a73Main commands:", "\u00a74/\u00a7c" + label + " reload \u00a7e> \u00a73Reload config/enchantments.", "\u00a74/\u00a7c" + label + " update \u00a7e> \u00a73Check for latest update.", "\u00a74/\u00a7c" + label + " ench \u00a7e> \u00a73Manage the enchantments."});
            }
        }
        return true;
    }

    private String getEnchantment(String[] str, int id) {
        StringBuilder sb = new StringBuilder();
        sb.append("");
        int x = id;
        while (x < str.length) {
            if (x != str.length - 1 || !this.isInteger(str[x])) {
                sb.append(str[x]);
                if (x < str.length - 2) {
                    sb.append(" ");
                }
            }
            ++x;
        }
        if (sb.toString().equals("") && str.length > id) {
            sb.append(str[id]);
        }
        return sb.toString();
    }

    private boolean isInteger(String arg) {
        return arg.matches("\\d+");
    }

    private String left(String s, int d) {
        StringBuilder sb = new StringBuilder(d);
        sb.append(s);
        while (sb.length() < d) {
            sb.append(" ");
        }
        return sb.toString();
    }

    private void loadConfig() {
        SimpleConfig sc = new SimpleConfig(this);
        sc.loadDefault();
        File f = new File(this.getDataFolder(), "config.yml");
        if (!f.exists()) {
            try {
                if (!this.getDataFolder().exists()) {
                    this.getDataFolder().mkdirs();
                }
                f.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        sc.save(f);
    }

    private void sendDownloadRaw(CommandSender s) {
        if (s instanceof Player) {
            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)("tellraw " + s.getName() + " [{\"text\":\"\\u00a73Click \"},{\"text\":\"\\u00a7chere\",\"hoverEvent\":{\"action\":\"show_text\",\"value\":\"\\u00a73Link to\n\\u00a77Git\u00a78Hub\"},\"clickEvent\":{\"action\":\"open_url\",\"value\":\"http://" + this.updater.getDownloadURL() + "\"}},{\"text\":\" \\u00a73to \\u00a73see \\u00a73what's \\u00a73new, \\u00a73click \"}, {\"text\":\"\\u00a7chere\",\"hoverEvent\":{\"action\":\"show_text\",\"value\":\"\\u00a73Link to download\"},\"clickEvent\":{\"action\":\"open_url\",\"value\":\"" + this.updater.getDownloadURL() + "\"}},{\"text\":\" \\u00a73to \\u00a73download \\u00a73or \\u00a73use \\u00a73the \\u00a73command \"},{\"text\":\"\\u00a7c/tuske \\u00a7cupdate \\u00a7cdownload\",\"clickEvent\":{\"action\":\"suggest_command\",\"value\":\"/tuske update download\"}},{\"text\":\" \\u00a73to \\u00a73download \\u00a73directly \\u00a73to \\u00a73TuSKe's \\u00a73folder. \\u00a73And \\u00a73you \\u00a73can \\u00a73use \"},{\"text\":\"\\u00a7c/tuske \\u00a7cupdate \\u00a7cplugin\",\"clickEvent\":{\"action\":\"suggest_command\",\"value\":\"/tuske update plugin\"}}]"));
        }
    }

    public static RecipeManager getRecipeManager() {
        return recipes;
    }

    public static GUIManager getGUIManager() {
        return gui;
    }

    public static LegendConfig getLegendConfig() {
        return TuSKe.reg.config;
    }

    public static Documentation getDocumentation() {
        return docs;
    }

    public static void log(String msg) {
        TuSKe.log(msg, Level.INFO);
    }

    public static void log(String msg, Level lvl) {
        plugin.getLogger().log(lvl, msg);
    }

    public static void log(Level lvl, String ... msgs) {
        String[] stringArray = msgs;
        int n = msgs.length;
        int n2 = 0;
        while (n2 < n) {
            String msg = stringArray[n2];
            TuSKe.log(msg, lvl);
            ++n2;
        }
    }

    public static void debug(Object ... objects) {
        if (!plugin.getConfig().getBoolean("debug_mode")) {
            return;
        }
        TuSKe.log("[Debug] " + StringUtils.join((Object[])objects, (String)" || "));
    }

    public static TuSKe getInstance() {
        return plugin;
    }

    public static NMS getNMS() {
        if (nms == null) {
            String rversion = Bukkit.getServer().getClass().getPackage().getName().split(".v")[1];
            try {
                Class<?> classs = Class.forName("me.tuke.sktuke.nms.M_" + rversion);
                nms = (NMS)classs.newInstance();
            }
            catch (Exception e) {
                nms = new ReflectionNMS(rversion);
                TuSKe.log("Couldn't find support for the Bukkit version '" + rversion + "'. Some expressions, such as \"player data of %offline player%\", may or may not work fine, so it's better to ask the developer about it.", Level.WARNING);
            }
        }
        return nms;
    }

    public static boolean isSpigot() {
        try {
            if (Player.class.getDeclaredMethod("spigot", new Class[0]) != null) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private void checkUpdate() {
        Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)this, new Runnable(){

            @Override
            public void run() {
                TuSKe.log("Checking for latest update...");
                TuSKe.this.updater.checkForUpdate(true);
                if (TuSKe.this.updater.getLatestVersion() != null) {
                    if (!TuSKe.this.updater.isLatestVersion()) {
                        if (TuSKe.this.getConfig().getBoolean("updater.auto_update")) {
                            if (TuSKe.this.updater.downloadLatest()) {
                                TuSKe.log("Downloaded the latest version. The plugin will be updated when the server restarts.");
                            } else {
                                TuSKe.log("A error occurred while checking for new updates.\n" + TuSKe.this.updater.getLastException().getMessage());
                            }
                        } else {
                            TuSKe.log("New update available: v" + TuSKe.this.updater.getLatestVersion());
                            TuSKe.log("Check what's new in: " + TuSKe.this.updater.getDownloadURL());
                            TuSKe.log("You can download and update it with /tuske update.");
                        }
                    } else {
                        TuSKe.log("No new update was found!");
                    }
                }
            }
        }, 10L);
    }

    public static Long getTime() {
        return time;
    }
}

