/*
 * Decompiled with CFR 0.152.
 */
package me.tuke.sktuke.documentation;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.util.StringUtils;
import java.util.ArrayList;
import me.tuke.sktuke.documentation.SyntaxType;

public class Syntax {
    private String name;
    private String since;
    private String[] desc;
    private String[] examples;
    private String[] syntaxes;
    private Class<?> returnType;
    private Expression<?> expr;
    private SyntaxType type;

    public Syntax(Expression<?> expr, SyntaxType type, String ... syntaxes) {
        this.name = expr.getClass().getSimpleName();
        if (expr.getClass().isAnnotationPresent(Name.class)) {
            this.name = expr.getClass().getAnnotation(Name.class).value();
        }
        if (expr.getClass().isAnnotationPresent(Description.class)) {
            this.desc = expr.getClass().getAnnotation(Description.class).value();
        }
        if (expr.getClass().isAnnotationPresent(Examples.class)) {
            this.examples = expr.getClass().getAnnotation(Examples.class).value();
        }
        if (expr.getClass().isAnnotationPresent(Since.class)) {
            this.since = expr.getClass().getAnnotation(Since.class).value();
        }
        this.returnType = expr.getReturnType();
        this.expr = expr;
        this.syntaxes = syntaxes;
        this.type = type;
    }

    public Syntax(String name, String[] description, String[] syntaxes, String[] examples, String since, SyntaxType type) {
        this.name = name;
        this.desc = description;
        this.syntaxes = syntaxes;
        this.examples = examples;
        this.since = since;
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public String getSince() {
        return this.since;
    }

    public String getChangers() {
        if (this.expr != null) {
            ArrayList<String> changers = new ArrayList<String>();
            Changer.ChangeMode[] changeModeArray = Changer.ChangeMode.values();
            int n = changeModeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Changer.ChangeMode cm = changeModeArray[n2];
                if (this.expr.acceptChange(cm) != null) {
                    changers.add(cm.name().toLowerCase());
                }
                ++n2;
            }
            if (changers.size() == 0) {
                return "none";
            }
            return StringUtils.join(changers, (String)", ");
        }
        return null;
    }

    public String[] getDescription() {
        return this.desc;
    }

    public String[] getExamples() {
        return this.examples;
    }

    public String[] getSyntaxes() {
        return this.syntaxes;
    }

    public Class<?> getReturnType() {
        return this.returnType;
    }

    public SyntaxType getType() {
        return this.type;
    }
}

