/*
 * Decompiled with CFR 0.152.
 */
package me.tuke.sktuke;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.bukkit.plugin.java.JavaPlugin;

public class GitHubUpdater {
    private JavaPlugin PLUGIN;
    private File PLUGIN_JAR;
    private String URL = null;
    private String UPDATE_TITLE = null;
    private String LATEST_VERSION = null;
    private Exception lastException = null;

    public GitHubUpdater(JavaPlugin instance, File pluginFile, String gitHubUrl) {
        this.PLUGIN = instance;
        this.PLUGIN_JAR = pluginFile;
        this.URL = gitHubUrl;
    }

    public void checkForUpdate(final boolean showMessageError) throws IllegalArgumentException {
        Thread updater = new Thread(new Runnable(){

            @Override
            public void run() {
                block5: {
                    try {
                        HttpURLConnection github = (HttpURLConnection)new URL(GitHubUpdater.this.getURL()).openConnection();
                        github.setRequestProperty("User-Agent", "Mozilla/5.0");
                        String page = IOUtils.toString((InputStream)github.getInputStream(), (String)"UTF-8");
                        Pattern p = Pattern.compile("<a href=\"/" + GitHubUpdater.this.URL + "/releases/tag/(.+)\">(.+)</a>");
                        Matcher m = p.matcher(page);
                        if (m.find()) {
                            GitHubUpdater.this.LATEST_VERSION = m.group(1);
                            GitHubUpdater.this.UPDATE_TITLE = m.group(2);
                        }
                        return;
                    }
                    catch (MalformedURLException e) {
                        GitHubUpdater.this.lastException = e;
                        if (showMessageError) {
                            GitHubUpdater.this.PLUGIN.getLogger().severe("The updater couldn't get the link of the latest version.\n" + e.getMessage());
                        }
                    }
                    catch (IOException e) {
                        GitHubUpdater.this.lastException = e;
                        if (!showMessageError) break block5;
                        GitHubUpdater.this.PLUGIN.getLogger().warning("An unexpected error occurred when trying to check for latest update. Maybe GitHub is down?");
                    }
                }
                GitHubUpdater.this.LATEST_VERSION = null;
                GitHubUpdater.this.UPDATE_TITLE = null;
            }
        }, "TuSKe's Updater");
        updater.run();
    }

    public void updatePlugin() {
        if (this.hasDownloadReady(true)) {
            File jarNew = new File(this.PLUGIN.getDataFolder(), String.valueOf(this.PLUGIN.getName()) + ".jar");
            File jarOld = new File("plugins" + File.separator, this.PLUGIN_JAR.getName());
            try {
                jarOld.delete();
                FileUtils.copyFileToDirectory((File)jarNew, (File)new File("plugins" + File.separator));
                jarNew.delete();
            }
            catch (IOException e) {
                this.lastException = e;
                this.PLUGIN.getLogger().severe("An unexpected error occurred when trying to update the plugin.\n" + e.getMessage());
            }
        }
    }

    public String getURL() {
        return "https://github.com/" + this.URL + "/releases" + (!this.PLUGIN.getConfig().getBoolean("updater.download_pre_releases") ? "/latest" : "");
    }

    public String getUpdateTitle() {
        return this.UPDATE_TITLE;
    }

    public String getLatestVersion() {
        return this.LATEST_VERSION;
    }

    public String getDownloadURL() {
        return "https://github.com/" + this.URL + "/releases/tag/" + this.LATEST_VERSION;
    }

    public boolean isLatestVersion() {
        return this.PLUGIN.getDescription().getVersion().equals(this.LATEST_VERSION);
    }

    public boolean hasDownloadReady(boolean ignoreVersion) {
        return new File(this.PLUGIN.getDataFolder(), String.valueOf(this.PLUGIN.getName()) + ".jar").exists() && (ignoreVersion || !this.isLatestVersion());
    }

    public boolean downloadLatest() {
        try {
            HttpURLConnection download = (HttpURLConnection)new URL("https://github.com/" + this.URL + "/releases/download/" + this.LATEST_VERSION + "/" + this.PLUGIN.getName() + ".jar").openConnection();
            download.setRequestProperty("User-Agent", "Mozilla/5.0");
            File f = new File(this.PLUGIN.getDataFolder(), String.valueOf(this.PLUGIN.getName()) + ".jar");
            if (f.exists()) {
                f.delete();
            }
            FileUtils.copyInputStreamToFile((InputStream)download.getInputStream(), (File)f);
            return true;
        }
        catch (Exception e) {
            this.lastException = e;
            return false;
        }
    }

    @Deprecated
    public Exception getLastException() {
        return this.lastException;
    }
}

