/*
 * Decompiled with CFR 0.152.
 */
package me.tuke.sktuke.recipe;

import java.util.Arrays;
import java.util.HashSet;
import me.tuke.sktuke.TuSKe;
import me.tuke.sktuke.recipe.CustomFurnaceRecipe;
import me.tuke.sktuke.recipe.CustomShapedRecipe;
import me.tuke.sktuke.recipe.CustomShapelessRecipe;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.inventory.FurnaceRecipe;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.plugin.Plugin;

public class RecipeManager
implements Listener {
    private HashSet<Recipe> recipes = new HashSet();

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPrepare(PrepareItemCraftEvent e) {
        Recipe rec = this.getIfContainsCustomRecipe(e.getRecipe());
        if (rec != null && !this.areArrayItemsEqual(this.getItems(rec), e.getInventory().getMatrix(), true)) {
            e.getInventory().setResult(new ItemStack(Material.AIR));
        }
    }

    public void registerRecipe(Recipe rec) {
        if (rec instanceof CustomShapedRecipe || rec instanceof CustomShapelessRecipe || rec instanceof CustomFurnaceRecipe) {
            if (this.getIfContainsCustomRecipe(rec) != null) {
                return;
            }
            if (this.getItems(rec) != null) {
                this.recipes.add(rec);
                if (this.recipes.size() == 1) {
                    Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)TuSKe.getInstance());
                }
            }
        }
        Bukkit.addRecipe((Recipe)rec);
    }

    public Recipe getIfContainsCustomRecipe(Recipe rec) {
        for (Recipe recipe : this.recipes) {
            if (!this.areEqual(recipe, rec)) continue;
            return recipe;
        }
        return null;
    }

    public boolean areEqual(Recipe recipe1, Recipe recipe2) {
        return recipe1.getResult().isSimilar(recipe2.getResult()) && this.areArrayItemsEqual(this.getItems(recipe1), this.getItems(recipe2), false);
    }

    public boolean areArrayItemsEqual(ItemStack[] item1, ItemStack[] item2, boolean sameItemMeta) {
        return this.compareArrayItems(item1, item2, sameItemMeta) != null;
    }

    public boolean arrayItemsContains(ItemStack[] item1, ItemStack[] item2) {
        return Arrays.asList(item2).containsAll(Arrays.asList(item1));
    }

    public boolean arrayItemsContains2(ItemStack[] item1, ItemStack[] item2) {
        int count = 0;
        int x = 0;
        while (x < item1.length) {
            int y = 0;
            while (y < item2.length) {
                if (item1[x] != null && item2[y] != null && item1[x].isSimilar(item2[y]) && ++count == item1.length) {
                    return true;
                }
                ++y;
            }
            ++x;
        }
        return false;
    }

    public ItemStack[] compareArrayItems(ItemStack[] item1, ItemStack[] item2, boolean sameItemMeta) {
        if (!sameItemMeta) {
            int x = 0;
            while (x < item1.length) {
                if (item1[x] == null) {
                    item1[x] = new ItemStack(Material.AIR);
                }
                if (item2[x] == null) {
                    item2[x] = new ItemStack(Material.AIR);
                }
                if (item1[x].getDurability() == Short.MAX_VALUE) {
                    item1[x].setDurability((short)0);
                }
                if (item1[x].getType() != item2[x].getType() && item1[x].getAmount() > item2[x].getAmount() && item1[x].getDurability() != item2[x].getDurability()) {
                    return null;
                }
                ++x;
            }
        } else {
            int x = 0;
            while (x < item1.length) {
                if (item1[x] == null) {
                    item1[x] = new ItemStack(Material.AIR);
                }
                if (item2[x] == null) {
                    item2[x] = new ItemStack(Material.AIR);
                }
                if (item1[x].getDurability() == Short.MAX_VALUE) {
                    item1[x].setDurability((short)0);
                }
                if (!item1[x].isSimilar(item2[x])) {
                    return null;
                }
                ++x;
            }
        }
        return item1;
    }

    public ItemStack[] getItems(Recipe rec) {
        if (rec instanceof CustomShapedRecipe) {
            return ((CustomShapedRecipe)rec).getIngredients();
        }
        if (rec instanceof CustomShapelessRecipe) {
            return ((CustomShapelessRecipe)rec).getIngredients();
        }
        if (rec instanceof CustomFurnaceRecipe) {
            return new ItemStack[]{((CustomFurnaceRecipe)rec).getSource()};
        }
        if (rec instanceof ShapedRecipe) {
            return ((ShapedRecipe)rec).getIngredientMap().values().toArray(new ItemStack[((ShapedRecipe)rec).getIngredientMap().size()]);
        }
        if (rec instanceof ShapelessRecipe) {
            return ((ShapelessRecipe)rec).getIngredientList().toArray(new ItemStack[((ShapelessRecipe)rec).getIngredientList().size()]);
        }
        return new ItemStack[]{((FurnaceRecipe)rec).getInput()};
    }

    public ItemStack[] replaceNullIfContains(ItemStack[] items) {
        int x = 0;
        while (x < items.length) {
            if (items[x] == null) {
                items[x] = new ItemStack(Material.AIR);
            }
            ++x;
        }
        return items;
    }
}

