/*
 * Decompiled with CFR 0.152.
 */
package me.tuke.sktuke.recipe;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import me.tuke.sktuke.TuSKe;
import me.tuke.sktuke.recipe.CustomFurnaceRecipe;
import me.tuke.sktuke.recipe.CustomShapedRecipe;
import me.tuke.sktuke.recipe.CustomShapelessRecipe;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.inventory.FurnaceRecipe;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.plugin.Plugin;

public class RecipeManager
implements Listener {
    private HashSet<Recipe> recipes = new HashSet();
    public boolean equals = true;

    @EventHandler(priority=EventPriority.LOW)
    public void onPrepare(PrepareItemCraftEvent e) {
        Recipe rec = this.getIfContainsCustomRecipe(e.getRecipe().getResult(), e.getInventory().getMatrix());
        if (rec != null && !this.equals) {
            this.equals = true;
            e.getInventory().setResult(new ItemStack(Material.AIR));
        }
    }

    public void registerRecipe(Recipe rec) {
        if (rec instanceof CustomShapedRecipe || rec instanceof CustomShapelessRecipe || rec instanceof CustomFurnaceRecipe) {
            if (this.getIfContainsCustomRecipe(rec.getResult(), this.getIngredients(rec)) != null || !Bukkit.addRecipe((Recipe)rec)) {
                return;
            }
            this.recipes.add(rec);
            if (this.recipes.size() == 1) {
                Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)TuSKe.getInstance());
            }
        }
    }

    public Recipe getIfContainsCustomRecipe(ItemStack result, ItemStack[] items) {
        for (Recipe recipe : this.recipes) {
            if (!result.equals((Object)recipe.getResult()) || !this.equalsRecipe(recipe, items)) continue;
            return recipe;
        }
        return null;
    }

    public boolean equalsRecipe(Recipe rec, ItemStack[] items) {
        this.equals = true;
        if (rec == null || items == null || items.length == 0) {
            return false;
        }
        if (rec instanceof ShapedRecipe) {
            ShapedRecipe sr = (ShapedRecipe)rec;
            Map map = sr.getIngredientMap();
            boolean found = false;
            int first = 3 - sr.getShape()[0].length();
            if (items.length < 9) {
                --first;
            }
            char ch = 'a';
            int x = 0;
            while (x < items.length) {
                Character c = Character.valueOf(ch);
                if (!map.containsKey(c)) break;
                if (this.areEqual((ItemStack)map.get(c), items[x])) {
                    ch = (char)(ch + '\u0001');
                    found = true;
                    if ((x + 1) / 3 > x / 3) {
                        x += first;
                    }
                } else if (found) {
                    return false;
                }
                ++x;
            }
            return true;
        }
        if (rec instanceof ShapelessRecipe) {
            int itemsFound = 0;
            List ingredients = ((ShapelessRecipe)rec).getIngredientList();
            block1: for (ItemStack item1 : ingredients) {
                ItemStack[] itemStackArray = items;
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    ItemStack item2 = itemStackArray[n2];
                    if (!this.isAir(item1) && !this.isAir(item2) && this.areEqual(item1, item2)) {
                        ++itemsFound;
                        break block1;
                    }
                    ++n2;
                }
            }
            return itemsFound == ingredients.size();
        }
        return false;
    }

    public boolean isAir(ItemStack item) {
        return item == null || item.getType().equals((Object)Material.AIR);
    }

    public boolean areEqual(ItemStack item1, ItemStack item2) {
        if (item1 == null) {
            item1 = new ItemStack(Material.AIR);
        }
        if (item2 == null) {
            item2 = new ItemStack(Material.AIR);
        }
        if (item1.getType().equals((Object)item2.getType()) && item1.getDurability() == item2.getDurability() && item1.getAmount() <= item2.getAmount()) {
            if (this.equals && !item1.isSimilar(item2)) {
                this.equals = false;
            }
            return true;
        }
        return false;
    }

    public ItemStack[] getIngredients(Recipe rec) {
        if (rec instanceof CustomShapedRecipe) {
            return ((CustomShapedRecipe)rec).getIngredients();
        }
        if (rec instanceof CustomShapelessRecipe) {
            return ((CustomShapelessRecipe)rec).getIngredients();
        }
        if (rec instanceof CustomFurnaceRecipe) {
            return new ItemStack[]{((CustomFurnaceRecipe)rec).getSource()};
        }
        if (rec instanceof ShapedRecipe) {
            Map map = ((ShapedRecipe)rec).getIngredientMap();
            return map.values().toArray(new ItemStack[map.size()]);
        }
        if (rec instanceof ShapelessRecipe) {
            List items = ((ShapelessRecipe)rec).getIngredientList();
            return items.toArray(new ItemStack[items.size()]);
        }
        return new ItemStack[]{((FurnaceRecipe)rec).getInput()};
    }

    public ItemStack[] fixIngredients(ItemStack[] items) {
        int x = 0;
        while (x < items.length) {
            if (items[x] == null) {
                items[x] = new ItemStack(Material.AIR);
            } else if (items[x].getDurability() == Short.MAX_VALUE) {
                items[x].setDurability((short)0);
            }
            if (items[x].getAmount() <= 0) {
                items[x].setAmount(1);
            }
            ++x;
        }
        return items;
    }

    public void clearRecipes() {
        HandlerList.unregisterAll((Listener)this);
        this.recipes.clear();
    }
}

