/*
 * Decompiled with CFR 0.152.
 */
package me.tuke.sktuke.documentation;

import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.registrations.Classes;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import me.tuke.sktuke.documentation.Syntax;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class Documentation {
    private Set<Syntax> syntaxes = new HashSet<Syntax>();
    private JavaPlugin plugin;
    private boolean enabled = false;

    public Documentation(JavaPlugin instance, boolean enabled) {
        this.plugin = instance;
        this.enabled = enabled;
    }

    public void addSyntax(Syntax syntax) {
        if (this.enabled) {
            this.syntaxes.add(syntax);
        }
    }

    public void generateDocs() {
        if (!this.enabled) {
            return;
        }
        File file = new File(this.plugin.getDataFolder(), "documentation.yml");
        YamlConfiguration yml = new YamlConfiguration();
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            yml.load(file);
            for (Syntax syntax : this.syntaxes) {
                String mainPath = String.valueOf(syntax.getType().name().toLowerCase()) + "." + syntax.getName();
                yml.set(String.valueOf(mainPath) + ".Syntaxes", Arrays.asList(syntax.getSyntaxes()));
                if (syntax.getChangers() != null) {
                    yml.set(String.valueOf(mainPath) + ".Accepted changers", (Object)syntax.getChangers());
                }
                if (syntax.getReturnType() == null) continue;
                ClassInfo ci = Classes.getExactClassInfo(syntax.getReturnType());
                yml.set(String.valueOf(mainPath) + ".Return type", (Object)ci.getCodeName());
            }
            yml.save(file);
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("A error occured while creating a documentation: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

