/*
 * Decompiled with CFR 0.152.
 */
package me.tuke.sktuke.customenchantment;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.tuke.sktuke.customenchantment.AcceptedItems;
import me.tuke.sktuke.customenchantment.EnchantManager;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class CustomEnchantment {
    private static List<CustomEnchantment> all = new ArrayList<CustomEnchantment>();
    static boolean reg;
    private String id;
    private String name;
    private int MaxLevel;
    private int Rarity;
    private List<AcceptedItems> items;
    private boolean enabledOnTable;
    private boolean enabledOnAnvil;
    private String[] conflicts;
    private List<CustomEnchantment> conflict = new ArrayList<CustomEnchantment>();

    private CustomEnchantment(String id, String name, int MaxLevel, int Rarity, List<AcceptedItems> items, boolean enabledOnTable, boolean enabledOnAnvil, String[] conflicts) {
        this.id = id;
        this.name = name;
        this.MaxLevel = MaxLevel;
        this.Rarity = Rarity;
        this.items = items;
        this.enabledOnTable = enabledOnTable;
        this.enabledOnAnvil = enabledOnAnvil;
        this.conflicts = conflicts;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getMaxLevel() {
        return this.MaxLevel;
    }

    public void setMaxLevel(int i) {
        this.MaxLevel = i;
    }

    public int getRarity() {
        return this.Rarity;
    }

    public void setRarity(int i) {
        this.Rarity = i;
    }

    public List<AcceptedItems> getAcceptedItems() {
        return this.items;
    }

    public void setAcceptedItems(List<AcceptedItems> ai) {
        this.items = ai;
    }

    public boolean isEnabledOnTable() {
        return this.enabledOnTable;
    }

    public void setEnabledOnTable(boolean value) {
        this.enabledOnTable = value;
    }

    public boolean isEnabledOnAnvil() {
        return this.enabledOnAnvil;
    }

    public void setEnabledOnAnvil(boolean value) {
        this.enabledOnAnvil = value;
    }

    public List<CustomEnchantment> getConflicts() {
        return this.conflict;
    }

    public void setConflicts(List<CustomEnchantment> value) {
        this.conflict = value;
    }

    public boolean isCompatible(ItemStack item) {
        for (AcceptedItems ai : this.getAcceptedItems()) {
            if (!ai.accepts(item)) continue;
            return true;
        }
        return false;
    }

    public int getLevel(ItemStack item) {
        Map<CustomEnchantment, Integer> list = CustomEnchantment.getCustomEnchants(item);
        if (list.containsKey(this)) {
            return list.get(this);
        }
        return 0;
    }

    public boolean equalsById(CustomEnchantment ce) {
        return this.getId().equalsIgnoreCase(ce.getId());
    }

    public boolean equalsByName(CustomEnchantment ce) {
        return this.getName().equalsIgnoreCase(ce.getName());
    }

    public static void acceptRegistration(boolean value) {
        reg = value;
    }

    public static boolean isAcceptingRegistration() {
        return reg;
    }

    public static void unregisterEnchantment(CustomEnchantment ce) {
        if (all.contains(ce)) {
            all.remove(ce);
        }
    }

    public static void registerNewEnchantment(String id, String name, int MaxLevel, int Rarity, List<AcceptedItems> items, boolean enabledOnTable, boolean enabledOnAnvil, String[] conflicts) {
        if (items.size() == 0) {
            items.add(AcceptedItems.ALL);
        }
        CustomEnchantment ce = new CustomEnchantment(id, name, MaxLevel, Rarity, items, enabledOnTable, enabledOnAnvil, conflicts);
        all.add(ce);
    }

    public static CustomEnchantment getByID(String enchant) {
        for (CustomEnchantment ce : all) {
            if (!ce.getId().equalsIgnoreCase(enchant)) continue;
            return ce;
        }
        return null;
    }

    public static CustomEnchantment getByName(String enchant) {
        for (CustomEnchantment ce : all) {
            if (!ce.getName().equalsIgnoreCase(enchant)) continue;
            return ce;
        }
        return null;
    }

    public static void clear() {
        all.clear();
    }

    public static void stopRegistration() {
        CustomEnchantment.acceptRegistration(false);
        for (CustomEnchantment ce : all) {
            ArrayList<CustomEnchantment> conf = new ArrayList<CustomEnchantment>();
            int x = 0;
            while (x < ce.conflicts.length) {
                CustomEnchantment ce2 = CustomEnchantment.getByID(ce.conflicts[x]);
                if (ce2 != null && !ce2.equals(ce)) {
                    conf.add(ce2);
                }
                ++x;
            }
            ce.conflict = conf;
            ce.conflicts = null;
        }
        CustomEnchantment.bubleSort();
    }

    public static void bubleSort() {
        int x = 0;
        while (x < all.size()) {
            int y = 0;
            while (y < all.size() - 1) {
                if (all.get(y).getRarity() > all.get(y + 1).getRarity()) {
                    CustomEnchantment cc = all.get(y);
                    all.set(y, all.get(y + 1));
                    all.set(y + 1, cc);
                }
                ++y;
            }
            ++x;
        }
    }

    public static List<CustomEnchantment> getEnchantments() {
        return all;
    }

    public static Map<CustomEnchantment, Integer> getCustomEnchants(ItemStack item) {
        HashMap<CustomEnchantment, Integer> list = new HashMap<CustomEnchantment, Integer>();
        List lore = new ArrayList();
        if (item != null && item.getType() != Material.AIR && item.getItemMeta().getLore() != null) {
            lore = item.getItemMeta().getLore();
        }
        int x = 0;
        while (x < lore.size()) {
            CustomEnchantment ce = CustomEnchantment.getByName(EnchantManager.getCorrectName((String)lore.get(x)));
            if (ce != null) {
                Integer i = EnchantManager.getStringLevel((String)lore.get(x));
                list.put(ce, i);
            }
            ++x;
        }
        return list;
    }
}

