/*
 * Decompiled with CFR 0.152.
 */
package me.tuke.sktuke.gui;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.function.Function;
import ch.njol.skript.lang.function.Parameter;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.tuke.sktuke.TuSKe;
import me.tuke.sktuke.gui.GUI;
import me.tuke.sktuke.gui.GroupGUI;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class GUIManager {
    private HashMap<Inventory, Map<Integer, Set<GUI>>> invs = new HashMap();
    private HashMap<String, GroupGUI> groups = new HashMap();

    public boolean isGUI(Inventory inv, int slot) {
        return this.invs.containsKey(inv) && this.invs.get(inv).containsKey(slot);
    }

    public boolean hasGUI(Inventory inv) {
        return this.invs.containsKey(inv);
    }

    public GUI getGUI(Inventory inv, int slot, ClickType ct) {
        return this.isGUI(inv, slot) ? this.getGUI(this.invs.get(inv).get(slot), ct) : null;
    }

    public void newGUI(Inventory inv, int slot, ItemStack item, GUI gui) {
        if (!this.isAllowedType(gui.getClickType())) {
            gui.setClickType(null);
        }
        this.addToListener(inv, slot, item, gui);
    }

    public void addToGroupGUI(String id, int slot, Expression<ItemStack> item, GUI gui) {
        GroupGUI gg = this.groups.containsKey(id.toLowerCase()) ? this.groups.get(id.toLowerCase()) : new GroupGUI();
        gg.newSlot(slot, item, gui);
        if (!this.groups.containsKey(id.toLowerCase())) {
            this.groups.put(id.toLowerCase(), gg);
        }
    }

    private GUI getGUI(Set<GUI> guis, ClickType ct) {
        for (GUI gui : guis) {
            if ((gui.getClickType() != null || ct != null) && (gui.getClickType() == null || ct == null || !gui.getClickType().equals((Object)ct))) continue;
            return gui;
        }
        if (ct != null) {
            return this.getGUI(guis, null);
        }
        return null;
    }

    private void addToListener(Inventory inv, int slot, ItemStack item, GUI gui) {
        GUI gui2;
        Map<Object, Object> guislot = new HashMap();
        Set<GUI> guis = new HashSet<GUI>();
        if (this.invs.containsKey(inv)) {
            guislot = this.invs.get(inv);
            this.invs.remove(inv);
            if (guislot.containsKey(slot)) {
                guis = (Set)guislot.get(slot);
            }
        }
        if ((gui2 = this.getGUI(guis, gui.getClickType())) != null) {
            guis.remove(gui2);
        }
        guis.add(gui);
        guislot.put(slot, guis);
        this.invs.put(inv, guislot);
        inv.setItem(slot, item);
    }

    public void remove(Inventory inv, int slot) {
        inv.setItem(slot, new ItemStack(Material.AIR));
        Map<Integer, Set<GUI>> map = this.invs.get(inv);
        map.remove(slot);
        if (map.size() > 0) {
            this.invs.put(inv, map);
        } else {
            this.invs.remove(inv);
        }
    }

    public void removeAll(Inventory inv) {
        for (int slot : this.invs.get(inv).keySet()) {
            inv.setItem(slot, new ItemStack(Material.AIR));
        }
        this.invs.remove(inv);
    }

    public void clearAll() {
        for (Inventory inv : this.invs.keySet()) {
            for (Integer slot : this.invs.get(inv).keySet()) {
                inv.setItem(slot.intValue(), new ItemStack(Material.AIR));
            }
        }
        this.invs.clear();
    }

    public Object[][] getParam(Function<?> f, List<Expression<?>> param, Event e) {
        Expression<?> def;
        int max = f.getParameters().length < param.size() ? f.getParameters().length : (param.size() < 1 ? 1 : param.size());
        Object[][] params = new Object[max][];
        if (param.size() > 0) {
            int x = 0;
            while (x < max) {
                if (x < param.size() && param.get(x) != null) {
                    params[x] = param.get(x).getArray(e);
                }
                ++x;
            }
        }
        if (params[0] == null && (def = this.getDefault(f.getParameter(0))) != null) {
            params[0] = def.getArray(e);
        }
        return params;
    }

    public boolean isAllowedType(ClickType ct) {
        if (ct != null) {
            switch (ct) {
                case WINDOW_BORDER_LEFT: 
                case WINDOW_BORDER_RIGHT: 
                case CREATIVE: 
                case UNKNOWN: {
                    return false;
                }
            }
        }
        return true;
    }

    private Expression<?> getDefault(Parameter<?> param) {
        Field field = null;
        try {
            field = Parameter.class.getDeclaredField("def");
            field.setAccessible(true);
            return (Expression)field.get(param);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void runCommand(CommandSender sender, String cmd, String perm) {
        if (sender != null && cmd != null) {
            if (sender instanceof Player && perm != null && !sender.isOp()) {
                sender.addAttachment((Plugin)TuSKe.getInstance(), perm, true, 0);
            }
            if (cmd.startsWith("/")) {
                cmd = cmd.substring(1);
            }
            Skript.dispatchCommand((CommandSender)sender, (String)cmd);
        }
    }
}

