/*
 * Decompiled with CFR 0.152.
 */
package me.tuke.sktuke.conditions;

import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import javax.annotation.Nullable;
import org.bukkit.entity.Creature;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Tameable;
import org.bukkit.event.Event;

public class CondIsMobType
extends Condition {
    private Expression<LivingEntity> et;
    private MobType mt;

    public boolean init(Expression<?>[] arg, int arg1, Kleenean arg2, SkriptParser.ParseResult arg3) {
        this.et = arg[0];
        this.mt = MobType.getByID(arg3.mark);
        this.setNegated(arg1 == 1);
        return true;
    }

    public String toString(@Nullable Event arg0, boolean arg1) {
        return this.et + " is " + this.mt.name().toLowerCase();
    }

    public boolean check(Event e) {
        if (this.et.getArray(e) == null) {
            return false;
        }
        boolean r = true;
        LivingEntity[] livingEntityArray = (LivingEntity[])this.et.getArray(e);
        int n = livingEntityArray.length;
        int n2 = 0;
        while (n2 < n) {
            LivingEntity ent = livingEntityArray[n2];
            if (ent != null && ent instanceof Creature && !this.isMobType((Creature)ent, this.mt)) {
                r = false;
                break;
            }
            ++n2;
        }
        if (this.isNegated()) {
            r = !r;
        }
        return r;
    }

    public boolean isMobType(Creature et, MobType mt) {
        switch (mt) {
            case PASSIVE: {
                switch (et.getType()) {
                    case WOLF: {
                        if (et instanceof Tameable) {
                            return ((Tameable)et).isTamed();
                        }
                    }
                    case BAT: 
                    case PIG: 
                    case SHEEP: 
                    case COW: 
                    case CHICKEN: 
                    case SQUID: 
                    case MUSHROOM_COW: 
                    case OCELOT: 
                    case HORSE: 
                    case VILLAGER: {
                        return true;
                    }
                }
                return et.getType().name().equalsIgnoreCase("RABBIT");
            }
            case NEUTRAL: {
                switch (et.getType()) {
                    case WOLF: {
                        return !((Tameable)et).isTamed();
                    }
                    case SPIDER: 
                    case PIG_ZOMBIE: 
                    case ENDERMAN: 
                    case CAVE_SPIDER: 
                    case PLAYER: {
                        return true;
                    }
                }
                return et.getType().name().equalsIgnoreCase("POLAR_BEAR");
            }
            case HOSTILE: {
                if (this.isMobType(et, MobType.NEUTRAL)) {
                    switch (et.getType()) {
                        case WOLF: {
                            return et.getTarget() != null && !((Tameable)et).isTamed();
                        }
                        case SPIDER: 
                        case CAVE_SPIDER: {
                            return et.getTarget() != null || et.getLocation().getBlock().getLightLevel() <= 10;
                        }
                        case PIG_ZOMBIE: 
                        case ENDERMAN: {
                            return et.getTarget() != null;
                        }
                    }
                    return et.getType().name().equalsIgnoreCase("POLAR_BEAR") && et.getTarget() != null;
                }
                return !this.isMobType(et, MobType.PASSIVE);
            }
        }
        return false;
    }

    public static enum MobType {
        HOSTILE,
        NEUTRAL,
        PASSIVE;


        static MobType getByID(int id) {
            return MobType.values()[id];
        }
    }
}

