/*
 * Decompiled with CFR 0.152.
 */
package me.tuke.sktuke.gui;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.function.Function;
import ch.njol.skript.lang.function.Parameter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import me.tuke.sktuke.gui.GUI;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class GUIManager {
    private Map<Inventory, Map<Integer, ArrayList<GUI>>> invs = new HashMap<Inventory, Map<Integer, ArrayList<GUI>>>();

    public boolean isGUI(Inventory inv, int slot) {
        return this.invs.containsKey(inv) && this.invs.get(inv).containsKey(slot);
    }

    public boolean hasGUI(Inventory inv) {
        return this.invs.containsKey(inv);
    }

    public GUI getGUI(Inventory inv, int slot, ClickType ct) {
        return this.isGUI(inv, slot) ? this.getGUI(this.invs.get(inv).get(slot), ct) : null;
    }

    private GUI getGUI(ArrayList<GUI> guis, ClickType ct) {
        for (GUI gui : guis) {
            if ((gui.getClickType() != null || ct != null) && (gui.getClickType() == null || ct == null || !gui.getClickType().equals((Object)ct))) continue;
            return gui;
        }
        if (ct != null) {
            return this.getGUI(guis, null);
        }
        return null;
    }

    public GUI newGUI(Inventory inv, int slot, ItemStack item, ClickType ct, Runnable rn, ItemStack item2) {
        if (!this.isAllowedType(ct)) {
            ct = null;
        }
        GUI gui = new GUI(rn, item2, ct);
        this.addToListener(inv, slot, item, gui);
        return gui;
    }

    private void addToListener(Inventory inv, int slot, ItemStack item, GUI gui) {
        Map<Object, Object> guislot = new HashMap();
        ArrayList guis = new ArrayList();
        if (this.invs.containsKey(inv)) {
            guislot = this.invs.get(inv);
            this.invs.remove(inv);
            if (guislot.containsKey(slot)) {
                guis = (ArrayList)guislot.get(slot);
            }
        }
        if (this.containsClickType(guis, gui.getClickType())) {
            guis.remove(this.getGUI(guis, gui.getClickType()));
        }
        guis.add((GUI)gui);
        guislot.put(slot, guis);
        this.invs.put(inv, guislot);
        inv.setItem(slot, item);
    }

    public void remove(Inventory inv, int slot) {
        inv.setItem(slot, new ItemStack(Material.AIR));
        Map<Integer, ArrayList<GUI>> map = this.invs.get(inv);
        map.remove(slot);
        if (map.size() > 0) {
            this.invs.put(inv, map);
        } else {
            this.invs.remove(inv);
        }
    }

    public void removeAll(Inventory inv) {
        for (int slot : this.invs.get(inv).keySet()) {
            inv.setItem(slot, new ItemStack(Material.AIR));
        }
        this.invs.remove(inv);
    }

    public void clearAll() {
        for (Inventory inv : this.invs.keySet()) {
            for (Integer slot : this.invs.get(inv).keySet()) {
                inv.setItem(slot.intValue(), new ItemStack(Material.AIR));
            }
        }
        this.invs.clear();
    }

    private boolean containsClickType(ArrayList<GUI> guis, @Nullable ClickType ct) {
        return this.getGUI(guis, ct) != null;
    }

    public Object[][] getParam(Function<?> f, List<Expression<?>> param, Event e) {
        int max = f.getParameters().length < param.size() ? f.getParameters().length : (param.size() < 1 ? 1 : param.size());
        Object[][] params = new Object[max][];
        if (param.size() > 0) {
            int x = 0;
            while (x < max) {
                if (x < param.size() && param.get(x) != null) {
                    params[x] = param.get(x).getArray(e);
                }
                ++x;
            }
        }
        Expression<?> def = this.getDefault(f.getParameter(0));
        if (params[0] == null && def != null) {
            params[0] = def.getArray(e);
        }
        return params;
    }

    public boolean isAllowedType(ClickType ct) {
        if (ct != null) {
            switch (ct) {
                case WINDOW_BORDER_LEFT: 
                case WINDOW_BORDER_RIGHT: 
                case CREATIVE: 
                case UNKNOWN: {
                    return false;
                }
            }
        }
        return true;
    }

    private Expression<?> getDefault(Parameter<?> param) {
        Field field = null;
        try {
            field = Parameter.class.getDeclaredField("def");
            field.setAccessible(true);
            return (Expression)field.get(param);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void runCommand(CommandSender sender, String cmd, boolean asOp) {
        block6: {
            boolean op = false;
            if (sender != null && cmd != null) {
                try {
                    if (sender instanceof Player && asOp && !sender.isOp()) {
                        sender.setOp(true);
                        op = true;
                    }
                    if (cmd.startsWith("/")) {
                        cmd = cmd.substring(1);
                    }
                    Skript.dispatchCommand((CommandSender)sender, (String)cmd);
                    if (op) {
                        sender.setOp(false);
                    }
                }
                catch (Exception e) {
                    if (!op) break block6;
                    sender.setOp(false);
                }
            }
        }
    }
}

