/*
 * Decompiled with CFR 0.152.
 */
package me.tuke.sktuke;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import me.tuke.sktuke.Metrics;
import me.tuke.sktuke.SkUnityUpdater;
import me.tuke.sktuke.customenchantment.CustomEnchantment;
import me.tuke.sktuke.customenchantment.EnchantConfig;
import me.tuke.sktuke.customenchantment.EnchantManager;
import me.tuke.sktuke.gui.GUIManager;
import me.tuke.sktuke.util.LegendConfig;
import me.tuke.sktuke.util.Register;
import me.tuke.sktuke.version.MineVersion;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class TuSKe
extends JavaPlugin {
    private static MineVersion mv;
    private static TuSKe plugin;
    private static long time;
    private static GUIManager gui;
    private SkUnityUpdater updater;
    private boolean autoUpdate;
    private boolean updateCheck;
    private boolean metrics;

    static {
        time = System.currentTimeMillis();
    }

    public void onEnable() {
        plugin = this;
        if (Register.hasPlugin("Skript")) {
            this.loadConfig();
            Integer[] registred = Register.load(this);
            this.updater = new SkUnityUpdater(this, this.getFile(), 7397);
            if (this.metrics) {
                try {
                    Metrics metrics = new Metrics((Plugin)this);
                    metrics.start();
                    TuSKe.log("Enabling Metrics... Done!");
                }
                catch (IOException e) {
                    TuSKe.log("A error occured when trying to start the Metrics.");
                }
            }
            gui = new GUIManager();
            TuSKe.log("Loaded sucessfully a total of " + registred[0] + " events, " + registred[1] + " conditions, " + registred[2] + " expressions" + (registred[4] == 0 ? " and " + registred[3] + " effects" : ", " + registred[3] + " effects and " + registred[4] + " custom enchantment" + (registred[4] > 1 ? "s" : "")) + ". Enjoy ^-^");
            if (this.updateCheck) {
                Bukkit.getScheduler().runTaskLater((Plugin)this, new Runnable(){

                    @Override
                    public void run() {
                        TuSKe.log("Checking for latest update...");
                        if (TuSKe.this.updater.checkForUpdate(true)) {
                            if (!TuSKe.this.updater.isLatestVersion()) {
                                if (TuSKe.this.autoUpdate) {
                                    TuSKe.this.updater.downloadLatest();
                                    TuSKe.log("Downloaded the latest version. The plugin will be updated when the server restarts.");
                                } else {
                                    TuSKe.log("New update available: v" + TuSKe.this.updater.getLatestVersion());
                                    TuSKe.log("Check what's new: " + TuSKe.this.updater.getChangeLogURL());
                                    TuSKe.log("Download it: " + TuSKe.this.updater.getThreadURL() + "/1");
                                    TuSKe.log("You can download and update it with /tuske update.");
                                }
                            } else {
                                TuSKe.log("No new update was found!");
                            }
                        }
                    }
                }, 1L);
            }
        } else {
            TuSKe.log("Error 404 - Skript not found.", Level.SEVERE);
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
        }
    }

    public void onDisable() {
        gui.clearAll();
        HandlerList.unregisterAll((Plugin)this);
        if (this.updateCheck && this.autoUpdate && this.updater.hasDownloadReady(true)) {
            this.updater.updatePlugin(true);
        }
    }

    public boolean onCommand(final CommandSender sender, Command cmd, String label, String[] arg) {
        if (cmd.getName().equalsIgnoreCase("tuske")) {
            if (arg.length > 0 && arg[0].equalsIgnoreCase("update")) {
                if (arg.length > 1 && arg[1].equalsIgnoreCase("download")) {
                    if (this.updater.hasDownloadReady(false) && this.autoUpdate) {
                        sender.sendMessage("\u00a7e[\u00a7cTuSKe\u00a7e] \u00a73Already have a downloaded file ready to be updated.");
                    } else if (!this.updater.isLatestVersion()) {
                        sender.sendMessage("\u00a7e[\u00a7cTuSKe\u00a7e] \u00a73Downloading the latest version...");
                        if (!this.updater.downloadLatest()) {
                            sender.sendMessage("\u00a73A error occured when trying to download latest version. Maybe SkUnity is down?");
                        } else {
                            sender.sendMessage("\u00a73The latest version was been dowloaded to TuSKe's folder.");
                        }
                    } else {
                        sender.sendMessage("\u00a7e[\u00a7cTuSKe\u00a7e] \u00a73The plugin is already running the latest version!");
                    }
                } else if (arg.length > 1 && arg[1].equalsIgnoreCase("plugin")) {
                    if (!this.updater.isLatestVersion()) {
                        if (!this.updater.hasDownloadReady(false) && !this.updater.downloadLatest()) {
                            sender.sendMessage("\u00a7e[\u00a7cTuSKe\u00a7e] \u00a73A error occured when trying to download latest version. Maybe SkUnity is down?");
                            return true;
                        }
                        this.autoUpdate = true;
                        sender.sendMessage("\u00a7e[\u00a7cTuSKe\u00a7e] \u00a73The plugin will update when the server restarts.");
                    } else {
                        sender.sendMessage("\u00a7e[\u00a7cTuSKe\u00a7e] \u00a73The plugin is already running the latest version!");
                    }
                } else if (arg.length > 1 && arg[1].equalsIgnoreCase("check")) {
                    sender.sendMessage("\u00a7e[\u00a7cTuSKe\u00a7e] \u00a73Checking for update...");
                    Bukkit.getScheduler().runTaskLater((Plugin)this, new Runnable(){

                        @Override
                        public void run() {
                            if (!TuSKe.this.updater.checkForUpdate(false)) {
                                sender.sendMessage("\u00a7e[\u00a7cTuSKe\u00a7e] \u00a73A error occured when trying to check for latest version. Maybe SkUnity is down?");
                            } else if (!TuSKe.this.updater.isLatestVersion()) {
                                sender.sendMessage("\u00a7e[\u00a7cTuSKe\u00a7e] \u00a73New update available: \u00a7cv" + TuSKe.this.updater.getLatestVersion());
                                if (sender instanceof Player) {
                                    TuSKe.this.sendDownloadRaw(sender);
                                } else {
                                    sender.sendMessage(new String[]{"\u00a73Check what's new: \u00a7c" + TuSKe.this.updater.getChangeLogURL(), "\u00a73Download it: \u00a7c" + TuSKe.this.updater.getDownloadURL(), "\u00a73You can download and update it with \u00a7c/tuske update\u00a73."});
                                }
                            } else {
                                sender.sendMessage("\u00a7e[\u00a7cTuSKe\u00a7e] \u00a73You are running the latest version: \u00a7cv" + TuSKe.this.updater.getLatestVersion());
                            }
                        }
                    }, 0L);
                } else {
                    sender.sendMessage(new String[]{"\u00a7e[\u00a7cTuSKe\u00a7e] \u00a73Main commands of \u00a7c" + arg[0] + "\u00a73:", "\u00a74/\u00a7c" + label + " update check \u00a7e> \u00a73Check for latest update.", "\u00a74/\u00a7c" + label + " update download \u00a7e> \u00a73Download the lateast update.", "\u00a74/\u00a7c" + label + " update plugin \u00a7e> \u00a73Update the plugin after the server restarts."});
                }
            } else if (arg.length > 0 && arg[0].equalsIgnoreCase("reload")) {
                if (arg.length > 1 && arg[1].equalsIgnoreCase("config")) {
                    this.reloadConfig();
                    this.loadConfig();
                    sender.sendMessage("\u00a7e[\u00a7cTuSKe\u00a7e] \u00a73Config reloaded!");
                } else if (arg.length > 1 && arg[1].equalsIgnoreCase("enchantments")) {
                    EnchantConfig.reload();
                    if (CustomEnchantment.getEnchantments().size() == 0) {
                        sender.sendMessage("\u00a7e[\u00a7cTuSKe\u00a7e] \u00a73No enchantments were loaded. :(");
                    } else {
                        sender.sendMessage("\u00a7e[\u00a7cTuSKe\u00a7e] \u00a73A total of \u00a7c" + CustomEnchantment.getEnchantments().size() + "\u00a73 were loaded succesfully.");
                    }
                } else {
                    sender.sendMessage(new String[]{"\u00a7e[\u00a7cTuSKe\u00a7e] \u00a73Main commands of \u00a7c" + arg[0] + "\u00a73:", "\u00a74/\u00a7c" + label + " reload config \u00a7e> \u00a73Reload the config.", "\u00a74/\u00a7c" + label + " reload enchantments \u00a7e> \u00a73Reload the enchantments' file."});
                }
            } else if (arg.length > 0 && arg[0].matches("ench(antment)?")) {
                if (arg.length > 1 && arg[1].equalsIgnoreCase("list")) {
                    sender.sendMessage(new String[]{"\u00a7e[\u00a7cTuSKe\u00a7e] \u00a73All registred enchantments:", "      \u00a7eName       \u00a7c-\u00a7e ML \u00a7c-\u00a7e R \u00a7c-\u00a7e Enabled?"});
                    for (CustomEnchantment c : CustomEnchantment.getEnchantments()) {
                        sender.sendMessage("\u00a7c" + this.left(c.getId(), 15) + " \u00a74-\u00a7c  " + c.getMaxLevel() + "  \u00a74-\u00a7c " + c.getRarity() + " \u00a74- " + (c.isEnabledOnAnvil() ? "\u00a7a" : "\u00a7c") + c.isEnabledOnTable());
                    }
                } else if (arg.length > 1 && arg[1].equalsIgnoreCase("toggle")) {
                    String ench = this.getEnchantment(arg, 2);
                    if (arg.length > 2 && EnchantManager.isCustomByID(ench)) {
                        CustomEnchantment ce;
                        ce.setEnabledOnTable(!(ce = CustomEnchantment.getByID(ench)).isEnabledOnTable());
                        sender.sendMessage("\u00a7e[\u00a7cTuSKe\u00a7e] \u00a73The enchantment \u00a7c" + ce.getId() + "\u00a73 was " + (ce.isEnabledOnTable() ? "\u00a7aenabled" : "\u00a7cdisabled") + "!");
                    } else if (arg.length > 2 && !EnchantManager.isCustomByID(ench)) {
                        sender.sendMessage("\u00a7e[\u00a7cTuSKe\u00a7e] \u00a73There isn't any registred enchantment with ID \u00a7c" + ench + "\u00a73.");
                    } else {
                        sender.sendMessage(new String[]{"\u00a7e[\u00a7cTuSKe\u00a7e] \u00a73Use this command to enable/disable a enchantment.", "\u00a74/\u00a7c" + label + " " + arg[0] + " toggle \u00a74<\u00a7cID\u00a74> \u00a7e> \u00a73Enable/disable a enchantment."});
                    }
                } else if (arg.length > 1 && arg[1].equalsIgnoreCase("give")) {
                    if (sender instanceof Player) {
                        String ench = this.getEnchantment(arg, 2);
                        if (arg.length > 2 && EnchantManager.isCustomByID(ench)) {
                            Integer lvl = arg.length > 3 && this.isInteger(arg[arg.length - 1]) ? Integer.valueOf(arg[arg.length - 1]) : 1;
                            CustomEnchantment ce = CustomEnchantment.getByID(ench);
                            Player p = (Player)sender;
                            ItemStack i = p.getInventory().getItem(p.getInventory().getHeldItemSlot());
                            if (i != null && !i.getType().equals((Object)Material.AIR)) {
                                if (ce.isCompatible(i)) {
                                    if (!EnchantManager.addToItem(p.getInventory().getItem(p.getInventory().getHeldItemSlot()), ce, lvl, true)) {
                                        sender.sendMessage("\u00a7e[\u00a7cTuSKe\u00a7e] \u00a73The enchantment \u00a7c" + ce.getId() + "\u00a73 couldn't be added to your held item.");
                                    } else {
                                        sender.sendMessage("\u00a7e[\u00a7cTuSKe\u00a7e] \u00a73The enchantment \u00a7c" + ce.getId() + "\u00a73 was added to your held item.");
                                    }
                                } else {
                                    sender.sendMessage("\u00a7e[\u00a7cTuSKe\u00a7e] \u00a73The enchantment \u00a7c" + ce.getId() + "\u00a73 doesn't accept this item.");
                                }
                            } else {
                                sender.sendMessage("\u00a7e[\u00a7cTuSKe\u00a7e] \u00a73You have to hold a item first.");
                            }
                        } else if (arg.length > 2 && !EnchantManager.isCustomByID(ench)) {
                            sender.sendMessage("\u00a7e[\u00a7cTuSKe\u00a7e] \u00a73There isn't any registred enchantment with ID \u00a7c" + ench + "\u00a73.");
                        } else {
                            sender.sendMessage(new String[]{"\u00a7e[\u00a7cTuSKe\u00a7e] \u00a73Use this command to enchant your held item.", "\u00a74/\u00a7c" + label + " " + arg[0] + " give \u00a74<\u00a7cID\u00a74> \u00a7c[\u00a74<\u00a7cLevel\u00a74>\u00a7c] \u00a7e> \u00a73Add a enchantment to your held item."});
                        }
                    } else {
                        sender.sendMessage("\u00a7e[\u00a7cTuSKe\u00a7e] \u00a73This command is only for players.");
                    }
                } else {
                    sender.sendMessage(new String[]{"\u00a7e[\u00a7cTuSKe\u00a7e] \u00a73Main commands of \u00a7c" + arg[0] + "\u00a73:", "\u00a74/\u00a7c" + label + " list \u00a7e> \u00a73Shows a list of registred items.", "\u00a74/\u00a7c" + label + " toggle \u00a7e> \u00a73Enable/disable a enchantment.", "\u00a74/\u00a7c" + label + " give \u00a7e> \u00a73Add a enchantment to your held item."});
                }
            } else {
                sender.sendMessage(new String[]{"\u00a7e[\u00a7cTuSKe\u00a7e] \u00a73Main commands:", "\u00a74/\u00a7c" + label + " reload \u00a7e> \u00a73Reload config/enchantments.", "\u00a74/\u00a7c" + label + " update \u00a7e> \u00a73Check for latest update.", "\u00a74/\u00a7c" + label + " ench \u00a7e> \u00a73Manage the enchantments."});
            }
        }
        return true;
    }

    private String getEnchantment(String[] str, int id) {
        StringBuilder sb = new StringBuilder();
        sb.append("");
        int x = id;
        while (x < str.length) {
            if (x != str.length - 1 || !this.isInteger(str[x])) {
                sb.append(str[x]);
                if (x < str.length - 1) {
                    sb.append(" ");
                }
            }
            ++x;
        }
        if (sb.toString().equals("") && str.length > id) {
            sb.append(str[id]);
        }
        return sb.toString();
    }

    private boolean isInteger(String arg) {
        try {
            Integer.valueOf(arg);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private String left(String s, int d) {
        StringBuilder sb = new StringBuilder(d);
        sb.append(s);
        while (sb.length() < d) {
            sb.append(" ");
        }
        return sb.toString();
    }

    private void loadConfig() {
        File f = new File(this.getDataFolder(), "config.yml");
        if (!f.exists()) {
            this.saveResource("config.yml", false);
        }
        this.autoUpdate = this.getConfig().isBoolean("auto-update") ? this.getConfig().getBoolean("auto-update") : false;
        this.updateCheck = this.getConfig().isBoolean("check-for-new-update") ? this.getConfig().getBoolean("check-for-new-update") : true;
        this.metrics = this.getConfig().isBoolean("use-metrics") ? this.getConfig().getBoolean("use-metrics") : true;
    }

    private void sendDownloadRaw(CommandSender s) {
        Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)("tellraw " + s.getName() + " [{\"text\":\"\\u00a73Click \"},{\"text\":\"\\u00a7chere\",\"hoverEvent\":{\"action\":\"show_text\",\"value\":\"\\u00a73Link to\n\\u00a7cSkUnity\n\\u00a7cForums\"},\"clickEvent\":{\"action\":\"open_url\",\"value\":\"" + this.updater.getChangeLogURL() + "\"}},{\"text\":\" \\u00a73to \\u00a73see \\u00a73what's \\u00a73new, \\u00a73click \"}, {\"text\":\"\\u00a7chere\",\"hoverEvent\":{\"action\":\"show_text\",\"value\":\"\\u00a73Link to download\"},\"clickEvent\":{\"action\":\"open_url\",\"value\":\"" + this.updater.getDownloadURL() + "\"}},{\"text\":\" \\u00a73to \\u00a73download \\u00a73or \\u00a73use \\u00a73the \\u00a73command \"},{\"text\":\"\\u00a7c/tuske \\u00a7cupdate \\u00a7cdownload\",\"clickEvent\":{\"action\":\"suggest_command\",\"value\":\"/tuske update download\"}},{\"text\":\" \\u00a73to \\u00a73download \\u00a73directly \\u00a73to \\u00a73TuSKe's \\u00a73folder. \\u00a73And \\u00a73you \\u00a73can \\u00a73use \"},{\"text\":\"\\u00a7c/tuske \\u00a7cupdate \\u00a7cplugin\",\"clickEvent\":{\"action\":\"suggest_command\",\"value\":\"/tuske update plugin\"}}]"));
    }

    public static GUIManager getGUIManager() {
        return gui;
    }

    public static LegendConfig getLegendConfig() {
        return Register.config;
    }

    public static void log(String msg) {
        TuSKe.log(msg, Level.INFO);
    }

    public static void log(String msg, Level lvl) {
        plugin.getLogger().log(lvl, msg);
    }

    public static boolean hasSupport() {
        String rversion = Bukkit.getServer().getClass().getPackage().getName().split(".v")[1];
        try {
            Class<?> classs = Class.forName("me.tuke.sktuke.version.M_" + rversion);
            if (MineVersion.class.isAssignableFrom(classs)) {
                mv = (MineVersion)classs.getConstructor(new Class[0]).newInstance(new Object[0]);
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static TuSKe getInstance() {
        return plugin;
    }

    public static MineVersion getMVersion() {
        return mv;
    }

    public static boolean isSpigot() {
        try {
            Class<Player> clazz = Player.class;
            if (clazz.getMethod("spigot", new Class[0]) != null) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean isPixelmon() {
        return Bukkit.getServerName().equalsIgnoreCase("LendaryCraft");
    }

    public static Long getTime() {
        return time;
    }
}

