/*
 * Decompiled with CFR 0.152.
 */
package me.tuke.sktuke.util;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import me.tuke.sktuke.TuSKe;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class LegendConfig {
    private File file;
    private YamlConfiguration y = new YamlConfiguration();

    LegendConfig(TuSKe instance) {
        this.file = new File(instance.getDataFolder(), "tags.yml");
    }

    public Map<String, String> getPlayerTags(Player p) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (this.file.exists() && p != null) {
            if (this.hasOldData(p)) {
                this.convertToUUID(p);
            }
            if (this.getTagFile().getConfigurationSection(p.getUniqueId().toString()) != null) {
                for (String s : this.getTagFile().getConfigurationSection(p.getUniqueId().toString()).getKeys(false)) {
                    map.put(s, this.getTagFile().getString(String.valueOf(p.getUniqueId().toString()) + "." + s));
                }
            }
        }
        return map;
    }

    public String getPlayerTag(Player p, String Tag) {
        if (this.file.exists() && p != null && Tag != null) {
            if (this.hasOldData(p)) {
                this.convertToUUID(p);
            }
            if (this.getTagFile().contains(p.getUniqueId() + "." + Tag)) {
                return this.getTagFile().getString(p.getUniqueId() + "." + Tag);
            }
        }
        return null;
    }

    public void setPlayerTag(Player p, String Tag, String Value) {
        if (!this.getFile().exists()) {
            this.createTagFile();
        }
        if (this.getTagFile() != null && p != null && Tag != null && Value != null) {
            this.getTagFile().set(String.valueOf(p.getUniqueId().toString()) + "." + Tag, (Object)Value);
            this.save();
        }
    }

    public YamlConfiguration getTagFile() {
        if (this.getFile().exists()) {
            try {
                this.y.load(this.getFile());
            }
            catch (Exception exception) {
                // empty catch block
            }
            return this.y;
        }
        return null;
    }

    public void clearTag(Player p, String Tag) {
        if (this.getFile().exists()) {
            if (this.hasOldData(p)) {
                this.convertToUUID(p);
            }
            if (this.getTagFile() != null && p != null && Tag != null && this.getTagFile().isSet(p.getUniqueId() + "." + Tag)) {
                if (this.getTagFile().getConfigurationSection(p.getUniqueId().toString()).getKeys(false).size() == 1) {
                    this.getTagFile().set(p.getUniqueId().toString(), null);
                } else {
                    this.getTagFile().set(String.valueOf(p.getUniqueId().toString()) + "." + Tag, null);
                }
                this.save();
            }
        }
    }

    public File getFile() {
        return this.file;
    }

    private boolean hasOldData(Player p) {
        return this.getTagFile().getConfigurationSection(p.getName()) != null;
    }

    private void convertToUUID(Player p) {
        if (this.hasOldData(p)) {
            for (String s : this.getTagFile().getConfigurationSection(p.getName()).getKeys(false)) {
                this.setPlayerTag(p, s, this.getTagFile().getString(String.valueOf(p.getName()) + "." + s));
                this.getTagFile().set(p.getName(), null);
            }
        }
    }

    public void createTagFile() {
        if (!this.getFile().exists()) {
            try {
                this.getFile().createNewFile();
                this.save();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void save() {
        if (this.getFile().exists()) {
            try {
                this.y.save(this.getFile());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

