/*
 * Decompiled with CFR 0.152.
 */
package me.tuke.sktuke.gui;

import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.function.Function;
import ch.njol.skript.lang.function.Parameter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import me.tuke.sktuke.gui.GUI;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class GUIManager {
    private Map<Inventory, Map<Integer, ArrayList<GUI>>> invs = new HashMap<Inventory, Map<Integer, ArrayList<GUI>>>();

    public boolean isGUI(Inventory inv, int slot) {
        return this.invs.containsKey(inv) && this.invs.get(inv).containsKey(slot);
    }

    public boolean hasGUI(Inventory inv) {
        return this.invs.containsKey(inv);
    }

    public GUI getGUI(Inventory inv, int slot, ClickType ct) {
        return this.isGUI(inv, slot) ? this.getGUI(this.invs.get(inv).get(slot), ct) : null;
    }

    public GUI getGUI(ArrayList<GUI> guis, ClickType ct) {
        for (GUI gui : guis) {
            if (gui.getClickType() == null && ct == null) {
                return gui;
            }
            if (gui.getClickType() == null || ct == null || !gui.getClickType().equals((Object)ct)) continue;
            return gui;
        }
        if (ct != null) {
            return this.getGUI(guis, null);
        }
        return null;
    }

    public GUI newGUI(Inventory inv, int slot, ItemStack item, @Nullable ClickType ct, CommandSender sender, String cmd, boolean asOp, ItemStack item2) {
        if (this.isAllowedType(ct)) {
            ct = null;
        }
        GUI gui = new GUI(sender, cmd, asOp, item2);
        gui.setClickType(ct);
        this.addToListener(inv, slot, item, gui);
        return gui;
    }

    public GUI newGUI(Inventory inv, int slot, ItemStack item, @Nullable ClickType ct, Function<?> func, List<Expression<?>> expr, Event e, ItemStack item2) {
        if (this.isAllowedType(ct)) {
            ct = null;
        }
        GUI gui = new GUI(func, this.getParam(func, expr, e), item2);
        gui.setClickType(ct);
        this.addToListener(inv, slot, item, gui);
        return gui;
    }

    public GUI newGUI(Inventory inv, int slot, ItemStack item) {
        GUI gui = new GUI();
        this.addToListener(inv, slot, item, gui);
        return gui;
    }

    private void addToListener(Inventory inv, int slot, ItemStack item, GUI gui) {
        Map<Object, Object> guislot = new HashMap();
        ArrayList guis = new ArrayList();
        if (this.invs.containsKey(inv)) {
            guislot = this.invs.get(inv);
            this.invs.remove(inv);
            if (guislot.containsKey(slot)) {
                guis = (ArrayList)guislot.get(slot);
            }
        }
        if (this.containsClickType(guis, gui.getClickType())) {
            guis.remove(this.getGUI(guis, gui.getClickType()));
        }
        guis.add((GUI)gui);
        guislot.put(slot, guis);
        this.invs.put(inv, guislot);
        inv.setItem(slot, item);
    }

    public void remove(Inventory inv, int slot) {
        inv.setItem(slot, new ItemStack(Material.AIR));
        Map<Integer, ArrayList<GUI>> map = this.invs.get(inv);
        map.remove(slot);
        if (map.size() > 0) {
            this.invs.put(inv, map);
        } else {
            this.invs.remove(inv);
        }
    }

    public void removeAll(Inventory inv) {
        for (int slot : this.invs.get(inv).keySet()) {
            inv.setItem(slot, new ItemStack(Material.AIR));
        }
        this.invs.remove(inv);
    }

    public void clearAll() {
        for (Inventory inv : this.invs.keySet()) {
            for (Integer slot : this.invs.get(inv).keySet()) {
                inv.setItem(slot.intValue(), new ItemStack(Material.AIR));
            }
        }
        this.invs.clear();
    }

    private boolean containsClickType(ArrayList<GUI> guis, @Nullable ClickType ct) {
        return this.getGUI(guis, ct) != null;
    }

    public Object[][] getParam(Function<?> f, List<Expression<?>> param, Event e) {
        boolean single = f.getMaxParameters() == 1;
        Object[][] params = new Object[single || param.size() < 1 ? 1 : param.size()][];
        if (param.size() > 0) {
            int x = 0;
            while (x < params.length) {
                if (x < param.size() && param.get(x) != null && f.getParameter(x).getType().getC().equals(param.get(x).getReturnType())) {
                    params[x] = param.get(x).getArray(e);
                }
                ++x;
            }
        }
        if (params[0] == null) {
            params[0] = this.getDefault(f.getParameter(0)).getArray(e);
        }
        return params;
    }

    public boolean isAllowedType(ClickType ct) {
        if (ct != null) {
            switch (ct) {
                case WINDOW_BORDER_LEFT: 
                case WINDOW_BORDER_RIGHT: 
                case CREATIVE: 
                case UNKNOWN: {
                    return false;
                }
            }
        }
        return true;
    }

    private Expression<?> getDefault(Parameter<?> param) {
        Field field = null;
        try {
            field = Parameter.class.getDeclaredField("def");
            field.setAccessible(true);
            return (Expression)field.get(param);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static enum ActionType {
        NOTHING(0),
        RUN_COMMAND(1),
        RUN_FUNCTION(2);

        public int id;

        private ActionType(int id) {
            this.id = id;
        }
    }
}

