/*
 * Decompiled with CFR 0.152.
 */
package me.tuke.sktuke.customenchantment;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import me.tuke.sktuke.customenchantment.AcceptedItems;
import me.tuke.sktuke.customenchantment.CustomEnchant;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class EnchantConfig {
    static Plugin p = Bukkit.getServer().getPluginManager().getPlugin("TuSKe");
    static File file = new File(p.getDataFolder(), "enchantments.yml");
    public static YamlConfiguration y = new YamlConfiguration();
    static final int maxLevel = 3;
    static final int rarity = 3;
    static final String items = "All";
    static final boolean enabled = false;

    public static void loadEnchants() {
        if (!file.exists()) {
            EnchantConfig.createNewFile();
        } else if (file.exists() && EnchantConfig.loadFile() && y.isConfigurationSection("Enchantments")) {
            try {
                block2: for (String enchants : y.getConfigurationSection("Enchantments").getKeys(false)) {
                    ConfigurationSection cs = y.getConfigurationSection("Enchantments." + enchants);
                    if (cs.getString("Name") != null) {
                        for (CustomEnchant ce : CustomEnchant.enchants) {
                            if (!ce.getIdName().equalsIgnoreCase(enchants) && !ce.getName().equalsIgnoreCase(cs.getString("Name")) && !ce.getIdName().equalsIgnoreCase(cs.getString("Name")) && !ce.getName().equalsIgnoreCase(enchants)) continue;
                            Bukkit.getLogger().severe("[TuSKe] Couldn't register the enchantment '" + enchants + "' because it has a repeated name or lore name.");
                            continue block2;
                        }
                        if (cs.isSet("MaxLevel") && (!cs.isInt("MaxLevel") || cs.getInt("MaxLevel") <= 0 || cs.getInt("MaxLevel") > 10)) {
                            Bukkit.getLogger().warning("[TuSKe] The value of 'MaxLevel' from enchantment '" + enchants + "' is not between 1 and 10 or is not a valid value. Using the default value (" + 3 + ").");
                            cs.set("MaxLevel", (Object)3);
                        }
                        if (cs.isSet("Rarity") && (!cs.isInt("Rarity") || cs.getInt("Rarity") <= 0 || cs.getInt("Rarity") > 5)) {
                            Bukkit.getLogger().warning("[TuSKe] The value of 'Rarity' from enchantment '" + enchants + "' is not between 1 and 5 or is not a valid value. Using the default value (" + 3 + ").");
                            cs.set("Rarity", (Object)3);
                        }
                        if (cs.isSet("AcceptedItems")) {
                            if (cs.getString("AcceptedItems").contains(",") || cs.getString("AcceptedItems").contains(" and ")) {
                                List<String> list = Arrays.asList(cs.getString("AcceptedItems").replaceAll(" and ", ",").replaceAll(" ", "").split(","));
                                int x = 0;
                                while (x < list.size()) {
                                    if (!AcceptedItems.isValue(list.get(x).toUpperCase())) {
                                        list.remove(x);
                                        if (list.size() < 1) {
                                            cs.set("AcceptedItems", (Object)items);
                                            Bukkit.getLogger().warning("[TuSKe] There aren't any valid values for 'AcceptedItems'. Using the default value (All)");
                                        } else {
                                            Bukkit.getLogger().warning("[TuSKe] '" + list.get(x) + "' is not a valid value for 'AcceptedItems'. Ignoring it...");
                                        }
                                    }
                                    ++x;
                                }
                            } else if (!AcceptedItems.isValue(cs.getString("AcceptedItems").toUpperCase().replaceAll(" ", ""))) {
                                Bukkit.getLogger().warning("[TuSKe] The value of 'AcceptedItems' from enchantment '" + enchants + "' is not a valid value. Using the default value (" + items + ").");
                                cs.set("AcceptedItems", (Object)items);
                            }
                        }
                        if (cs.getString("Conflicts") == null || cs.getString("Conflicts").equalsIgnoreCase("None")) {
                            cs.set("Conflicts", null);
                        }
                        if (cs.isSet("Enabled") && !cs.isBoolean("Enabled")) {
                            cs.set("Enabled", (Object)false);
                        }
                        CustomEnchant.RegisterEnchantment(new CustomEnchant(enchants));
                        continue;
                    }
                    Bukkit.getLogger().warning("[TuSKe] The enchantment '" + enchants + "' doesn't have a correct name. Skipping it.");
                }
                CustomEnchant.bubleSort();
                if (!y.isInt("Config.MaxEnchantmentsPerItem")) {
                    if (y.isInt("Config.MaxEnchantsPerItem")) {
                        y.set("Config.MaxEnchantsPerItem", null);
                    } else {
                        Bukkit.getLogger().warning("[TuSKe] Wrong value for 'MaxEnchantPerItem'. Using the default value (4).");
                    }
                    y.set("Config.MaxEnchantmentsPerItem", (Object)4);
                    EnchantConfig.save();
                }
                if (!y.isBoolean("Config.CompatibilityMode")) {
                    y.set("Config.CompatibilityMode", (Object)false);
                    Bukkit.getLogger().warning("[TuSKe] Wrong value for 'CompatibilityMode'. Using the default value (false).");
                }
                if (!y.isInt("Config.GlobalRarity")) {
                    y.set("Config.GlobalRarity", (Object)5);
                    EnchantConfig.save();
                } else if (y.getInt("Config.GlobalRarity") < 1 || y.getInt("Config.GlobalRarity") > 5) {
                    y.set("Config.GlobalRarity", (Object)5);
                    Bukkit.getLogger().warning("[TuSKe] Wrong value for 'GlobalRarity', only accepts integers between 1 and 5. Using the default value (5).");
                }
            }
            catch (Exception e) {
                Bukkit.getLogger().severe("[TuSKe] A error has occured when trying to load the enchantments file. Checks if hasn't any wrong values. \n" + e);
            }
        }
    }

    public static boolean loadFile() {
        if (file.exists()) {
            try {
                y.load(file);
                return true;
            }
            catch (Exception e) {
                Bukkit.getLogger().severe("[TuSKe] Couldn't load the enchantments file, probably there are wrong values. But if you think everything is right, ask for support using this message and the enchantment file. \n\n" + e.getMessage());
            }
        }
        return false;
    }

    public static void createNewFile() {
        if (!file.exists()) {
            try {
                p.saveResource("enchantments.yml", false);
            }
            catch (Exception e) {
                Bukkit.getLogger().severe("[TuSKe] Error occurred when creating a new enchantment file: \n" + e.getMessage());
            }
        }
    }

    public static void save() {
        if (file.exists()) {
            try {
                y.save(file);
            }
            catch (Exception e) {
                Bukkit.getLogger().severe("[TuSKe] Error occurred when saving enchantment file: \n" + e.getMessage());
            }
        }
    }

    public static int getGlobalRarity() {
        return y.getInt("Config.GlobalRarity");
    }

    public static void reload() {
        file = new File(p.getDataFolder(), "enchantments.yml");
        CustomEnchant.enchants.clear();
        if (EnchantConfig.loadFile()) {
            EnchantConfig.loadEnchants();
        }
    }
}

