/*
 * Decompiled with CFR 0.152.
 */
package me.tuke.sktuke.customenchantment;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import me.tuke.sktuke.TuSKe;
import me.tuke.sktuke.customenchantment.AcceptedItems;
import me.tuke.sktuke.customenchantment.EnchantConfig;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class CustomEnchant {
    private String cenchant;
    public static ArrayList<CustomEnchant> enchants = new ArrayList();
    static final TreeMap<Integer, String> map = new TreeMap();

    static {
        map.put(1000, "M");
        map.put(900, "CM");
        map.put(500, "D");
        map.put(400, "CD");
        map.put(100, "C");
        map.put(90, "XC");
        map.put(50, "L");
        map.put(40, "XL");
        map.put(10, "X");
        map.put(9, "IX");
        map.put(5, "V");
        map.put(4, "IV");
        map.put(1, "I");
    }

    public static void RegisterEnchantment(CustomEnchant enchant) {
        if (!enchants.contains(enchant)) {
            enchants.add(enchant);
        }
    }

    public static void bubleSort() {
        int x = 0;
        while (x < enchants.size()) {
            int y = 0;
            while (y < enchants.size() - 1) {
                if (enchants.get(y).getRarity() > enchants.get(y + 1).getRarity()) {
                    CustomEnchant cc = enchants.get(y);
                    enchants.set(y, enchants.get(y + 1));
                    enchants.set(y + 1, cc);
                }
                ++y;
            }
            ++x;
        }
    }

    public CustomEnchant(String enchant) {
        this.cenchant = enchant;
    }

    public String getIdName() {
        return this.cenchant;
    }

    public static int getMaxPerItem() {
        return EnchantConfig.y.getInt("Config.MaxEnchantsPerItem");
    }

    public String getName() {
        return EnchantConfig.y.getString("Enchantments." + this.cenchant + ".Name");
    }

    public int getMaxLevel() {
        return EnchantConfig.y.isSet("Enchantments." + this.cenchant + ".MaxLevel") ? EnchantConfig.y.getInt("Enchantments." + this.cenchant + ".MaxLevel") : 3;
    }

    public int getRarity() {
        return EnchantConfig.y.isSet("Enchantments." + this.cenchant + ".Rarity") ? EnchantConfig.y.getInt("Enchantments." + this.cenchant + ".Rarity") : 3;
    }

    public List<AcceptedItems> getCompatibles() {
        ArrayList<AcceptedItems> AI = new ArrayList<AcceptedItems>();
        if (EnchantConfig.y.isSet("Enchantments." + this.cenchant + ".AcceptedItems")) {
            String[] items = EnchantConfig.y.getString("Enchantments." + this.cenchant + ".AcceptedItems").replaceAll(" and ", ",").replaceAll(" ", "").split(",");
            int x = 0;
            while (x < items.length) {
                if (AcceptedItems.isValue(items[x].toUpperCase())) {
                    AI.add(AcceptedItems.valueOf(items[x].toUpperCase()));
                }
                ++x;
            }
        }
        if (AI.isEmpty()) {
            AI.add(AcceptedItems.ALL);
        }
        return AI;
    }

    public boolean isEnabled() {
        return EnchantConfig.y.isSet("Enchantments." + this.cenchant + ".Enabled") ? EnchantConfig.y.getBoolean("Enchantments." + this.cenchant + ".Enabled") : false;
    }

    public static CustomEnchant getCustomByIDName(String enchant) {
        for (CustomEnchant ce : enchants) {
            if (!ce.getIdName().equalsIgnoreCase(enchant) && !ce.getName().equalsIgnoreCase(enchant)) continue;
            return ce;
        }
        return null;
    }

    public List<CustomEnchant> getConflicts() {
        String conf;
        ArrayList<CustomEnchant> confl = new ArrayList<CustomEnchant>();
        if (EnchantConfig.y.isString("Enchantments." + this.cenchant + ".Conflicts") && ((conf = EnchantConfig.y.getString("Enchantments." + this.cenchant + ".Conflicts")).toLowerCase().contains(",") || conf.toLowerCase().contains(" and "))) {
            String[] stringArray = conf.replaceAll(" and ", ",").split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (CustomEnchant.isCustomByID(s)) {
                    confl.add(CustomEnchant.getCustomByIDName(s));
                } else if (!conf.equalsIgnoreCase("None") && CustomEnchant.isCustomByID(conf)) {
                    confl.add(CustomEnchant.getCustomByIDName(conf));
                }
                ++n2;
            }
        }
        return confl;
    }

    public boolean isCompatible(ItemStack item) {
        for (AcceptedItems AI : this.getCompatibles()) {
            if (!AI.accepts(item)) continue;
            return true;
        }
        return false;
    }

    public static boolean isCustomByID(String enchant) {
        return CustomEnchant.getCustomByIDName(enchant) != null;
    }

    public static boolean isCustomByName(String enchant) {
        return CustomEnchant.getCustomEnchant(enchant) != null;
    }

    public static CustomEnchant getCustomEnchant(String enchant) {
        for (CustomEnchant c : enchants) {
            if (!c.getName().equalsIgnoreCase(enchant)) continue;
            return c;
        }
        return null;
    }

    public static String getCorrectName(String enchant) {
        if ((enchant = ChatColor.stripColor((String)enchant)).contains(" ")) {
            String[] ench = enchant.split(" ");
            try {
                if (CustomEnchant.toArabic(ench[ench.length - 1]) >= 0) {
                    enchant = enchant.replace(" " + ench[ench.length - 1], "");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return enchant;
    }

    public int getLevel(ItemStack item) {
        if (item.getItemMeta().getLore() != null) {
            int x = 0;
            while (x < item.getItemMeta().getLore().size()) {
                String s = CustomEnchant.getCorrectName((String)item.getItemMeta().getLore().get(x));
                if (CustomEnchant.isCustomByID(s) && s.equalsIgnoreCase(this.getName())) {
                    return CustomEnchant.getStringLevel((String)item.getItemMeta().getLore().get(x));
                }
                ++x;
            }
        }
        return 0;
    }

    public String getStringEnchant(int Level2) {
        if (TuSKe.getMVersion().getID() >= 1.09 && Level2 == 1) {
            return ChatColor.GRAY + this.getName();
        }
        return ChatColor.GRAY + this.getName() + " " + CustomEnchant.toRoman(Level2);
    }

    public static boolean addToItem(ItemStack item, CustomEnchant enchant, int Level2, boolean NoEnchant) {
        if (enchant.isCompatible(item) && CustomEnchant.getNumberOfEnchants(item, enchant) < CustomEnchant.getMaxPerItem()) {
            List<String> lore = new ArrayList();
            if (Level2 > enchant.getMaxLevel()) {
                Level2 = enchant.getMaxLevel();
            }
            if (NoEnchant && item.getEnchantments().size() == 0) {
                switch (item.getType()) {
                    case BOOK: {
                        item.setType(Material.ENCHANTED_BOOK);
                    }
                    case ENCHANTED_BOOK: {
                        EnchantmentStorageMeta aa = (EnchantmentStorageMeta)item.getItemMeta();
                        if (aa.getStoredEnchants().size() != 0) break;
                        aa.addStoredEnchant(Enchantment.DURABILITY, 1, false);
                        item.setItemMeta((ItemMeta)aa);
                        break;
                    }
                    default: {
                        item.addEnchantment(Enchantment.DURABILITY, 1);
                    }
                }
            }
            if (item.getItemMeta().getLore() != null) {
                lore = item.getItemMeta().getLore();
            }
            int equals = -1;
            int x = 0;
            while (x < lore.size()) {
                String s = CustomEnchant.getCorrectName((String)lore.get(x));
                if (CustomEnchant.isCustomByName(s)) {
                    if (CustomEnchant.getCustomEnchant(s).equals(enchant)) {
                        equals = x;
                    }
                    if (item.getType() != Material.ENCHANTED_BOOK && (enchant.getConflicts().contains(CustomEnchant.getCustomEnchant(s)) || CustomEnchant.getCustomEnchant(s).getConflicts().contains(enchant))) {
                        return false;
                    }
                }
                ++x;
            }
            if (equals < 0 || lore.size() == 0) {
                lore.add(enchant.getStringEnchant(Level2));
            } else {
                lore.set(equals, enchant.getStringEnchant(Level2));
            }
            ItemMeta meta = item.getItemMeta();
            meta.setLore(lore);
            item.setItemMeta(meta);
            return true;
        }
        return false;
    }

    public static boolean removeFromItem(ItemStack item, CustomEnchant enchant) {
        if (CustomEnchant.getCustomEnchants(item).contains(enchant)) {
            List lore = item.getItemMeta().getLore();
            int x = 0;
            while (x < lore.size()) {
                if (((String)lore.get(x)).equals(enchant.getStringEnchant(CustomEnchant.getStringLevel((String)lore.get(x))))) {
                    lore.remove(x);
                    ItemMeta im = item.getItemMeta();
                    im.setLore(lore);
                    item.setItemMeta(im);
                }
                ++x;
            }
        }
        return false;
    }

    public static List<CustomEnchant> getCustomEnchants(ItemStack item) {
        ArrayList<CustomEnchant> list = new ArrayList<CustomEnchant>();
        List lore = new ArrayList();
        if (item.getItemMeta().getLore() != null) {
            lore = item.getItemMeta().getLore();
        }
        int x = 0;
        while (x < lore.size()) {
            String s = CustomEnchant.getCorrectName((String)lore.get(x));
            if (CustomEnchant.isCustomByName(s)) {
                list.add(CustomEnchant.getCustomEnchant(s));
            }
            ++x;
        }
        return list;
    }

    public static int getStringLevel(String enchant) {
        enchant = ChatColor.stripColor((String)enchant);
        String ec = CustomEnchant.getCorrectName(enchant);
        if ((enchant = enchant.replaceAll(ec, "").replaceAll(" ", "")).equals("")) {
            return 1;
        }
        return CustomEnchant.toArabic(enchant) <= CustomEnchant.getCustomEnchant(ec).getMaxLevel() ? CustomEnchant.toArabic(enchant) : CustomEnchant.getCustomEnchant(ec).getMaxLevel();
    }

    public static int getNumberOfEnchants(ItemStack item, CustomEnchant enchant) {
        int x = 0;
        if (CustomEnchant.getCustomEnchants(item).contains(enchant)) {
            ++x;
        }
        if (EnchantConfig.y.getBoolean("Config.CompatibilityMode")) {
            if (item.getItemMeta().getLore() == null) {
                return 0;
            }
            return item.getItemMeta().getLore().size() - x;
        }
        return CustomEnchant.getCustomEnchants(item).size() - x;
    }

    public static final String toRoman(int number) {
        if (number <= 0) {
            return "";
        }
        int l = map.floorKey(number);
        if (number == l) {
            return map.get(number);
        }
        return String.valueOf(map.get(l)) + CustomEnchant.toRoman(number - l);
    }

    public static final int toArabic(String number) {
        for (Integer key : map.keySet()) {
            String[] s = number.split("");
            if (s.length > 1) {
                if (map.get(key).equals(s[0]) && key >= CustomEnchant.toArabic(s[1])) {
                    return key + CustomEnchant.toArabic(number.replaceFirst(map.get(key), ""));
                }
                if (map.get(key).equals(s[0])) {
                    return CustomEnchant.toArabic(number.replaceFirst(map.get(key), "")) - key;
                }
            }
            if (!map.get(key).equals(number)) continue;
            return key;
        }
        return 0;
    }
}

