/*
 * Decompiled with CFR 0.152.
 */
package me.tuke.sktuke.expressions.griefprevention;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import javax.annotation.Nullable;
import me.ryanhamshire.GriefPrevention.GriefPrevention;
import me.ryanhamshire.GriefPrevention.PlayerData;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class ExprClaimBlocks
extends SimpleExpression<Number> {
    private Expression<Player> p;
    private Integer pr;
    private String exp;

    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    public boolean isSingle() {
        return true;
    }

    public boolean init(Expression<?>[] arg, int arg1, Kleenean arg2, SkriptParser.ParseResult exp) {
        this.p = arg[0];
        this.exp = exp.expr;
        if (exp.expr.toLowerCase().contains("accrued claim blocks")) {
            this.pr = 1;
        } else if (exp.expr.toLowerCase().contains("bonus claim blocks")) {
            this.pr = 2;
        } else if (exp.expr.toLowerCase().contains("used claim blocks")) {
            this.pr = 3;
        } else if (exp.expr.toLowerCase().contains("remaining claim blocks")) {
            this.pr = 4;
        } else if (exp.expr.toLowerCase().contains("total claim blocks")) {
            this.pr = 5;
        }
        return true;
    }

    public String toString(@Nullable Event e, boolean arg) {
        return this.exp;
    }

    @Nullable
    protected Number[] get(Event e) {
        Player p = (Player)this.p.getSingle(e);
        PlayerData pd = GriefPrevention.instance.dataStore.getPlayerData(p.getUniqueId());
        switch (this.pr) {
            case 1: {
                return new Number[]{pd.getAccruedClaimBlocks()};
            }
            case 2: {
                return new Number[]{pd.getBonusClaimBlocks()};
            }
            case 3: {
                return new Number[]{pd.getAccruedClaimBlocks() + pd.getBonusClaimBlocks() - pd.getRemainingClaimBlocks()};
            }
            case 4: {
                return new Number[]{pd.getRemainingClaimBlocks()};
            }
            case 5: {
                return new Number[]{pd.getAccruedClaimBlocks() + pd.getBonusClaimBlocks()};
            }
        }
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        if (!delta[0].toString().contains(".")) {
            Player p = (Player)this.p.getSingle(e);
            PlayerData pd = GriefPrevention.instance.dataStore.getPlayerData(p.getUniqueId());
            if (this.pr == 1) {
                if (mode == Changer.ChangeMode.SET) {
                    pd.setAccruedClaimBlocks(Integer.valueOf(delta[0].toString()));
                } else if (mode == Changer.ChangeMode.ADD) {
                    pd.setAccruedClaimBlocks(Integer.valueOf(pd.getAccruedClaimBlocks() + Integer.valueOf(delta[0].toString())));
                } else if (mode == Changer.ChangeMode.REMOVE) {
                    pd.setAccruedClaimBlocks(Integer.valueOf(pd.getAccruedClaimBlocks() - Integer.valueOf(delta[0].toString())));
                } else if (mode == Changer.ChangeMode.RESET || mode == Changer.ChangeMode.DELETE) {
                    pd.setAccruedClaimBlocks(Integer.valueOf(0));
                }
            } else if (this.pr == 2) {
                if (mode == Changer.ChangeMode.SET) {
                    pd.setBonusClaimBlocks(Integer.valueOf(delta[0].toString()));
                } else if (mode == Changer.ChangeMode.ADD) {
                    pd.setBonusClaimBlocks(Integer.valueOf(pd.getBonusClaimBlocks() + Integer.valueOf(delta[0].toString())));
                } else if (mode == Changer.ChangeMode.REMOVE) {
                    pd.setBonusClaimBlocks(Integer.valueOf(pd.getBonusClaimBlocks() - Integer.valueOf(delta[0].toString())));
                } else if (mode == Changer.ChangeMode.RESET || mode == Changer.ChangeMode.DELETE) {
                    pd.setBonusClaimBlocks(Integer.valueOf(0));
                }
            }
        } else {
            Skript.error((String)("'" + this.exp + "' only accepts integer values."));
        }
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (this.pr <= 2) {
            if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.REMOVE || mode == Changer.ChangeMode.RESET || mode == Changer.ChangeMode.DELETE) {
                return (Class[])CollectionUtils.array((Object[])new Class[]{Number.class});
            }
            return null;
        }
        return null;
    }
}

