/*
 * Decompiled with CFR 0.152.
 */
package me.tuke.sktuke;

import java.io.File;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class ConfigManager {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void loadConfig() {
        Plugin p = Bukkit.getServer().getPluginManager().getPlugin("TuSKe");
        File doc = new File(p.getDataFolder(), "documentation.yml");
        YamlConfiguration y = new YamlConfiguration();
        try {
            if (doc.exists()) {
                y.load(doc);
                if (y.getString("version").equals(p.getDescription().getVersion())) {
                    Bukkit.getLogger().info("[TuSKe] The documentation file is updated.");
                    return;
                }
                doc.delete();
                Bukkit.getLogger().info("[TuSKe] Updating the documentation to v" + p.getDescription().getVersion() + "...");
            } else {
                Bukkit.getLogger().info("[TuSKe] Creating new documentation file...");
            }
            p.saveResource("documentation.yml", false);
            Bukkit.getLogger().info("[TuSKe] Done!");
            return;
        }
        catch (Exception e) {
            Bukkit.getLogger().info("[TuSKe] Couldn't get the documentation file, creating a new one.");
            if (!doc.exists()) return;
            doc.delete();
            p.saveResource("documentation.yml", false);
        }
    }
}

