/*
 * Decompiled with CFR 0.152.
 */
package me.tuke.sktuke.expressions.griefprevention;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import javax.annotation.Nullable;
import me.ryanhamshire.GriefPrevention.GriefPrevention;
import me.ryanhamshire.GriefPrevention.PlayerData;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class ExprClaimBlocks
extends SimpleExpression<Number> {
    private Expression<Player> p;
    private Integer pr;
    private String exp;

    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    public boolean isSingle() {
        return true;
    }

    public boolean init(Expression<?>[] arg, int arg1, Kleenean arg2, SkriptParser.ParseResult exp) {
        this.p = arg[0];
        this.exp = exp.expr;
        if (exp.expr.toLowerCase().contains("accrued claim blocks")) {
            this.pr = 1;
        } else if (exp.expr.toLowerCase().contains("bonus claim blocks")) {
            this.pr = 2;
        } else if (exp.expr.toLowerCase().contains("used claim blocks")) {
            this.pr = 3;
        } else if (exp.expr.toLowerCase().contains("remaining claim blocks")) {
            this.pr = 4;
        } else if (exp.expr.toLowerCase().contains("total claim blocks")) {
            this.pr = 5;
        }
        return true;
    }

    public String toString(@Nullable Event e, boolean arg) {
        return this.exp;
    }

    @Nullable
    protected Number[] get(Event e) {
        PlayerData pd;
        Player p = (Player)this.p.getSingle(e);
        if (p != null && (pd = GriefPrevention.instance.dataStore.getPlayerData(p.getUniqueId())) != null) {
            switch (this.pr) {
                case 1: {
                    return new Number[]{pd.getAccruedClaimBlocks()};
                }
                case 2: {
                    return new Number[]{pd.getBonusClaimBlocks()};
                }
                case 3: {
                    return new Number[]{pd.getAccruedClaimBlocks() + pd.getBonusClaimBlocks() - pd.getRemainingClaimBlocks()};
                }
                case 4: {
                    return new Number[]{pd.getRemainingClaimBlocks()};
                }
                case 5: {
                    return new Number[]{pd.getAccruedClaimBlocks() + pd.getBonusClaimBlocks()};
                }
            }
        }
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        Player p = (Player)this.p.getSingle(e);
        if (p != null) {
            PlayerData pd;
            int b = 0;
            if (delta != null) {
                b = ((Number)delta[0]).intValue();
            }
            if ((pd = GriefPrevention.instance.dataStore.getPlayerData(p.getUniqueId())) != null) {
                if (this.pr == 1) {
                    if (mode == Changer.ChangeMode.ADD) {
                        b += pd.getAccruedClaimBlocks();
                    } else if (mode == Changer.ChangeMode.REMOVE) {
                        b = pd.getAccruedClaimBlocks() - b;
                    }
                    pd.setAccruedClaimBlocks(Integer.valueOf(b));
                } else if (this.pr == 2) {
                    if (mode == Changer.ChangeMode.ADD) {
                        b += pd.getAccruedClaimBlocks();
                    } else if (mode == Changer.ChangeMode.REMOVE) {
                        b = pd.getAccruedClaimBlocks() - b;
                    }
                    pd.setAccruedClaimBlocks(Integer.valueOf(b));
                }
            }
        }
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (this.pr <= 2) {
            if (mode != Changer.ChangeMode.REMOVE_ALL) {
                return (Class[])CollectionUtils.array((Object[])new Class[]{Number.class});
            }
            return null;
        }
        return null;
    }
}

