/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.transk.syntax.blind.expression;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.moderocky.component.LoreComponent;
import com.moderocky.item.ItemStacker;
import com.moderocky.transk.api.TransAPI;
import java.util.ArrayList;
import javax.annotation.Nullable;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

@Name(value="Translated Item Lore")
@Description(value={"Sets an item lore to translatable components.\n  - If you want to use a mixture of translated and normal text,\n    please use the 'complex' version of this syntax.\n  - You CANNOT have a translated component and normal text on the same line.\n  - This is due to a limitation in Minecraft's lore system.\n  - To get around this, consider registering a '%s%s' translation in your resource pack.\n  - Then you can embed multiple components into one another. :D"})
@Examples(value={"set {_x} to player's tool with translated lore \"menu.singleplayer\" and \"custom.key\"", "set {_x} to player's tool with translated lore \"menu.singleplayer[inputs='\u00a7hi, I'm an input!','hello there!','General Kenobi!']\"", "set {_x} to player's tool with translated lore \"another.custom.key\" and \"\u00a7cI will look like this.\" #if there's no matching lang entry, the client will see your translation string."})
@Since(value="0.1.2")
public class TranslatedLore
extends SimpleExpression<ItemType> {
    private Expression<ItemType> itemTypeExpression;
    private Expression<String> stringExpression;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.itemTypeExpression = exprs[0];
        this.stringExpression = exprs[1];
        return true;
    }

    protected ItemType[] get(Event event) {
        ArrayList<ItemType> itemTypes = new ArrayList<ItemType>();
        ItemType itemType = (ItemType)this.itemTypeExpression.getSingle(event);
        ItemStack itemStack = itemType.getRandom();
        ItemStacker stacker = new ItemStacker(itemStack);
        ArrayList<LoreComponent> components = new ArrayList<LoreComponent>();
        for (String string : (String[])this.stringExpression.getArray(event)) {
            components.add(TransAPI.convertKey(string));
        }
        stacker.setComponentLore(components);
        itemType.setItemMeta(stacker.getItemMeta());
        itemTypes.add(itemType);
        return itemTypes.toArray(new ItemType[0]);
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends ItemType> getReturnType() {
        return ItemType.class;
    }

    public String toString(@Nullable Event event, boolean debug) {
        String string = "<none>";
        String itemType = "<none>";
        String inputs = "<none>";
        if (this.stringExpression != null) {
            string = this.stringExpression.toString(event, debug);
        }
        if (this.itemTypeExpression != null) {
            itemType = this.itemTypeExpression.toString(event, debug);
        }
        return itemType + " with translated lore " + string;
    }

    static {
        Skript.registerExpression(TranslatedLore.class, ItemType.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"%itemtype% with translated lore %strings%"});
    }
}

