/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.transk.syntax.blind.expression;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.moderocky.inventory.InvWrapper;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.server.v1_15_R1.IChatBaseComponent;
import org.bukkit.event.Event;
import org.bukkit.inventory.Inventory;

@Name(value="Translated Chest Name")
@Description(value={"Opens a chest with a translatable component name.\n  - This currently requires Minecraft version 1.15.1.\n  - Backwards compatibility may be added in future versions.\n  - Currently, the name may ONLY be your translated key."})
@Examples(value={"new chest with translated name \"translation.test.args\" with inputs \"hello\" and \"there\""})
@Since(value="0.1.2")
public class OpenComplexTranslatedChest
extends SimpleExpression<Inventory> {
    private Expression<String> stringExpression;
    private Expression<String> inputsExpression;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.stringExpression = exprs[0];
        this.inputsExpression = exprs[1];
        return true;
    }

    protected Inventory[] get(Event event) {
        ArrayList<Inventory> inventories = new ArrayList<Inventory>();
        inventories.add(InvWrapper.createChest((IChatBaseComponent)InvWrapper.translate((String)this.stringExpression.getSingle(event), (String[])this.inputsExpression.getArray(event))));
        return inventories.toArray(new Inventory[0]);
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends Inventory> getReturnType() {
        return Inventory.class;
    }

    public String toString(@Nullable Event event, boolean debug) {
        String string = "<none>";
        String inputs = "<none>";
        if (this.stringExpression != null) {
            string = this.stringExpression.toString(event, debug);
        }
        if (this.inputsExpression != null) {
            inputs = this.inputsExpression.toString(event, debug);
        }
        return "open chest with translated name " + string + " with inputs " + inputs;
    }

    static {
        Skript.registerExpression(OpenComplexTranslatedChest.class, Inventory.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[a] [new] chest with [complex] translat(ed|able) name %string% with [(attachment[s]|input[s])] %strings%"});
    }
}

