/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.transk.syntax.blind.effect;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.moderocky.component.LoreComponent;
import com.moderocky.component.LoreLine;
import com.moderocky.item.ItemStacker;
import com.moderocky.transk.api.TransAPI;
import java.util.List;
import javax.annotation.Nullable;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

@Name(value="Set Translated Lore Line")
@Description(value={"Sets a specific lore line of an item's lore to a translated value."})
@Examples(value={"set line 1 of {_item}'s lore to translated \"translation.test.none\""})
@Since(value="0.1.2")
public class SetTranslatedLoreLine
extends Effect {
    private Expression<Number> numberExpression;
    private Expression<String> stringExpression;
    private Expression<ItemType> itemTypeExpression;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.numberExpression = exprs[0];
        this.stringExpression = exprs[2];
        this.itemTypeExpression = exprs[1];
        return true;
    }

    protected void execute(Event event) {
        if (this.itemTypeExpression == null || this.stringExpression == null || this.numberExpression == null) {
            return;
        }
        ItemType itemType = (ItemType)this.itemTypeExpression.getSingle(event);
        ItemStack itemStack = itemType.getRandom();
        ItemStacker stacker = new ItemStacker(itemStack);
        int number = ((Number)this.numberExpression.getSingle(event)).intValue();
        List<LoreComponent> components = stacker.getComponentLore();
        String string = (String)this.stringExpression.getSingle(event);
        LoreComponent newLine = TransAPI.convertKey(string);
        while (components.size() < number - 1) {
            components.add(new LoreLine());
        }
        components.set(number - 1, newLine);
        stacker.setComponentLore(components);
        itemType.setItemMeta(stacker.getItemMeta());
    }

    public String toString(@Nullable Event event, boolean debug) {
        String string = "<none>";
        String itemType = "<none>";
        String number = "<none>";
        if (this.stringExpression != null) {
            string = this.stringExpression.toString(event, debug);
        }
        if (this.itemTypeExpression != null) {
            itemType = this.itemTypeExpression.toString(event, debug);
        }
        if (this.numberExpression != null) {
            number = this.numberExpression.toString(event, debug);
        }
        return "set line " + number + " of " + itemType + "'s lore to translated " + string;
    }

    static {
        Skript.registerEffect(SetTranslatedLoreLine.class, (String[])new String[]{"set line %number% of %itemtype%'[s] lore to translated %string%", "set line %number% of [the] lore of %itemtype% to translated %string%"});
    }
}

