/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.transk.mask.template;

import com.moderocky.transk.mask.annotation.API;
import com.moderocky.transk.mask.api.CaughtReflective;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

@API
public interface Reflective {
    public static <Q> CaughtReflective<Q> setField(@NotNull Q object, String fieldName, Object value) {
        try {
            Field field = object.getClass().getField(fieldName);
            field.setAccessible(true);
            field.set(object, value);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            return new CaughtReflective<Object>(false, e, null);
        }
        return new CaughtReflective<Q>(true, null, object);
    }

    public static CaughtReflective<Object> getField(@NotNull Object object, String fieldName) {
        try {
            Field field = object.getClass().getField(fieldName);
            field.setAccessible(true);
            return new CaughtReflective<Object>(true, null, field.get(object));
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            return new CaughtReflective<Object>(false, e, null);
        }
    }

    public static CaughtReflective<Method> getMethod(@NotNull Object object, String methodName) {
        for (Method declaredMethod : object.getClass().getDeclaredMethods()) {
            if (!declaredMethod.getName().equalsIgnoreCase(methodName)) continue;
            return new CaughtReflective<Method>(true, null, declaredMethod);
        }
        return new CaughtReflective<Object>(false, new NullPointerException(), null);
    }

    public static CaughtReflective<Method> getMethod(@NotNull Object object, String methodName, Class<?> ... params) {
        try {
            return new CaughtReflective<Method>(true, null, object.getClass().getDeclaredMethod(methodName, params));
        }
        catch (NoSuchMethodException e) {
            return new CaughtReflective<Object>(false, e, null);
        }
    }

    public static CaughtReflective<Method> getMethod(@NotNull Class<?> clarse, String methodName) {
        for (Method declaredMethod : clarse.getDeclaredMethods()) {
            if (!declaredMethod.getName().equalsIgnoreCase(methodName)) continue;
            return new CaughtReflective<Method>(true, null, declaredMethod);
        }
        return new CaughtReflective<Object>(false, new NullPointerException(), null);
    }

    public static CaughtReflective<Method> getMethod(@NotNull Class<?> clarse, String methodName, Class<?> ... params) {
        try {
            return new CaughtReflective<Method>(true, null, clarse.getDeclaredMethod(methodName, params));
        }
        catch (NoSuchMethodException e) {
            return new CaughtReflective<Object>(false, e, null);
        }
    }

    public static CaughtReflective<Object> callMethod(@NotNull Object object, Method method, Object ... params) {
        method.setAccessible(true);
        try {
            return new CaughtReflective<Object>(true, null, method.invoke(object, params));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            return new CaughtReflective<Object>(false, e, null);
        }
    }

    public static CaughtReflective<Object> callMethod(@NotNull Object object, String methodName, Object ... params) {
        ArrayList paramClasses = new ArrayList();
        for (Object parameter : params) {
            paramClasses.add(parameter.getClass());
        }
        Method method = Reflective.getMethod(object, methodName, paramClasses.toArray(new Class[0])).get();
        if (method == null) {
            return new CaughtReflective<Object>(false, new NullPointerException(), null);
        }
        method.setAccessible(true);
        try {
            return new CaughtReflective<Object>(true, null, method.invoke(object, params));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            return new CaughtReflective<Object>(false, e, null);
        }
    }

    public static CaughtReflective<Object> callMethod(@NotNull Class<?> clarse, String methodName, Object ... params) {
        ArrayList paramClasses = new ArrayList();
        for (Object parameter : params) {
            paramClasses.add(parameter.getClass());
        }
        Method method = Reflective.getMethod(clarse, methodName, paramClasses.toArray(new Class[0])).get();
        if (method == null) {
            return new CaughtReflective<Object>(false, new NullPointerException(), null);
        }
        method.setAccessible(true);
        try {
            return new CaughtReflective<Object>(true, null, method.invoke(clarse, params));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            return new CaughtReflective<Object>(false, e, null);
        }
    }

    public static <Z> CaughtReflective<Z> createInstance(@NotNull Class<Z> clarse) {
        try {
            Z inst = clarse.newInstance();
            return new CaughtReflective<Z>(true, null, inst);
        }
        catch (IllegalAccessException | InstantiationException e) {
            return new CaughtReflective<Object>(false, e, null);
        }
    }

    public static <Z> CaughtReflective<Z> createInstance(@NotNull Class<Z> clarse, Object ... parameters) {
        try {
            ArrayList paramClasses = new ArrayList();
            for (Object parameter : parameters) {
                paramClasses.add(parameter.getClass());
            }
            Constructor<Z> constructor = clarse.getDeclaredConstructor(paramClasses.toArray(new Class[0]));
            if (constructor == null) {
                return new CaughtReflective<Object>(false, new NullPointerException(), null);
            }
            Z inst = constructor.newInstance(parameters);
            return new CaughtReflective<Z>(true, null, inst);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            return new CaughtReflective<Object>(false, e, null);
        }
    }

    public static <Z> CaughtReflective<Constructor<Z>> getConstructor(@NotNull Class<Z> clarse, Class<?> ... parameters) {
        try {
            clarse.getDeclaredConstructor(parameters);
            return new CaughtReflective<Constructor<Z>>(true, null, clarse.getDeclaredConstructor(parameters));
        }
        catch (NoSuchMethodException e) {
            return new CaughtReflective<Object>(false, e, null);
        }
    }

    public static <Z> CaughtReflective<Z> callConstructor(@NotNull Constructor<Z> constructor, Object ... parameters) {
        try {
            Z inst = constructor.newInstance(parameters);
            return new CaughtReflective<Z>(true, null, inst);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            return new CaughtReflective<Object>(false, e, null);
        }
    }

    public static List<Field> getStaticFields(Class<?> clarse) {
        Field[] declaredFields = clarse.getDeclaredFields();
        ArrayList<Field> staticFields = new ArrayList<Field>();
        for (Field field : declaredFields) {
            if (!Modifier.isStatic(field.getModifiers())) continue;
            staticFields.add(field);
        }
        return staticFields;
    }

    public static List<Field> getInstanceFields(Class<?> clarse) {
        Field[] declaredFields = clarse.getDeclaredFields();
        ArrayList<Field> instanceFields = new ArrayList<Field>();
        for (Field field : declaredFields) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            instanceFields.add(field);
        }
        return instanceFields;
    }

    public static List<Field> getFinalFields(Class<?> clarse) {
        Field[] declaredFields = clarse.getDeclaredFields();
        ArrayList<Field> finalFields = new ArrayList<Field>();
        for (Field field : declaredFields) {
            if (!Modifier.isFinal(field.getModifiers())) continue;
            finalFields.add(field);
        }
        return finalFields;
    }

    default public CaughtReflective<Reflective> setField(String fieldName, boolean value) {
        try {
            Field field = this.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            field.setBoolean(this, value);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            return new CaughtReflective<Object>(false, e, null);
        }
        return new CaughtReflective<Reflective>(true, null, this);
    }

    default public CaughtReflective<Reflective> setField(String fieldName, int value) {
        try {
            Field field = this.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            field.setInt(this, value);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            return new CaughtReflective<Object>(false, e, null);
        }
        return new CaughtReflective<Reflective>(true, null, this);
    }

    default public CaughtReflective<Reflective> setField(String fieldName, byte value) {
        try {
            Field field = this.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            field.setByte(this, value);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            return new CaughtReflective<Object>(false, e, null);
        }
        return new CaughtReflective<Reflective>(true, null, this);
    }

    default public CaughtReflective<Reflective> setField(String fieldName, long value) {
        try {
            Field field = this.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            field.setLong(this, value);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            return new CaughtReflective<Object>(false, e, null);
        }
        return new CaughtReflective<Reflective>(true, null, this);
    }

    default public CaughtReflective<Reflective> setField(String fieldName, double value) {
        try {
            Field field = this.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            field.setDouble(this, value);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            return new CaughtReflective<Object>(false, e, null);
        }
        return new CaughtReflective<Reflective>(true, null, this);
    }

    default public CaughtReflective<Reflective> setField(String fieldName, Object value) {
        try {
            Field field = this.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            field.set(this, value);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            return new CaughtReflective<Object>(false, e, null);
        }
        return new CaughtReflective<Reflective>(true, null, this);
    }

    default public CaughtReflective<Object> getField(String fieldName) {
        try {
            Field field = this.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            return new CaughtReflective<Object>(true, null, field.get(this));
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            return new CaughtReflective<Object>(false, e, null);
        }
    }
}

