/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.transk.mask.template;

import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.BoundingBox;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PositionalWand {
    @Nullable
    private Location pos1;
    @Nullable
    private Location pos2;
    @NotNull
    private final ItemStack itemStack;
    @NotNull
    private final Plugin plugin;

    public PositionalWand(@NotNull ItemStack itemStack, @NotNull Plugin plugin) {
        this.itemStack = itemStack;
        this.plugin = plugin;
        ItemMeta meta = itemStack.getItemMeta();
        String x1 = (String)meta.getPersistentDataContainer().get(new NamespacedKey(plugin, "wand_pos_1"), PersistentDataType.STRING);
        String x2 = (String)meta.getPersistentDataContainer().get(new NamespacedKey(plugin, "wand_pos_2"), PersistentDataType.STRING);
        this.pos1 = x1 != null && !x1.isEmpty() ? this.deserialisePosition(x1) : null;
        this.pos2 = x2 != null && !x2.isEmpty() ? this.deserialisePosition(x2) : null;
    }

    @Nullable
    public Location getPos1() {
        return this.pos1;
    }

    @Nullable
    public Location getPos2() {
        return this.pos2;
    }

    public void setPos1(@Nullable Location pos1) {
        this.pos1 = pos1;
        this.apply(this.itemStack);
    }

    public void setPos2(@Nullable Location pos2) {
        this.pos2 = pos2;
        this.apply(this.itemStack);
    }

    public boolean bothSet() {
        return this.pos1 != null && this.pos2 != null;
    }

    public BoundingBox getBoundingBox() {
        if (this.pos1 != null && this.pos2 != null) {
            return BoundingBox.of((Location)this.pos1, (Location)this.pos2);
        }
        return null;
    }

    public double distanceSquared() {
        if (this.pos1 == null || this.pos2 == null) {
            return 0.0;
        }
        return this.pos1.distanceSquared(this.pos2);
    }

    public double distance() {
        if (this.pos1 == null || this.pos2 == null) {
            return 0.0;
        }
        return this.pos1.distance(this.pos2);
    }

    public void reset() {
        this.pos1 = null;
        this.pos2 = null;
        this.apply(this.itemStack);
    }

    public void apply(@NotNull ItemStack itemStack) {
        String x2;
        ItemMeta meta = itemStack.getItemMeta();
        PersistentDataContainer container = meta.getPersistentDataContainer();
        String x1 = this.pos1 != null ? this.serialisePosition(this.pos1) : null;
        String string = x2 = this.pos2 != null ? this.serialisePosition(this.pos2) : null;
        if (x1 == null) {
            container.remove(new NamespacedKey(this.plugin, "wand_pos_1"));
        } else {
            container.set(new NamespacedKey(this.plugin, "wand_pos_1"), PersistentDataType.STRING, (Object)x1);
        }
        if (x2 == null) {
            container.remove(new NamespacedKey(this.plugin, "wand_pos_2"));
        } else {
            container.set(new NamespacedKey(this.plugin, "wand_pos_2"), PersistentDataType.STRING, (Object)x2);
        }
    }

    private String serialisePosition(Location location) {
        return location.getWorld().getName() + ":" + location.getX() + ":" + location.getY() + ":" + location.getZ();
    }

    private Location deserialisePosition(String string) {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException();
        }
        String[] parts = string.split(":");
        if (parts.length == 4) {
            World w = Bukkit.getServer().getWorld(parts[0]);
            double x = Double.parseDouble(parts[1]);
            double y = Double.parseDouble(parts[2]);
            double z = Double.parseDouble(parts[3]);
            return new Location(w, x, y, z);
        }
        throw new IllegalArgumentException();
    }
}

