/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.transk.mask.template;

import com.google.common.base.CaseFormat;
import com.moderocky.transk.mask.annotation.API;
import com.moderocky.transk.mask.annotation.Configurable;
import com.moderocky.transk.mask.internal.utility.FileManager;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.jetbrains.annotations.NotNull;

public interface Config {
    default public void save() {
        File file = this.getFile();
        FileConfiguration config = this.getConfig();
        try {
            Configurable.Overwrite overwrite = this.getClass().getAnnotation(Configurable.Overwrite.class);
            if (overwrite != null && overwrite.value()) {
                PrintWriter writer = new PrintWriter(file);
                writer.print("");
                writer.close();
            }
        }
        catch (Exception overwrite) {
            // empty catch block
        }
        HashMap<String, String[]> commentLines = new HashMap<String, String[]>();
        for (Field field : this.getClass().getDeclaredFields()) {
            Object value;
            Configurable configurable;
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            try {
                configurable = field.getAnnotation(Configurable.class);
            }
            catch (Exception e) {
                continue;
            }
            if (configurable == null) continue;
            String path = this.getFieldPath(field, configurable.section());
            try {
                value = field.get(this);
            }
            catch (IllegalAccessException e) {
                continue;
            }
            if (field.getType().getEnumConstants() != null) {
                value = value.toString();
            }
            if (field.getType().isAssignableFrom(Map.class) || field.getType().isInstance(Map.class)) {
                Map map = (Map)value;
                if (map.size() < 1) {
                    config.set(path, null);
                } else {
                    for (Object o : map.keySet()) {
                        Object v = map.get(o);
                        try {
                            config.set(path + "." + o.toString(), v);
                        }
                        catch (Exception e) {
                            Bukkit.getLogger().log(Level.WARNING, "Config saving error: " + v.toString() + " could not be stored.");
                        }
                    }
                }
            } else {
                value = this.serialise(field, value);
                config.set(path, value);
            }
            try {
                Configurable.Comment comment = field.getAnnotation(Configurable.Comment.class);
                if (comment == null || comment.text() == null || comment.text().length <= 0) continue;
                commentLines.put(this.convertFieldName(field), comment.text());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        FileManager.save(config, file);
        this.addComments(commentLines);
    }

    default public Config load() {
        FileConfiguration config = this.getConfig();
        for (Field field : this.getClass().getDeclaredFields()) {
            Configurable configurable;
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            try {
                configurable = field.getAnnotation(Configurable.class);
            }
            catch (Exception e) {
                continue;
            }
            if (configurable == null || configurable.override()) continue;
            String path = this.getFieldPath(field, configurable.section());
            if (field.getType().isAssignableFrom(HashMap.class) || field.getType().isInstance(HashMap.class)) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                ConfigurationSection section = config.getConfigurationSection(path);
                if (section == null || section.getKeys(false).size() <= 0) continue;
                for (String key : section.getKeys(false)) {
                    try {
                        map.put(key, section.get(key));
                    }
                    catch (Exception e) {
                        Bukkit.getLogger().log(Level.WARNING, "Config loading error: " + section.get(key).toString() + " could not be loaded.");
                    }
                }
                try {
                    field.set(this, map);
                }
                catch (IllegalAccessException e) {
                    Bukkit.getLogger().log(Level.WARNING, "Config loading error in: " + this.getFileName());
                }
                continue;
            }
            if (!config.isSet(path)) continue;
            Object value = config.get(path);
            try {
                if (field.getType().getEnumConstants() != null) {
                    Method getter = field.getType().getMethod("valueOf", String.class);
                    value = getter.invoke(field.getType(), (String)value);
                } else {
                    value = value instanceof String ? this.matchString(field, value) : this.adjustValue(field, value);
                }
                value = this.deserialise(field, value);
                field.set(this, value);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                // empty catch block
            }
        }
        this.save();
        return this;
    }

    default public Object serialise(Field field, Object value) {
        Configurable.Serialise serialise = field.getAnnotation(Configurable.Serialise.class);
        if (serialise == null || !serialise.stringify()) {
            return value;
        }
        return value.toString();
    }

    default public Object deserialise(Field field, Object value) {
        Configurable.Serialise serialise = field.getAnnotation(Configurable.Serialise.class);
        if (serialise == null) {
            return value;
        }
        try {
            Method method = field.getClass().getMethod(serialise.method(), value.getClass());
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            return method.invoke((Object)this, value);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            return value.toString();
        }
    }

    default public void addComments(@NotNull HashMap<String, String[]> commentLines) {
        File file = this.getFile();
        ArrayList<String> lines = new ArrayList<String>();
        try {
            FileReader reader = new FileReader(file);
            StringBuffer buffer = new StringBuffer();
            while (reader.ready()) {
                char c = (char)reader.read();
                if (c == '\n') {
                    lines.add(buffer.toString());
                    buffer = new StringBuffer();
                    continue;
                }
                buffer.append(c);
            }
            if (buffer.length() > 0) {
                lines.add(buffer.toString());
            }
            reader.close();
        }
        catch (IOException e) {
            return;
        }
        lines.removeIf(string -> string.trim().startsWith("#"));
        int i = 0;
        try {
            Configurable.Header header = this.getClass().getAnnotation(Configurable.Header.class);
            if (header != null && header.text().length > 0) {
                String[] comments;
                for (String comment : comments = header.text()) {
                    lines.add(i, "# " + comment);
                    ++i;
                }
            }
        }
        catch (Exception header) {
            // empty catch block
        }
        for (String line : new ArrayList(lines)) {
            if (!line.contains(":")) continue;
            String key = line.trim().split(":")[0];
            String indent = "";
            Pattern pattern = Pattern.compile("^(\\s+)");
            Matcher matcher = pattern.matcher(line);
            if (matcher.find()) {
                indent = matcher.group();
            }
            if (commentLines.containsKey(key)) {
                String[] comments;
                for (String comment : comments = commentLines.get(key)) {
                    lines.add(i, indent + "# " + comment);
                    ++i;
                }
            }
            ++i;
        }
        try {
            FileWriter writer = new FileWriter(file);
            for (String string2 : lines) {
                writer.write(string2 + System.lineSeparator());
            }
            writer.close();
        }
        catch (IOException e) {
            return;
        }
    }

    default public Object matchString(Field field, Object value) {
        Configurable.Regex matcher = field.getAnnotation(Configurable.Regex.class);
        if (matcher == null) {
            return value;
        }
        String v = (String)value;
        String regex = matcher.matcher();
        if (v.matches(regex)) {
            return value;
        }
        return matcher.alternative();
    }

    default public Object adjustValue(Field field, Object value) {
        Configurable.Bounded bounded = field.getAnnotation(Configurable.Bounded.class);
        if (bounded == null) {
            return value;
        }
        if (value instanceof Integer) {
            int v = (Integer)value;
            if ((double)v > bounded.maxValue()) {
                v = Math.min(v, (int)Math.floor(bounded.maxValue()));
            }
            if ((double)v > bounded.minValue()) {
                v = Math.max(v, (int)Math.floor(bounded.minValue()));
            }
            value = v;
        } else if (value instanceof Long) {
            long v = (Long)value;
            if ((double)v > bounded.maxValue()) {
                v = Math.min(v, (long)Math.floor(bounded.maxValue()));
            }
            if ((double)v > bounded.minValue()) {
                v = Math.max(v, (long)Math.floor(bounded.minValue()));
            }
            value = v;
        } else if (value instanceof Double) {
            double v = (Double)value;
            if (v > bounded.maxValue()) {
                v = Math.min(v, Math.floor(bounded.maxValue()));
            }
            if (v > bounded.minValue()) {
                v = Math.max(v, Math.floor(bounded.minValue()));
            }
            value = v;
        } else if (value instanceof Float) {
            float v = ((Float)value).floatValue();
            if ((double)v > bounded.maxValue()) {
                v = Math.min(v, (float)Math.floor(bounded.maxValue()));
            }
            if ((double)v > bounded.minValue()) {
                v = Math.max(v, (float)Math.floor(bounded.minValue()));
            }
            value = Float.valueOf(v);
        }
        return value;
    }

    default public String convertFieldName(Field field) {
        String fieldName = CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, field.getName());
        try {
            Configurable.Keyed keyed = field.getAnnotation(Configurable.Keyed.class);
            if (keyed != null && keyed.nodeName().length() > 0 && keyed.nodeName().matches("^[a-zA-Z0-9_-]+$")) {
                fieldName = keyed.nodeName();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return fieldName;
    }

    default public String getFieldPath(Field field, String parent) {
        String path;
        String fieldName = this.convertFieldName(field);
        if (parent.length() > 0) {
            path = parent;
            if (!path.endsWith(".")) {
                path = path + ".";
            }
            path = path + fieldName;
        } else {
            path = fieldName;
        }
        return path;
    }

    @API
    @NotNull
    public String getFolderPath();

    @API
    @NotNull
    public String getFileName();

    default public FileConfiguration getConfig() {
        return FileManager.getFile(this.getFolderPath(), this.getFileName());
    }

    default public File getFile() {
        return new File(this.getFolderPath(), this.getFileName());
    }
}

