/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.transk.mask.template;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptAddon;
import ch.njol.skript.lang.ExpressionType;
import com.moderocky.transk.mask.Mask;
import com.moderocky.transk.mask.annotation.API;
import com.moderocky.transk.mask.annotation.Internal;
import com.moderocky.transk.mask.annotation.Unsafe;
import com.moderocky.transk.mask.bstats.bukkit.Metrics;
import com.moderocky.transk.mask.gui.MenuGUI;
import com.moderocky.transk.mask.template.CompleteCommand;
import com.moderocky.transk.mask.template.CompleteListener;
import com.moderocky.transk.mask.template.CompleteRecipe;
import com.moderocky.transk.mask.template.IPlugin;
import com.moderocky.transk.mask.template.WrappedCommand;
import com.moderocky.transk.mask.template.skript.WrappedExpression;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.inventory.Recipe;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.java.JavaPluginLoader;
import org.jetbrains.annotations.NotNull;

@API
public abstract class BukkitPlugin
extends JavaPlugin
implements IPlugin {
    private static BukkitPlugin instance;
    private final Metrics maskMetrics = new Metrics((Plugin)this, 6786);
    private SkriptAddon addon;

    public BukkitPlugin() {
    }

    protected BukkitPlugin(@NotNull JavaPluginLoader loader, @NotNull PluginDescriptionFile description, @NotNull File dataFolder, @NotNull File file) {
        super(loader, description, dataFolder, file);
    }

    @API
    public static BukkitPlugin getInstance() {
        return instance;
    }

    @Unsafe
    @Internal
    protected void setInstance(@Nullable BukkitPlugin plugin) {
        instance = plugin;
    }

    @API
    public static <Z extends Event> void callEvent(Z event) {
        Bukkit.getScheduler().runTask((Plugin)BukkitPlugin.getInstance(), () -> Bukkit.getServer().getPluginManager().callEvent(event));
    }

    @API
    public static FixedMetadataValue getMetaValue(Object object) {
        return new FixedMetadataValue((Plugin)BukkitPlugin.getInstance(), object);
    }

    @API
    public static NamespacedKey getNamespacedKey(String string) {
        return new NamespacedKey((Plugin)BukkitPlugin.getInstance(), string);
    }

    public static boolean isPaper() {
        try {
            Class.forName("co.aikar.timings.Timing");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    @API
    public String getVersion() {
        return this.getDescription().getVersion();
    }

    @API
    public String getAPIVersion() {
        return this.getDescription().getAPIVersion();
    }

    @API
    public String getPluginDescription() {
        return this.getDescription().getDescription();
    }

    @API
    public String getFullName() {
        return this.getDescription().getFullName();
    }

    @API
    public String getPrefix() {
        return this.getDescription().getPrefix();
    }

    @API
    public boolean areDependenciesMet() {
        if (this.getDescription().getSoftDepend().size() > 0) {
            for (String string : this.getDescription().getSoftDepend()) {
                if (Bukkit.getPluginManager().getPlugin(string) != null) continue;
                return false;
            }
        }
        return true;
    }

    @API
    public String getCraftVersion() {
        return Bukkit.getServer().getClass().getPackage().getName().split("\\.")[3];
    }

    @API
    public void disablePlugin() {
        Bukkit.getPluginManager().disablePlugin((Plugin)this);
    }

    @Internal
    public void onEnable() {
        this.setInstance(this);
        this.registerMask();
        this.registerAddon();
        this.startup();
        this.registerManagers();
        this.registerProtocol();
        this.registerListeners();
        this.registerRecipes();
        this.registerEvents();
        this.registerCommands();
        if (Mask.getMask().hasSkript()) {
            this.registerSyntax();
        }
    }

    @Internal
    public void onDisable() {
        this.disable();
        this.setInstance(null);
        this.unregisterMask();
    }

    @API
    public SkriptAddon getAddon() {
        return this.addon;
    }

    @Internal
    private void unregisterMask() {
        Mask.setMask(null, null);
    }

    @Internal
    private void registerMask() {
        Mask.setMask(new Mask(), this);
    }

    @Internal
    private void registerAddon() {
        this.addon = Mask.getMask().hasSkript() ? Skript.registerAddon((JavaPlugin)this) : null;
    }

    @Override
    @API
    public String getConfigPath() {
        return "plugins/" + this.getName() + "/config.yml";
    }

    @API
    public void resetConfig() {
    }

    @API
    protected void register(WrappedCommand ... commands) {
        for (WrappedCommand command : commands) {
            try {
                Constructor commandConstructor = PluginCommand.class.getDeclaredConstructor(String.class, Plugin.class);
                if (!commandConstructor.isAccessible()) {
                    commandConstructor.setAccessible(true);
                }
                PluginCommand pluginCommand = (PluginCommand)commandConstructor.newInstance(command.getCommand(), BukkitPlugin.getInstance());
                pluginCommand.setAliases(command.getAliases());
                pluginCommand.setDescription(command.getDescription());
                pluginCommand.setPermission(command.getPermission());
                pluginCommand.setPermissionMessage(command.getPermissionMessage());
                pluginCommand.setUsage(command.getUsage());
                pluginCommand.register(this.getServer().getCommandMap());
                if (this.getServer().getCommandMap().register(command.getCommand(), this.getName(), (Command)pluginCommand)) {
                    pluginCommand.setExecutor((CommandExecutor)command);
                    pluginCommand.setTabCompleter((TabCompleter)command);
                    continue;
                }
                Command com = this.getServer().getCommandMap().getCommand(pluginCommand.getName());
                if (com instanceof PluginCommand) {
                    ((PluginCommand)com).setExecutor((CommandExecutor)command);
                    ((PluginCommand)com).setTabCompleter((TabCompleter)command);
                }
                Bukkit.getLogger().log(Level.WARNING, "A command '/" + command.getCommand() + "' is already defined!");
                Bukkit.getLogger().log(Level.WARNING, "As this cannot be replaced, the executor will be overridden.");
                Bukkit.getLogger().log(Level.WARNING, "To avoid this warning, please do not add WrappedCommands to your plugin.yml.");
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    protected boolean isRegistered(CompleteCommand command) {
        return this.getCommand(command.getCommand()) != null;
    }

    protected boolean isRegistered(String command) {
        return this.getCommand(command) != null;
    }

    @API
    protected void register(CompleteCommand ... commands) {
        if (commands == null) {
            return;
        }
        for (CompleteCommand completeCommand : commands) {
            PluginCommand pluginCommand = this.getCommand(completeCommand.getCommand());
            if (pluginCommand == null) {
                return;
            }
            pluginCommand.setExecutor((CommandExecutor)completeCommand);
        }
    }

    @API
    protected void register(MenuGUI ... guis) {
        for (MenuGUI gui : guis) {
            Bukkit.getServer().getPluginManager().registerEvents((Listener)gui, (Plugin)BukkitPlugin.getInstance());
        }
    }

    @API
    protected void register(CompleteListener ... listeners) {
        if (listeners == null) {
            return;
        }
        for (CompleteListener completeListener : listeners) {
            Bukkit.getServer().getPluginManager().registerEvents((Listener)completeListener, (Plugin)BukkitPlugin.getInstance());
        }
    }

    @API
    protected void register(CompleteRecipe ... recipes) {
        if (recipes == null) {
            return;
        }
        for (CompleteRecipe completeRecipe : recipes) {
            if (!completeRecipe.isEnabled()) continue;
            Bukkit.addRecipe((Recipe)completeRecipe.getRecipe());
        }
    }

    @API
    protected void registerSyntaxExpressions(WrappedExpression<?> ... expressions) {
        for (WrappedExpression<?> expression : expressions) {
            Skript.registerExpression(expression.getClass(), (Class)expression.getReturnType(), (ExpressionType)expression.getType(), (String[])expression.getPatterns());
        }
    }

    @API
    protected void registerRecipes() {
    }

    @API
    protected void registerListeners() {
    }

    @API
    protected void registerCommands() {
    }

    @API
    protected void registerManagers() {
    }

    @API
    protected void registerProtocol() {
    }

    @API
    protected void registerSyntax() {
    }

    @API
    protected void registerEvents() {
    }
}

