/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.transk.mask.internal.utility;

import com.moderocky.transk.mask.Mask;
import com.moderocky.transk.mask.annotation.Internal;
import com.moderocky.transk.mask.template.BukkitPlugin;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;

@Internal
public class FileManager {
    public static FileConfiguration getFile(@NotNull String folder, @NotNull String name) {
        File path = new File(folder, name);
        return YamlConfiguration.loadConfiguration((File)path);
    }

    public static void putIfAbsent(@NotNull File file) {
        if (!file.exists()) {
            try {
                file.getParentFile().mkdirs();
                file.createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void save(final @NotNull FileConfiguration file, final @NotNull File path) {
        block2: {
            try {
                FileManager.putIfAbsent(path);
                file.save(path);
            }
            catch (IOException e) {
                if (!Mask.getPlugin().isBukkit() || !(Mask.getPlugin() instanceof BukkitPlugin)) break block2;
                new BukkitRunnable(){

                    public void run() {
                        FileManager.save(file, path);
                    }
                }.runTaskLater((Plugin)((BukkitPlugin)Mask.getPlugin()), 30L);
            }
        }
    }

    public static void clear(@NotNull File file) {
        try {
            PrintWriter writer = new PrintWriter(file);
            writer.print("");
            writer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

