/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.transk.mask.internal.mapper;

import com.moderocky.transk.mask.internal.mapper.MapConverter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GenderfluidMapConverter
implements MapConverter {
    @NotNull
    private final List<Object> keys = new ArrayList<Object>();
    @NotNull
    private final List<Object> values = new ArrayList<Object>();

    boolean apply(Object object, Method method, boolean stringifyKeys, boolean stringifyValues) {
        assert (this.keys.size() == this.values.size());
        if (!method.isAccessible()) {
            method.setAccessible(true);
        }
        int i = 0;
        try {
            if (stringifyKeys) {
                if (stringifyValues) {
                    for (Object key : this.keys) {
                        method.invoke(object, key.toString(), this.values.get(i).toString());
                        ++i;
                    }
                } else {
                    for (Object key : this.keys) {
                        method.invoke(object, key.toString(), this.values.get(i));
                        ++i;
                    }
                }
            } else if (stringifyValues) {
                for (Object key : this.keys) {
                    method.invoke(object, key, this.values.get(i).toString());
                    ++i;
                }
            } else {
                for (Object key : this.keys) {
                    method.invoke(object, key, this.values.get(i));
                    ++i;
                }
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            return false;
        }
        return true;
    }

    public boolean retrieve(Object object, Method keySet, Method valueSet) {
        if (!keySet.isAccessible()) {
            keySet.setAccessible(true);
        }
        if (!valueSet.isAccessible()) {
            valueSet.setAccessible(true);
        }
        if (!keySet.getReturnType().isInstance(Collection.class) && !keySet.getReturnType().isAssignableFrom(Collection.class)) {
            return false;
        }
        if (!valueSet.getReturnType().isInstance(Collection.class) && !valueSet.getReturnType().isAssignableFrom(Collection.class)) {
            return false;
        }
        try {
            ArrayList k = new ArrayList((Collection)keySet.invoke(object, new Object[0]));
            ArrayList v = new ArrayList((Collection)valueSet.invoke(object, new Object[0]));
            if (k.size() != v.size()) {
                return false;
            }
            this.keys.clear();
            this.values.clear();
            this.keys.addAll(k);
            this.values.addAll(v);
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    @Override
    public List<String> getDeserialisedKeys() {
        ArrayList<String> list = new ArrayList<String>();
        for (Object key : this.keys) {
            list.add(key.toString());
        }
        return list;
    }

    @NotNull
    public List<Object> getKeys() {
        return this.keys;
    }

    @Override
    public List<String> getDeserialisedValues() {
        ArrayList<String> list = new ArrayList<String>();
        for (Object value : this.values) {
            list.add(value.toString());
        }
        return list;
    }

    @NotNull
    public List<Object> getValues() {
        return this.values;
    }
}

