/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.transk.mask.internal.mapper;

import com.moderocky.transk.mask.internal.mapper.MapConverter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class GenderedMapConverter<A, B>
implements MapConverter {
    @NotNull
    private final List<A> keys = new ArrayList<A>();
    @NotNull
    private final List<B> values = new ArrayList<B>();
    private final Consumer<A> keyConsumer;
    private final Consumer<B> valueConsumer;

    public GenderedMapConverter(@NotNull Consumer<A> keyConsumer, @NotNull Consumer<B> valueConsumer) {
        this.keyConsumer = keyConsumer;
        this.valueConsumer = valueConsumer;
    }

    public boolean apply() {
        this.keys.forEach(this.keyConsumer);
        this.values.forEach(this.valueConsumer);
        return true;
    }

    public void input(A[] as, B[] bs) {
        this.values.clear();
        this.values.addAll(Arrays.asList(bs));
    }

    @Override
    public List<String> getDeserialisedKeys() {
        ArrayList<String> list = new ArrayList<String>();
        for (A key : this.keys) {
            list.add(key.toString());
        }
        return list;
    }

    @NotNull
    public List<A> getKeys() {
        return this.keys;
    }

    @Override
    public List<String> getDeserialisedValues() {
        ArrayList<String> list = new ArrayList<String>();
        for (B value : this.values) {
            list.add(value.toString());
        }
        return list;
    }

    @NotNull
    public List<B> getValues() {
        return this.values;
    }
}

