/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.transk.mask.gui;

import com.moderocky.transk.mask.gui.VisualGUI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiConsumer;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;

public class PaginatedGUI
extends VisualGUI {
    private final List<ItemStack> entries = new ArrayList<ItemStack>();
    private char entryChar;
    private BiConsumer<Player, InventoryClickEvent> consumer = null;
    private int pageCount = 0;
    private int page = 0;

    public PaginatedGUI(Plugin plugin, InventoryType type, String title) {
        super(plugin, type, title);
    }

    public PaginatedGUI(Plugin plugin, int size, String title) {
        super(plugin, size, title);
    }

    public void setEntryConsumer(@NotNull BiConsumer<Player, InventoryClickEvent> consumer) {
        this.consumer = consumer;
    }

    public BiConsumer<Player, InventoryClickEvent> getEntryConsumer() {
        return this.consumer;
    }

    public void setEntryChar(char c) {
        this.entryChar = c;
    }

    public List<ItemStack> getEntries() {
        return new ArrayList<ItemStack>(this.entries);
    }

    public void setEntries(Collection<ItemStack> entries) {
        this.entries.clear();
        this.entries.addAll(entries);
    }

    public void setEntries(ItemStack ... entries) {
        this.entries.clear();
        this.entries.addAll(Arrays.asList(entries));
    }

    public BiConsumer<Player, InventoryClickEvent> getPageUp() {
        return (player, event) -> {
            final PaginatedGUI gui = this;
            new BukkitRunnable(){

                public void run() {
                    gui.next();
                }
            }.runTaskLater(this.plugin, 1L);
        };
    }

    public BiConsumer<Player, InventoryClickEvent> getPageDown() {
        return (player, event) -> {
            final PaginatedGUI gui = this;
            new BukkitRunnable(){

                public void run() {
                    gui.prev();
                }
            }.runTaskLater(this.plugin, 1L);
        };
    }

    @Override
    public PaginatedGUI setLayout(String[] layout) {
        return (PaginatedGUI)super.setLayout(layout);
    }

    public BiConsumer<Player, InventoryClickEvent> getPageReset() {
        return (player, event) -> {
            final PaginatedGUI gui = this;
            new BukkitRunnable(){

                public void run() {
                    gui.reset();
                }
            }.runTaskLater(this.plugin, 1L);
        };
    }

    public void next() {
        this.page = Math.min(this.pageCount, this.page + 1);
        this.createPage();
    }

    public void prev() {
        this.page = Math.max(0, this.page - 1);
        this.createPage();
    }

    public void reset() {
        this.page = 0;
        this.createPage();
    }

    private void createPage() {
        this.clearEntrySlots();
        int[] ints = this.getSlots(this.entryChar);
        Integer[] integers = new Integer[ints.length];
        for (int i = 0; i < ints.length; ++i) {
            integers[i] = ints[i];
        }
        Iterator<Integer> iterator = Arrays.asList(integers).iterator();
        for (int i = Math.round(this.page * ints.length); i < Math.round((this.page + 1) * this.getSlots(this.entryChar).length) && iterator.hasNext() && i < this.entries.size(); ++i) {
            int j = iterator.next();
            if (j < 0 || j >= this.inventory.getSize()) continue;
            this.inventory.setItem(j, this.entries.get(i));
        }
    }

    private void clearEntrySlots() {
        for (int slot : this.getSlots(this.entryChar)) {
            this.inventory.setItem(slot, new ItemStack(Material.AIR));
        }
    }

    private int getFreeSlotCount() {
        int j = 0;
        for (int i = 0; i < this.inventory.getSize(); ++i) {
            ItemStack stack = this.inventory.getItem(i);
            if (stack != null && stack.getType() != Material.AIR) continue;
            ++j;
        }
        return j;
    }

    private int[] getFreeSlots() {
        ArrayList<Integer> slots = new ArrayList<Integer>();
        for (int i = 0; i < this.inventory.getSize(); ++i) {
            ItemStack stack = this.inventory.getItem(i);
            if (stack != null && stack.getType() != Material.AIR) continue;
            slots.add(i);
        }
        int[] ints = new int[slots.size()];
        int i = 0;
        for (Integer slot : slots) {
            ints[i] = slot;
            ++i;
        }
        return ints;
    }

    @Override
    public void finalise() {
        super.finalise();
        this.pageCount = (int)Math.ceil((float)this.entries.size() / (float)this.getSlots(this.entryChar).length);
        this.reset();
    }

    @Override
    public void open(Player player) {
        super.open(player);
    }

    @Override
    @EventHandler(priority=EventPriority.HIGH)
    public void onClick(InventoryClickEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (this.players.isEmpty()) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        if (!this.players.contains(player)) {
            return;
        }
        Inventory clicked = event.getClickedInventory();
        if (clicked == null) {
            return;
        }
        if (!clicked.equals(this.inventory)) {
            return;
        }
        ItemStack itemStack = event.getCurrentItem();
        if (itemStack == null) {
            return;
        }
        if (!this.editable) {
            event.setCancelled(true);
        }
        if (this.map.containsKey(event.getSlot())) {
            ((BiConsumer)this.map.get(event.getSlot())).accept(player, event);
        } else if (Arrays.stream(this.getSlots(this.entryChar)).anyMatch(i -> i == event.getSlot()) && this.consumer != null) {
            this.consumer.accept(player, event);
        }
    }

    @Override
    @EventHandler
    public void onClose(InventoryCloseEvent event) {
        super.onClose(event);
        this.reset();
    }
}

