/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.transk.mask.command;

import com.moderocky.transk.mask.command.Argument;
import com.moderocky.transk.mask.command.ArgumentHandler;
import com.moderocky.transk.mask.internal.utility.Logic;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Commander<S> {
    private Consumer<S> errorConsumer;
    private Main main;
    private boolean registered = false;
    private List<String> patterns = null;
    @ExecutionDependent
    private volatile String input;

    public Commander() {
        this.register();
    }

    public void register() {
        this.errorConsumer = this.getDefault();
        this.main = this.create();
        this.registered = true;
    }

    public synchronized boolean execute(S sender, String ... args) {
        if (!this.registered) {
            return false;
        }
        if (args.length > 0) {
            this.input = String.join((CharSequence)" ", args);
            if (this.main.simpleMap.containsKey(this.input.toLowerCase())) {
                this.main.simpleMap.get(this.input.toLowerCase()).accept(sender);
                return true;
            }
            StringBuilder bit = new StringBuilder();
            for (String arg : args) {
                if (this.main.complexMap.containsKey(bit.toString().toLowerCase().trim())) {
                    HashMap<Argument<?>[], BiConsumer> map = this.main.complexMap.get(bit.toString().toLowerCase().trim());
                    for (Argument[] argumentArray : map.keySet()) {
                        String[] rems;
                        ArgumentHandler handler = new ArgumentHandler(argumentArray){};
                        if (!handler.canAccept(rems = String.join((CharSequence)" ", args).replaceFirst(bit.toString().trim(), "").trim().split(" "))) continue;
                        Object[] objects = new Object[argumentArray.length];
                        for (int i = 0; i < argumentArray.length; ++i) {
                            objects[i] = rems.length > i ? argumentArray[i].serialise(rems[i]) : argumentArray[i].serialise(null);
                        }
                        BiConsumer consumer = map.get(argumentArray);
                        consumer.accept(sender, objects);
                        return true;
                    }
                }
                bit.append(" ").append(arg);
            }
        }
        this.input = null;
        this.errorConsumer.accept(sender);
        return true;
    }

    @NotNull
    public abstract Main create();

    @NotNull
    public abstract Consumer<S> getDefault();

    @Nullable
    public List<String> getTabCompletions(String input) {
        String[] parts;
        ArrayList<String> strings = new ArrayList<String>();
        String[] args = input.toLowerCase().split(" ");
        String fin = args[args.length - 1];
        String bit = input.toLowerCase();
        for (int j = 0; j < args.length + 1; ++j) {
            if (this.main.complexMap.containsKey(bit.trim())) {
                for (Argument<?>[] arguments : this.main.complexMap.get(bit.trim()).keySet()) {
                    int k;
                    List<String> comps = arguments[k = Math.max(0, Math.min(bit.trim().split(" ").length - arguments.length + j, arguments.length - 1))].getCompletions();
                    if (comps == null) continue;
                    strings.addAll(comps);
                }
                break;
            }
            bit = String.join((CharSequence)" ", Logic.withoutLast(bit.split(" ")));
        }
        for (String string : this.main.simpleMap.keySet()) {
            if (!string.contains(input.toLowerCase())) continue;
            parts = string.split(" ");
            String get = parts[args.length - 1];
            if (fin.equalsIgnoreCase(get) && parts.length > args.length) {
                strings.add(parts[args.length]);
                continue;
            }
            strings.add(get);
        }
        for (String string : this.main.complexMap.keySet()) {
            if (!string.contains(this.main.label + " " + input.toLowerCase())) continue;
            parts = string.replaceFirst(this.main.label + " ", "").split(" ");
            String get = parts[args.length - 1];
            if (fin.equalsIgnoreCase(get)) {
                strings.add(parts[args.length]);
                continue;
            }
            strings.add(get);
        }
        return strings;
    }

    @NotNull
    public String getCommand() {
        return this.main.label;
    }

    @NotNull
    public List<String> getPatterns() {
        if (this.patterns == null) {
            ArrayList<String> strings = new ArrayList<String>(this.main.simpleMap.keySet());
            for (String string : new ArrayList<String>(strings)) {
                strings.removeIf(s -> string.contains((CharSequence)s) && !string.equalsIgnoreCase((String)s));
            }
            for (String path : this.main.complexMap.keySet()) {
                this.main.complexMap.get(path).keySet().forEach(arguments -> {
                    String arg = path.replaceFirst(this.getCommand() + " ", "").toLowerCase() + " " + new ArgumentHandler((Argument)arguments){}.toString();
                    strings.removeIf(arg::contains);
                    strings.add(arg);
                });
            }
            Collections.sort(strings);
            this.patterns = strings;
        }
        return new ArrayList<String>(this.patterns);
    }

    @Nullable
    public List<String> getPatterns(String input) {
        List<String> strings = this.getPatterns();
        strings.removeIf(string -> {
            for (String s : strings) {
                if (!s.contains((CharSequence)string)) continue;
                return false;
            }
            return true;
        });
        return strings;
    }

    @ExecutionDependent
    public String getInput() {
        return this.input;
    }

    @ExecutionDependent
    public int getArgs() {
        if (this.input == null || this.input.length() == 0) {
            return 0;
        }
        return this.input.split(" ").length;
    }

    public Main command(@NotNull String label) {
        return new Main(label.toLowerCase().replace(" ", "_"));
    }

    public SimpleArg arg(@NotNull String arg, @NotNull Consumer<S> consumer) {
        return new SimpleArg(arg.toLowerCase().replace(" ", "_"), consumer);
    }

    public <T> ComplexArg arg(@NotNull BiConsumer<S, Object[]> consumer, @NotNull Argument<T> a) {
        return new ComplexArg(consumer, a);
    }

    public <T> ComplexArg arg(@NotNull BiConsumer<S, Object[]> consumer, @NotNull Argument<T> a, @NotNull Argument<T> b) {
        return new ComplexArg(consumer, a, b);
    }

    public <T> ComplexArg arg(@NotNull BiConsumer<S, Object[]> consumer, @NotNull Argument<T> a, @NotNull Argument<T> b, @NotNull Argument<T> c) {
        return new ComplexArg(consumer, a, b, c);
    }

    public ComplexArg arg(@NotNull BiConsumer<S, Object[]> consumer, Argument<?> ... args) {
        return new ComplexArg(consumer, args);
    }

    public SimpleArg arg(@NotNull String arg, SimpleArg ... args) {
        return new SimpleArg(arg.toLowerCase().replace(" ", "_"), args);
    }

    public SimpleArg arg(@NotNull String arg, ComplexArg ... args) {
        return new SimpleArg(arg.toLowerCase().replace(" ", "_"), args);
    }

    protected static @interface ExecutionDependent {
    }

    protected class SimpleArg
    implements Arg<S> {
        protected final String label;
        protected final Consumer<S> consumer;
        protected final List<SimpleArg> args = new ArrayList<SimpleArg>();
        protected final List<ComplexArg> complexArgs = new ArrayList<ComplexArg>();

        protected SimpleArg(@NotNull String arg, Consumer<S> consumer) {
            this.label = arg.toLowerCase().replace(" ", "_");
            this.consumer = consumer;
        }

        @SafeVarargs
        protected SimpleArg(@NotNull String arg, SimpleArg ... args) {
            this.label = arg.toLowerCase().replace(" ", "_");
            this.consumer = Commander.this.errorConsumer;
            this.args.addAll(Arrays.asList(args));
        }

        @SafeVarargs
        protected SimpleArg(@NotNull String arg, ComplexArg ... args) {
            this.label = arg;
            this.consumer = Commander.this.errorConsumer;
            this.complexArgs.addAll(Arrays.asList(args));
        }

        @Override
        public void compile(@NotNull String parent, @NotNull HashMap<String, Consumer<S>> consumerHashMap) {
            consumerHashMap.put(parent + " " + this.label, this.consumer);
            this.args.forEach(arg -> {
                String string = parent + " " + this.label;
                arg.compile(string, consumerHashMap);
            });
            this.complexArgs.forEach(arg -> {
                String string = parent + " " + this.label;
                arg.compile(string, consumerHashMap);
            });
        }
    }

    protected class ComplexArg
    implements Arg<S> {
        protected final Argument<?>[] args;
        protected final BiConsumer consumer;

        public ComplexArg(@NotNull BiConsumer consumer, Argument<?> ... args) {
            this.args = args;
            this.consumer = consumer;
        }

        @Override
        public void compile(@NotNull String parent, @NotNull HashMap<String, Consumer<S>> consumerHashMap) {
            Commander.this.main.register(parent.toLowerCase(), this.args, this.consumer);
        }
    }

    public class Main {
        protected final String label;
        protected final HashMap<String, Consumer<S>> simpleMap = new HashMap();
        protected final HashMap<String, HashMap<Argument<?>[], BiConsumer>> complexMap = new HashMap();

        protected Main(String label) {
            Commander.this.main = this;
            this.label = label.toLowerCase().replace(" ", "_");
        }

        public Main arg(@NotNull String arg, @NotNull Consumer<S> consumer) {
            this.simpleMap.put(arg.toLowerCase().replace(" ", "_"), consumer);
            return this;
        }

        public Main arg(@NotNull String arg, SimpleArg ... subArgs) {
            this.simpleMap.put(arg.toLowerCase().replace(" ", "_"), Commander.this.errorConsumer);
            for (SimpleArg subArg : subArgs) {
                subArg.compile(arg, this.simpleMap);
            }
            return this;
        }

        public Main arg(@NotNull String arg, @NotNull Consumer<S> consumer, SimpleArg ... subArgs) {
            this.simpleMap.put(arg.toLowerCase().replace(" ", "_"), consumer);
            for (SimpleArg subArg : subArgs) {
                subArg.compile(arg, this.simpleMap);
            }
            return this;
        }

        public Main arg(@NotNull String arg, ComplexArg ... subArgs) {
            this.simpleMap.put(arg.toLowerCase().replace(" ", "_"), Commander.this.errorConsumer);
            if (subArgs.length > 0) {
                for (ComplexArg subArg : subArgs) {
                    subArg.compile(arg, this.simpleMap);
                }
            }
            return this;
        }

        public Main arg(@NotNull String arg, @NotNull Consumer<S> consumer, ComplexArg ... subArgs) {
            this.simpleMap.put(arg.toLowerCase().replace(" ", "_"), consumer);
            if (subArgs.length > 0) {
                for (ComplexArg subArg : subArgs) {
                    subArg.compile(arg, this.simpleMap);
                }
            }
            return this;
        }

        public <T> Main arg(@NotNull Argument<T> arg, @NotNull BiConsumer<S, Object[]> consumer) {
            this.register(this.label, new Argument[]{arg}, consumer);
            return this;
        }

        public Main arg(@NotNull BiConsumer<S, Object[]> consumer, Argument<?> ... args) {
            if (args.length > 0) {
                this.register(this.label, args, consumer);
            }
            return this;
        }

        protected void register(String path, Argument<?>[] args, BiConsumer consumer) {
            HashMap<Argument<?>[], BiConsumer> map = this.getMap(path);
            map.put(args, consumer);
        }

        protected final HashMap<Argument<?>[], BiConsumer> getMap(String key) {
            if (this.complexMap.containsKey(key)) {
                return this.complexMap.get(key);
            }
            HashMap<Argument<?>[], BiConsumer> map = new HashMap<Argument<?>[], BiConsumer>();
            this.complexMap.put(key, map);
            return map;
        }
    }

    protected static interface Arg<S> {
        public void compile(@NotNull String var1, @NotNull HashMap<String, Consumer<S>> var2);
    }
}

