/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.transk.mask.api.web.event;

import com.moderocky.transk.mask.api.web.Method;
import com.moderocky.transk.mask.api.web.WebConnection;
import com.moderocky.transk.mask.api.web.WebServer;
import com.moderocky.transk.mask.api.web.event.WebActionEvent;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.Socket;
import org.jetbrains.annotations.NotNull;

public abstract class ResponseEvent
extends WebActionEvent {
    private final BufferedOutputStream output;
    private final PrintWriter writer;
    private final BufferedReader reader;
    private final String requested;
    private final WebConnection connection;

    protected ResponseEvent(@NotNull WebServer<?> server, @NotNull WebConnection connection, @NotNull Socket socket, @NotNull Method method, BufferedOutputStream outputStream, BufferedReader reader, PrintWriter writer, String requested) {
        super(server, socket, method);
        this.output = outputStream;
        this.writer = writer;
        this.requested = requested;
        this.reader = reader;
        this.connection = connection;
    }

    public void sendResponse(String fileContent, String contentType) throws IOException {
        int fileLength = fileContent.length();
        byte[] fileData = fileContent.getBytes();
        this.writer.println("HTTP/1.1 200 OK");
        this.connection.outPrinter(this.writer, this.output, fileLength, contentType, fileData);
        this.setCancelled(true);
    }

    public void sendFileResponse(File file) throws IOException {
        int fileLength = (int)file.length();
        String content = this.connection.getContentType(file.getName());
        byte[] fileData = this.connection.readFileData(file, fileLength);
        this.writer.println("HTTP/1.1 200 OK");
        this.connection.outPrinter(this.writer, this.output, fileLength, content, fileData);
        this.setCancelled(true);
    }

    public BufferedReader getReader() {
        return this.reader;
    }

    public PrintWriter getWriter() {
        return this.writer;
    }

    public BufferedOutputStream getOutputStream() {
        return this.output;
    }

    public String getFileRequested() {
        return this.requested;
    }
}

