/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.transk.mask.api.web;

import com.moderocky.transk.mask.annotation.API;
import com.moderocky.transk.mask.api.web.WebConnection;
import com.moderocky.transk.mask.api.web.WebRequestListener;
import com.moderocky.transk.mask.api.web.event.WebActionEvent;
import com.moderocky.transk.mask.internal.utility.FileManager;
import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.jetbrains.annotations.NotNull;

@API
public abstract class WebServer<C extends WebConnection>
extends Thread
implements Runnable {
    private final File webRoot;
    private final boolean debug;
    @NotNull
    private final List<WebConnection> connectionPool = new ArrayList<WebConnection>();
    @NotNull
    private final HashMap<Class<? extends WebActionEvent>, List<WebRequestListener>> eventListenerMap = new HashMap();
    private final int port;
    @NotNull
    private final String defaultFile = "index.html";
    @NotNull
    private final String fileNotFound = "404.html";
    @NotNull
    private final String methodNotSupported = "not_supported.html";
    private boolean run = true;

    public WebServer(int port, String webContentRoot) {
        this.port = port;
        this.debug = false;
        this.webRoot = new File(webContentRoot);
    }

    public WebServer(int port, String webContentRoot, boolean sendDebugMessages) {
        this.port = port;
        this.debug = sendDebugMessages;
        this.webRoot = new File(webContentRoot);
    }

    protected <X extends WebActionEvent> X callEvent(X event) {
        Class<?> clarse = event.getClass();
        if (!this.eventListenerMap.containsKey(clarse)) {
            return event;
        }
        List<WebRequestListener> listeners = this.eventListenerMap.get(clarse);
        this.eventListenerMap.get(clarse).forEach(listener -> listener.onEvent(event));
        return event;
    }

    public void registerListener(Class<? extends WebActionEvent> event, WebRequestListener<?> listener) {
        if (this.eventListenerMap.containsKey(event)) {
            List<WebRequestListener> listeners = this.eventListenerMap.get(event);
            listeners.add(listener);
            this.eventListenerMap.replace(event, listeners);
        } else {
            ArrayList listeners = new ArrayList();
            listeners.add(listener);
            this.eventListenerMap.put(event, listeners);
        }
    }

    public boolean isDebug() {
        return this.debug;
    }

    public File getWebRootFolder() {
        return this.webRoot;
    }

    @NotNull
    public String getDefaultFileName() {
        return "index.html";
    }

    @NotNull
    public String get404() {
        return "404.html";
    }

    @NotNull
    public String getMethodNotSupportedFileName() {
        return "not_supported.html";
    }

    @Override
    public void run() {
        block5: {
            try {
                this.webRoot.mkdirs();
                Arrays.asList("index.html", "404.html", "not_supported.html").forEach(string -> FileManager.putIfAbsent(new File(this.webRoot, (String)string)));
                ServerSocket serverConnect = new ServerSocket(this.port);
                if (this.debug) {
                    Bukkit.getLogger().info("Webserver opened on port " + this.port + ".");
                }
                while (this.run) {
                    C webConnection = this.createConnection(serverConnect.accept());
                    if (this.debug) {
                        Bukkit.getLogger().info("Connection opened. (" + new Date() + ")");
                    }
                    ((Thread)webConnection).start();
                }
            }
            catch (IOException e) {
                if (!this.debug) break block5;
                Bukkit.getLogger().log(Level.WARNING, "Server connection error: " + e.getMessage());
            }
        }
    }

    public abstract C createConnection(Socket var1);

    public int getPort() {
        return this.port;
    }

    public boolean hasConnections() {
        return !this.connectionPool.isEmpty();
    }

    protected void addConnection(WebConnection connection) {
        this.connectionPool.add(connection);
    }

    protected void removeConnection(WebConnection connection) {
        this.connectionPool.remove(connection);
    }

    @NotNull
    public List<WebConnection> getConnectionPool() {
        return this.connectionPool;
    }

    public void shutDown() {
        this.run = false;
    }
}

