/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.transk.mask.api.json;

import com.google.gson.JsonObject;
import com.moderocky.transk.mask.api.json.APICollector;
import com.moderocky.transk.mask.api.json.JSonProperty;
import com.moderocky.transk.mask.api.web.WebConnection;
import com.moderocky.transk.mask.api.web.WebRequestListener;
import com.moderocky.transk.mask.api.web.WebServer;
import com.moderocky.transk.mask.api.web.event.GetEvent;
import java.io.IOException;
import java.net.Socket;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class WebJSonAPI
extends WebServer<WebConnection> {
    @NotNull
    private final HashMap<String, APICollector> apiCollectorHashMap = new HashMap();

    public WebJSonAPI(int port, String webContentRoot) {
        super(port, webContentRoot);
        this.registerListener(GetEvent.class, new RequestListener());
    }

    public void registerCollector(@NotNull APICollector collector) {
        this.apiCollectorHashMap.put(collector.getID(), collector);
    }

    protected APICollector getCollector(String id) {
        return this.apiCollectorHashMap.get(id);
    }

    protected abstract String getInvalidUseMessage();

    protected abstract String getContent();

    @Override
    public WebConnection createConnection(Socket socket) {
        return new WebConnection(socket, this){};
    }

    public class RequestListener
    implements WebRequestListener<GetEvent> {
        @Override
        public void onEvent(GetEvent event) {
            String id = event.getFileRequested();
            if (id == null) {
                return;
            }
            String[] tokens = id.split("/");
            try {
                if (tokens.length < 3) {
                    event.sendResponse(WebJSonAPI.this.getInvalidUseMessage(), "text/html");
                } else {
                    APICollector collector = WebJSonAPI.this.getCollector(tokens[1]);
                    if (collector == null) {
                        event.sendResponse(WebJSonAPI.this.getInvalidUseMessage(), "text/html");
                        return;
                    }
                    @NotNull List<JSonProperty> properties = collector.getProperties(tokens[2]);
                    JsonObject object = new JsonObject();
                    for (JSonProperty property : properties) {
                        Object value = property.getValue();
                        if (value instanceof String) {
                            object.addProperty(property.getName(), (String)value);
                            continue;
                        }
                        if (value instanceof Boolean) {
                            object.addProperty(property.getName(), (Boolean)value);
                            continue;
                        }
                        if (value instanceof Number) {
                            object.addProperty(property.getName(), (Number)value);
                            continue;
                        }
                        if (value instanceof Character) {
                            object.addProperty(property.getName(), (Character)value);
                            continue;
                        }
                        object.addProperty(property.getName(), value.toString());
                    }
                    event.sendResponse(object.toString(), "text/plain");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

