/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.transk.mask.api.container;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TriPositionalMap<X> {
    @NotNull
    private final Comparator<Coords> comparator = (o1, o2) -> {
        int d = o1.y - o2.y;
        if (d == 0) {
            d = o1.x - o2.y;
        }
        if (d == 0) {
            d = o1.z - o2.y;
        }
        return d;
    };
    @NotNull
    private final TreeMap<Coords, X> map = new TreeMap(this.comparator);

    @Nullable
    public X get(int x, int y, int z) {
        Coords coords = new Coords(x, y, z);
        return this.map.get(coords);
    }

    public X getOrDefault(int x, int y, int z, X def) {
        Coords coords = new Coords(x, y, z);
        return this.map.getOrDefault(coords, def);
    }

    public boolean containsEntry(int x, int y, int z) {
        Coords coords = new Coords(x, y, z);
        return this.map.containsKey(coords);
    }

    public boolean containsValue(X obj) {
        return this.map.containsValue(obj);
    }

    @Nullable
    public X put(int x, int y, int z, X obj) {
        Coords coords = new Coords(x, y, z);
        return this.map.put(coords, obj);
    }

    public boolean putIfAbsent(int x, int y, int z, X obj) {
        Coords coords = new Coords(x, y, z);
        return this.map.putIfAbsent(coords, obj) != null;
    }

    @NotNull
    public Collection<X> values() {
        return new ArrayList<X>(this.map.values());
    }

    @NotNull
    public Collection<X> getPlaneXY(int x, int y) {
        ArrayList<X> list = new ArrayList<X>();
        for (Coords coords : this.map.keySet()) {
            if (coords.x != x && coords.y != y) continue;
            list.add(this.map.get(coords));
        }
        return list;
    }

    @NotNull
    public Collection<X> getPlaneXZ(int x, int z) {
        ArrayList<X> list = new ArrayList<X>();
        for (Coords coords : this.map.keySet()) {
            if (coords.x != x && coords.z != z) continue;
            list.add(this.map.get(coords));
        }
        return list;
    }

    @NotNull
    public Collection<X> getPlaneYZ(int y, int z) {
        ArrayList<X> list = new ArrayList<X>();
        for (Coords coords : this.map.keySet()) {
            if (coords.y != y && coords.z != z) continue;
            list.add(this.map.get(coords));
        }
        return list;
    }

    @NotNull
    public Collection<X> getColumnX(int x) {
        ArrayList<X> list = new ArrayList<X>();
        for (Coords coords : this.map.keySet()) {
            if (coords.x != x) continue;
            list.add(this.map.get(coords));
        }
        return list;
    }

    @NotNull
    public Collection<X> getColumnY(int y) {
        ArrayList<X> list = new ArrayList<X>();
        for (Coords coords : this.map.keySet()) {
            if (coords.y != y) continue;
            list.add(this.map.get(coords));
        }
        return list;
    }

    @NotNull
    public Collection<X> getColumnZ(int z) {
        ArrayList<X> list = new ArrayList<X>();
        for (Coords coords : this.map.keySet()) {
            if (coords.z != z) continue;
            list.add(this.map.get(coords));
        }
        return list;
    }

    public int getX(X obj) {
        if (!this.map.containsValue(obj)) {
            throw new IllegalArgumentException("Map does not contain this entry!");
        }
        for (Coords coords : this.map.keySet()) {
            if (!this.map.get(coords).equals(obj)) continue;
            return coords.x;
        }
        throw new IllegalArgumentException("Map does not contain this entry!");
    }

    public int getY(X obj) {
        if (!this.map.containsValue(obj)) {
            throw new IllegalArgumentException("Map does not contain this entry!");
        }
        for (Coords coords : this.map.keySet()) {
            if (!this.map.get(coords).equals(obj)) continue;
            return coords.y;
        }
        throw new IllegalArgumentException("Map does not contain this entry!");
    }

    public int getZ(X obj) {
        if (!this.map.containsValue(obj)) {
            throw new IllegalArgumentException("Map does not contain this entry!");
        }
        for (Coords coords : this.map.keySet()) {
            if (!this.map.get(coords).equals(obj)) continue;
            return coords.z;
        }
        throw new IllegalArgumentException("Map does not contain this entry!");
    }

    public void clear() {
        this.map.clear();
    }

    static class Coords {
        int x;
        int y;
        int z;

        public Coords(int x, int y, int z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public boolean equals(Object o) {
            Coords c = (Coords)o;
            return c.x == this.x && c.y == this.y && c.z == this.z;
        }

        public int hashCode() {
            return new Integer(this.x + "0" + this.y + "0" + this.z);
        }
    }
}

