/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.transk.mask.api.container;

import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class NDimensionalHashMap<Q, V>
extends HashMap<Q[], V> {
    private final int dimensions;

    public NDimensionalHashMap(int dimensions) {
        this.dimensions = dimensions;
    }

    @Override
    public V get(Object key) {
        if (key == null || !key.getClass().isArray()) {
            throw new IllegalArgumentException("Key is not plural.");
        }
        Object[] objects = (Object[])key;
        if (objects.length != this.dimensions) {
            throw new IllegalArgumentException("Key does not have the correct number of dimensions.");
        }
        Class type = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        return super.get(key);
    }

    @Override
    public V put(Q[] key, V value) {
        if (key.length != this.dimensions) {
            throw new IllegalArgumentException("Key does not have the correct number of dimensions.");
        }
        return super.put(key, value);
    }

    @Override
    public void putAll(Map<? extends Q[], ? extends V> m) {
        super.putAll(m);
    }

    @Override
    public V getOrDefault(Object key, V defaultValue) {
        if (key == null || !key.getClass().isArray()) {
            throw new IllegalArgumentException("Key is not plural.");
        }
        Object[] objects = (Object[])key;
        if (objects.length != this.dimensions) {
            throw new IllegalArgumentException("Key does not have the correct number of dimensions.");
        }
        return super.getOrDefault(key, defaultValue);
    }

    @Override
    public V putIfAbsent(Q[] key, V value) {
        if (key.length != this.dimensions) {
            throw new IllegalArgumentException("Key does not have the correct number of dimensions.");
        }
        return super.putIfAbsent(key, value);
    }

    @Override
    public boolean replace(Q[] key, V oldValue, V newValue) {
        if (key.length != this.dimensions) {
            throw new IllegalArgumentException("Key does not have the correct number of dimensions.");
        }
        return super.replace(key, oldValue, newValue);
    }

    @Override
    public V replace(Q[] key, V value) {
        if (key.length != this.dimensions) {
            throw new IllegalArgumentException("Key does not have the correct number of dimensions.");
        }
        return super.replace(key, value);
    }

    public int getDimensions() {
        return this.dimensions;
    }

    @NotNull
    public Collection<V> getEntries(Q property, int position) {
        ArrayList list = new ArrayList();
        this.keySet().forEach((? super T qs) -> {
            if (qs[position].equals(property)) {
                list.add(this.get(qs));
            }
        });
        return list;
    }

    @NotNull
    public Collection<V> getEntries(Q[] properties) {
        List<Q> qList = Arrays.asList(properties);
        ArrayList list = new ArrayList();
        this.keySet().forEach((? super T qs) -> {
            int i = 0;
            for (Object q : qs) {
                if (!qList.contains(q)) continue;
                ++i;
            }
            if (i == qList.size()) {
                list.add(this.get(qs));
            }
        });
        return list;
    }

    @NotNull
    public Collection<V> getAnyMatching(Q[] properties) {
        List<Q> qList = Arrays.asList(properties);
        ArrayList list = new ArrayList();
        this.keySet().forEach((? super T qs) -> {
            for (Object q : qs) {
                if (!qList.contains(q)) continue;
                list.add(this.get(qs));
                break;
            }
        });
        return list;
    }
}

