/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.transk.mask.api.container;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public abstract class Cache<K, V>
extends HashMap<K, V> {
    @Override
    public V get(Object key) {
        if (!this.containsKey(key)) {
            try {
                Object k = key;
                this.put(k, this.getIfAbsent(k));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return super.get(key);
    }

    public abstract V getIfAbsent(K var1);

    public void update() {
        ArrayList keySet = new ArrayList(this.keySet());
        keySet.forEach((? super T k) -> this.replace(k, this.getIfAbsent(k)));
    }

    public void invalidate() {
        this.clear();
    }

    static class Node<K, V>
    implements Map.Entry<K, V> {
        final int hash;
        final K key;
        V value;
        Node<K, V> next;

        Node(int hash, K key, V value, Node<K, V> next) {
            this.hash = hash;
            this.key = key;
            this.value = value;
            this.next = next;
        }

        @Override
        public final K getKey() {
            return this.key;
        }

        @Override
        public final V getValue() {
            return this.value;
        }

        public final String toString() {
            return this.key + "=" + this.value;
        }

        @Override
        public final int hashCode() {
            return Objects.hashCode(this.key) ^ Objects.hashCode(this.value);
        }

        @Override
        public final V setValue(V newValue) {
            V oldValue = this.value;
            this.value = newValue;
            return oldValue;
        }

        @Override
        public final boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Map.Entry) {
                Map.Entry e = (Map.Entry)o;
                return Objects.equals(this.key, e.getKey()) && Objects.equals(this.value, e.getValue());
            }
            return false;
        }
    }
}

