/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.transk.mask.api;

import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.Nullable;

public class EntityUtils {
    public static boolean isLookingAt(Player player, Entity entity) {
        Location eye = player.getEyeLocation();
        Vector toEntity = entity.getLocation().add(0.0, entity.getHeight() * 0.75, 0.0).toVector().subtract(eye.toVector());
        double dot = toEntity.normalize().dot(eye.getDirection());
        return dot > 0.985;
    }

    public static boolean isLookingAt(Player player, Entity entity, double accuracy) {
        Location eye = player.getEyeLocation();
        Vector toEntity = entity.getLocation().add(0.0, entity.getHeight() * 0.75, 0.0).toVector().subtract(eye.toVector());
        double dot = toEntity.normalize().dot(eye.getDirection());
        return dot > accuracy;
    }

    @Nullable
    public static Entity getTarget(Player player, double distance, double accuracy) {
        for (Entity entity : player.getNearbyEntities(distance, distance, distance)) {
            if (entity == player || entity.isDead() || !player.hasLineOfSight(entity) || !EntityUtils.isLookingAt(player, entity, accuracy)) continue;
            return entity;
        }
        return null;
    }
}

