/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.transk.mask.api;

import java.lang.reflect.Method;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public interface Chat {
    public static BaseComponent[] reset() {
        return new ComponentBuilder("").reset().create();
    }

    public static BaseComponent[] bold() {
        return new ComponentBuilder("").bold(true).create();
    }

    public static BaseComponent[] italic() {
        return new ComponentBuilder("").italic(true).create();
    }

    public static BaseComponent[] text() {
        return TextComponent.fromLegacyText((String)"");
    }

    public static BaseComponent[] text(@NotNull String text) {
        return TextComponent.fromLegacyText((String)text);
    }

    public static BaseComponent[] text(@NotNull String text, @NotNull HoverEvent hover) {
        return new ComponentBuilder(text).event(hover).create();
    }

    public static BaseComponent[] text(@NotNull String text, @NotNull ClickEvent click) {
        return new ComponentBuilder(text).event(click).create();
    }

    public static BaseComponent[] text(@NotNull String text, BaseComponent ... with) {
        return new ComponentBuilder(text).append(with).create();
    }

    public static BaseComponent[] text(@NotNull String text, BaseComponent[] ... with) {
        ComponentBuilder builder = new ComponentBuilder(text);
        for (BaseComponent[] components : with) {
            builder.append(components);
        }
        return builder.create();
    }

    public static BaseComponent[] text(BaseComponent ... text) {
        return new ComponentBuilder("").append(text).create();
    }

    public static BaseComponent[] text(BaseComponent[] ... text) {
        ComponentBuilder builder = new ComponentBuilder("");
        for (BaseComponent[] components : text) {
            builder.append(components);
        }
        return builder.create();
    }

    public static BaseComponent[] colour(@NotNull ChatColor colour) {
        return new ComponentBuilder("").color(colour).create();
    }

    public static HoverEvent toolTip(BaseComponent ... text) {
        return new HoverEvent(HoverEvent.Action.SHOW_ITEM, text);
    }

    public static HoverEvent toolTip(@NotNull String text) {
        return new HoverEvent(HoverEvent.Action.SHOW_ITEM, new ComponentBuilder(text).create());
    }

    public static HoverEvent item(@NotNull ItemStack itemStack) {
        return new HoverEvent(HoverEvent.Action.SHOW_ITEM, new ComponentBuilder(Chat.getItemString(itemStack)).create());
    }

    public static HoverEvent entity(BaseComponent ... entity) {
        return new HoverEvent(HoverEvent.Action.SHOW_ENTITY, entity);
    }

    public static HoverEvent achievement(BaseComponent ... achievement) {
        return new HoverEvent(HoverEvent.Action.SHOW_ACHIEVEMENT, achievement);
    }

    public static ClickEvent suggest(@NotNull String text) {
        return new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, text);
    }

    public static ClickEvent run(@NotNull String text) {
        return new ClickEvent(ClickEvent.Action.RUN_COMMAND, text);
    }

    public static ClickEvent url(@NotNull String text) {
        return new ClickEvent(ClickEvent.Action.OPEN_URL, text);
    }

    public static ClickEvent file(@NotNull String text) {
        return new ClickEvent(ClickEvent.Action.OPEN_FILE, text);
    }

    public static ClickEvent page(@NotNull String text) {
        return new ClickEvent(ClickEvent.Action.CHANGE_PAGE, text);
    }

    public static ClickEvent copy(@NotNull String text) {
        for (ClickEvent.Action enumConstant : (ClickEvent.Action[])ClickEvent.Action.class.getEnumConstants()) {
            if (!enumConstant.toString().equalsIgnoreCase("COPY_TO_CLIPBOARD")) continue;
            return new ClickEvent(enumConstant, text);
        }
        return null;
    }

    public static String getItemString(ItemStack itemStack) {
        try {
            String ver = Bukkit.getServer().getClass().getPackage().getName().split("\\.")[3];
            Class<?> clarse = Class.forName("net.minecraft.server." + ver + ".NBTTagCompound");
            Object nbt = clarse.newInstance();
            Class<?> classy = Class.forName("org.bukkit.craftbukkit.v1_15_R1.inventory." + ver + ".CraftItemStack");
            Method method = classy.getMethod("asNMSCopy", ItemStack.class);
            Object nmsItem = method.invoke(classy, itemStack);
            Method meth = nmsItem.getClass().getMethod("save", clarse);
            return meth.invoke(nmsItem, nbt).toString();
        }
        catch (Throwable ignore) {
            return "{id:\"minecraft:air\",Count:1}";
        }
    }
}

