/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.item;

import com.destroystokyo.paper.Namespaced;
import com.destroystokyo.paper.inventory.meta.ArmorStandMeta;
import com.destroystokyo.paper.profile.PlayerProfile;
import com.google.common.collect.Multimap;
import com.moderocky.Bedrock;
import com.moderocky.component.LoreComponent;
import com.moderocky.component.LoreGeneric;
import com.moderocky.item.ComponentHandler;
import com.moderocky.item.NBTWrapper;
import com.moderocky.item.NBTWrapperItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import joptsimple.internal.Strings;
import net.md_5.bungee.api.chat.BaseComponent;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.bukkit.FireworkEffect;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.block.BlockState;
import org.bukkit.block.banner.Pattern;
import org.bukkit.block.data.BlockData;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.TropicalFish;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.BlockDataMeta;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.CrossbowMeta;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.KnowledgeBookMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.MapMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.inventory.meta.SpawnEggMeta;
import org.bukkit.inventory.meta.TropicalFishBucketMeta;
import org.bukkit.map.MapView;
import org.bukkit.material.MaterialData;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class ItemStacker {
    private ItemStack itemStack;

    public ItemStacker(ItemStack itemStack) {
        this.itemStack = itemStack;
    }

    public ItemStacker(Material material) {
        this.itemStack = new ItemStack(material);
    }

    public ItemStacker(Material material, int i) {
        this.itemStack = new ItemStack(material, i);
    }

    public static ItemStacker deserialise(String string) {
        return new ItemStacker(new NBTWrapperItem(string).getBukkitItemStack());
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public ItemStacker setAmount(int i) {
        this.itemStack.setAmount(i);
        return this;
    }

    public ItemStacker setType(Material material) {
        this.itemStack.setType(material);
        return this;
    }

    public List<LoreComponent> getComponentLore() {
        String[] lines;
        String name = this.getDisplayName();
        ArrayList<LoreComponent> components = new ArrayList<LoreComponent>();
        String tag = NBTWrapper.getTag("tag", this.serialise());
        String display = NBTWrapper.getTag("display", tag);
        String lore = NBTWrapper.getTag("Lore", display);
        if (lore == null) {
            return components;
        }
        lore = lore.substring(1, lore.length() - 1);
        for (String line : lines = lore.split("','")) {
            components.add(LoreGeneric.fromString(line.replace("'", "")));
        }
        return components;
    }

    public ItemStacker setComponentLore(List<LoreComponent> lines) {
        return this.setComponentLore(lines.toArray(new LoreComponent[0]));
    }

    public ItemStacker setComponentLore(LoreComponent ... lines) {
        String name = this.getDisplayName();
        ArrayList<String> components = new ArrayList<String>();
        for (LoreComponent line : lines) {
            components.add("'" + line.toString() + "'");
        }
        this.addNBT("{display:{Lore:[" + Strings.join(components, (String)",") + "]}}");
        return this;
    }

    public ItemStacker setLore(String json) {
        String name = this.getDisplayName();
        this.addNBT("{display:{Lore:" + json + "}}");
        return this;
    }

    public ItemStacker setLore(BaseComponent[] components) {
        String name = this.getDisplayName();
        this.addNBT("{display:{Lore:" + ComponentHandler.loreComponentify(ComponentHandler.stripComponents(components).replace("[JSON]", "")) + "}}");
        return this;
    }

    public ItemStacker setLore(List<String> lines) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta != null) {
            meta.setLore(lines);
            this.itemStack.setItemMeta(meta);
        }
        return this;
    }

    public ItemStacker setCustomModelData(int i) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta != null) {
            meta.setCustomModelData(Integer.valueOf(i));
            this.itemStack.setItemMeta(meta);
        }
        return this;
    }

    public ItemStacker setRawDisplay(String jsonName, String jsonLore) {
        this.addNBT("{display:{Name:'" + jsonName + "',Lore:'" + jsonLore + "'}}");
        return this;
    }

    public String getDisplayName() {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta != null) {
            return meta.getDisplayName();
        }
        return this.itemStack.getI18NDisplayName();
    }

    public ItemStacker setDisplayName(String displayName) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(displayName);
            this.itemStack.setItemMeta(meta);
        }
        return this;
    }

    public ItemStacker setLocalisedName(String localisedName) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta != null) {
            meta.setLocalizedName(localisedName);
            this.itemStack.setItemMeta(meta);
        }
        return this;
    }

    public ItemStacker setUnbreakable(boolean b) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta != null) {
            meta.setUnbreakable(b);
            this.itemStack.setItemMeta(meta);
        }
        return this;
    }

    public ItemStacker addItemFlags(ItemFlag ... itemFlags) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta != null) {
            meta.addItemFlags(itemFlags);
            this.itemStack.setItemMeta(meta);
        }
        return this;
    }

    public ItemStacker addEnchant(Enchantment enchantment, int i, boolean b) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta != null) {
            meta.addEnchant(enchantment, i, b);
            this.itemStack.setItemMeta(meta);
        }
        return this;
    }

    public Collection<AttributeModifier> getAttributeModifiers(Attribute attribute) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta != null) {
            return meta.getAttributeModifiers(attribute);
        }
        return null;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta != null) {
            return meta.getAttributeModifiers(slot);
        }
        return null;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers() {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta != null) {
            return meta.getAttributeModifiers();
        }
        return null;
    }

    public ItemStacker addAttributeModifier(Attribute attribute, AttributeModifier modifier) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta != null) {
            meta.addAttributeModifier(attribute, modifier);
            this.itemStack.setItemMeta(meta);
        }
        return this;
    }

    public ItemStacker addAttributeModifiers(Map<Attribute, AttributeModifier> modifierMap) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta != null) {
            modifierMap.keySet().forEach(attribute -> meta.addAttributeModifier(attribute, (AttributeModifier)modifierMap.get(attribute)));
            this.itemStack.setItemMeta(meta);
        }
        return this;
    }

    public ItemStacker removeAttributeModifier(EquipmentSlot slot) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta != null) {
            meta.removeAttributeModifier(slot);
            this.itemStack.setItemMeta(meta);
        }
        return this;
    }

    public ItemStacker removeAttributeModifier(Attribute attribute) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta != null) {
            meta.removeAttributeModifier(attribute);
            this.itemStack.setItemMeta(meta);
        }
        return this;
    }

    public ItemStacker removeAttributeModifier(Attribute attribute, AttributeModifier modifier) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta != null) {
            meta.removeAttributeModifier(attribute, modifier);
            this.itemStack.setItemMeta(meta);
        }
        return this;
    }

    public ItemStacker removeAttributeModifiers(List<Attribute> attributes) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta != null) {
            attributes.forEach(arg_0 -> ((ItemMeta)meta).removeAttributeModifier(arg_0));
            this.itemStack.setItemMeta(meta);
        }
        return this;
    }

    public ItemStacker removeItemFlags(ItemFlag ... itemFlags) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta != null) {
            meta.removeItemFlags(itemFlags);
            this.itemStack.setItemMeta(meta);
        }
        return this;
    }

    public ItemStacker removeEnchant(Enchantment enchantment) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta != null) {
            meta.removeEnchant(enchantment);
            this.itemStack.setItemMeta(meta);
        }
        return this;
    }

    public ItemStacker removeEnchants(Enchantment ... enchantments) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta != null) {
            for (Enchantment enchantment : enchantments) {
                meta.removeEnchant(enchantment);
            }
            this.itemStack.setItemMeta(meta);
        }
        return this;
    }

    public ItemStacker setInvisible(boolean b) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta != null && this.itemStack.getType() == Material.ARMOR_STAND) {
            ArmorStandMeta armorStandMeta = (ArmorStandMeta)meta;
            armorStandMeta.setInvisible(b);
            this.itemStack.setItemMeta((ItemMeta)armorStandMeta);
        }
        return this;
    }

    public ItemStacker setMarker(boolean b) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta != null && this.itemStack.getType() == Material.ARMOR_STAND) {
            ArmorStandMeta armorStandMeta = (ArmorStandMeta)meta;
            armorStandMeta.setMarker(b);
            this.itemStack.setItemMeta((ItemMeta)armorStandMeta);
        }
        return this;
    }

    public ItemStacker setNoBasePlate(boolean b) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta != null && this.itemStack.getType() == Material.ARMOR_STAND) {
            ArmorStandMeta armorStandMeta = (ArmorStandMeta)meta;
            armorStandMeta.setNoBasePlate(b);
            this.itemStack.setItemMeta((ItemMeta)armorStandMeta);
        }
        return this;
    }

    public ItemStacker setShowArms(boolean b) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta != null && this.itemStack.getType() == Material.ARMOR_STAND) {
            ArmorStandMeta armorStandMeta = (ArmorStandMeta)meta;
            armorStandMeta.setShowArms(b);
            this.itemStack.setItemMeta((ItemMeta)armorStandMeta);
        }
        return this;
    }

    public ItemStacker setSmall(boolean b) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta != null && this.itemStack.getType() == Material.ARMOR_STAND) {
            ArmorStandMeta armorStandMeta = (ArmorStandMeta)meta;
            armorStandMeta.setSmall(b);
            this.itemStack.setItemMeta((ItemMeta)armorStandMeta);
        }
        return this;
    }

    public ItemStacker addPattern(Pattern bannerPattern) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta != null) {
            BannerMeta bannerMeta = (BannerMeta)meta;
            bannerMeta.addPattern(bannerPattern);
            this.itemStack.setItemMeta((ItemMeta)bannerMeta);
        }
        return this;
    }

    public ItemStacker addPatterns(Pattern ... bannerPatterns) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta != null) {
            BannerMeta bannerMeta = (BannerMeta)meta;
            for (Pattern bannerPattern : bannerPatterns) {
                bannerMeta.addPattern(bannerPattern);
            }
            this.itemStack.setItemMeta((ItemMeta)bannerMeta);
        }
        return this;
    }

    public ItemStacker setPattern(int level, Pattern bannerPattern) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta != null) {
            BannerMeta bannerMeta = (BannerMeta)meta;
            bannerMeta.setPattern(level, bannerPattern);
            this.itemStack.setItemMeta((ItemMeta)bannerMeta);
        }
        return this;
    }

    public ItemStacker removePattern(int level) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta != null) {
            BannerMeta bannerMeta = (BannerMeta)meta;
            bannerMeta.removePattern(level);
            this.itemStack.setItemMeta((ItemMeta)bannerMeta);
        }
        return this;
    }

    public ItemStacker clearPatterns() {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta != null) {
            BannerMeta bannerMeta = (BannerMeta)meta;
            bannerMeta.setPatterns(new ArrayList());
            this.itemStack.setItemMeta((ItemMeta)bannerMeta);
        }
        return this;
    }

    public ItemStacker setPatterns(Pattern ... bannerPatterns) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta != null) {
            BannerMeta bannerMeta = (BannerMeta)meta;
            bannerMeta.setPatterns(Arrays.asList(bannerPatterns));
            this.itemStack.setItemMeta((ItemMeta)bannerMeta);
        }
        return this;
    }

    public ItemStacker addEffect(FireworkEffect effect) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta != null) {
            FireworkMeta fireworkMeta = (FireworkMeta)meta;
            fireworkMeta.addEffect(effect);
            this.itemStack.setItemMeta((ItemMeta)fireworkMeta);
        }
        return this;
    }

    public ItemStacker addEffects(FireworkEffect ... effects) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta != null) {
            FireworkMeta fireworkMeta = (FireworkMeta)meta;
            fireworkMeta.addEffects(effects);
            this.itemStack.setItemMeta((ItemMeta)fireworkMeta);
        }
        return this;
    }

    public ItemStacker addEffects(List<FireworkEffect> effects) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta != null) {
            FireworkMeta fireworkMeta = (FireworkMeta)meta;
            fireworkMeta.addEffects(effects);
            this.itemStack.setItemMeta((ItemMeta)fireworkMeta);
        }
        return this;
    }

    public ItemStacker setPower(int power) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta != null) {
            FireworkMeta fireworkMeta = (FireworkMeta)meta;
            fireworkMeta.setPower(power);
            this.itemStack.setItemMeta((ItemMeta)fireworkMeta);
        }
        return this;
    }

    public ItemStacker clearEffects() {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta != null) {
            FireworkMeta fireworkMeta = (FireworkMeta)meta;
            fireworkMeta.clearEffects();
            this.itemStack.setItemMeta((ItemMeta)fireworkMeta);
        }
        return this;
    }

    public ItemStacker removeEffect(int index) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta != null) {
            FireworkMeta fireworkMeta = (FireworkMeta)meta;
            fireworkMeta.removeEffect(index);
            this.itemStack.setItemMeta((ItemMeta)fireworkMeta);
        }
        return this;
    }

    public ItemStacker addRecipe(NamespacedKey recipe) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta != null) {
            KnowledgeBookMeta bookMeta = (KnowledgeBookMeta)meta;
            bookMeta.addRecipe(new NamespacedKey[]{recipe});
            this.itemStack.setItemMeta((ItemMeta)bookMeta);
        }
        return this;
    }

    public ItemStacker addRecipes(NamespacedKey ... recipes) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta != null) {
            KnowledgeBookMeta bookMeta = (KnowledgeBookMeta)meta;
            bookMeta.addRecipe(recipes);
            this.itemStack.setItemMeta((ItemMeta)bookMeta);
        }
        return this;
    }

    public ItemStacker setRecipes(NamespacedKey ... recipes) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta != null) {
            KnowledgeBookMeta bookMeta = (KnowledgeBookMeta)meta;
            bookMeta.setRecipes(Arrays.asList(recipes));
            this.itemStack.setItemMeta((ItemMeta)bookMeta);
        }
        return this;
    }

    public ItemStacker setRecipes(List<NamespacedKey> recipes) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta != null) {
            KnowledgeBookMeta bookMeta = (KnowledgeBookMeta)meta;
            bookMeta.setRecipes(recipes);
            this.itemStack.setItemMeta((ItemMeta)bookMeta);
        }
        return this;
    }

    public ItemStacker setArmorColor(Color color) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta != null) {
            LeatherArmorMeta armorMeta = (LeatherArmorMeta)meta;
            armorMeta.setColor(color);
            this.itemStack.setItemMeta((ItemMeta)armorMeta);
        }
        return this;
    }

    public ItemStacker setMapColor(Color color) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta != null) {
            MapMeta mapMeta = (MapMeta)meta;
            mapMeta.setColor(color);
            this.itemStack.setItemMeta((ItemMeta)mapMeta);
        }
        return this;
    }

    public ItemStacker setLocationName(String name) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta != null) {
            MapMeta mapMeta = (MapMeta)meta;
            mapMeta.setLocationName(name);
            this.itemStack.setItemMeta((ItemMeta)mapMeta);
        }
        return this;
    }

    public ItemStacker setScaling(boolean boo) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta != null) {
            MapMeta mapMeta = (MapMeta)meta;
            mapMeta.setScaling(boo);
            this.itemStack.setItemMeta((ItemMeta)mapMeta);
        }
        return this;
    }

    public ItemStacker setMapView(MapView view) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta != null) {
            MapMeta mapMeta = (MapMeta)meta;
            mapMeta.setMapView(view);
            this.itemStack.setItemMeta((ItemMeta)mapMeta);
        }
        return this;
    }

    @Deprecated
    public ItemStacker setMapId(int id) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta != null) {
            MapMeta mapMeta = (MapMeta)meta;
            mapMeta.setMapId(id);
            this.itemStack.setItemMeta((ItemMeta)mapMeta);
        }
        return this;
    }

    public ItemStacker setPotionColor(Color color) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta != null) {
            PotionMeta potionMeta = (PotionMeta)meta;
            potionMeta.setColor(color);
            this.itemStack.setItemMeta((ItemMeta)potionMeta);
        }
        return this;
    }

    public ItemStacker setBasePotionData(PotionData potionData) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta != null) {
            PotionMeta potionMeta = (PotionMeta)meta;
            potionMeta.setBasePotionData(potionData);
            this.itemStack.setItemMeta((ItemMeta)potionMeta);
        }
        return this;
    }

    public ItemStacker addCustomEffect(PotionEffect effect, boolean overwrite) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta != null) {
            PotionMeta potionMeta = (PotionMeta)meta;
            potionMeta.addCustomEffect(effect, overwrite);
            this.itemStack.setItemMeta((ItemMeta)potionMeta);
        }
        return this;
    }

    public ItemStacker addCustomEffects(PotionEffect ... effects) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta != null) {
            PotionMeta potionMeta = (PotionMeta)meta;
            for (PotionEffect effect : effects) {
                potionMeta.addCustomEffect(effect, true);
            }
            this.itemStack.setItemMeta((ItemMeta)potionMeta);
        }
        return this;
    }

    public ItemStacker removeCustomEffect(PotionEffectType type) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta != null) {
            PotionMeta potionMeta = (PotionMeta)meta;
            potionMeta.removeCustomEffect(type);
            this.itemStack.setItemMeta((ItemMeta)potionMeta);
        }
        return this;
    }

    public ItemStacker removeCustomEffects(PotionEffectType ... types) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta != null) {
            PotionMeta potionMeta = (PotionMeta)meta;
            for (PotionEffectType type : types) {
                potionMeta.removeCustomEffect(type);
            }
            this.itemStack.setItemMeta((ItemMeta)potionMeta);
        }
        return this;
    }

    public ItemStacker removeCustomEffect(PotionEffect effect) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta != null) {
            PotionMeta potionMeta = (PotionMeta)meta;
            potionMeta.removeCustomEffect(effect.getType());
            this.itemStack.setItemMeta((ItemMeta)potionMeta);
        }
        return this;
    }

    @Deprecated
    public ItemStacker setMainEffect(PotionEffectType type) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta != null) {
            PotionMeta potionMeta = (PotionMeta)meta;
            potionMeta.setMainEffect(type);
            this.itemStack.setItemMeta((ItemMeta)potionMeta);
        }
        return this;
    }

    public ItemStacker setPlayerProfile(PlayerProfile profile) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta != null) {
            SkullMeta skullMeta = (SkullMeta)meta;
            skullMeta.setPlayerProfile(profile);
            this.itemStack.setItemMeta((ItemMeta)skullMeta);
        }
        return this;
    }

    public ItemStacker setOwningPlayer(OfflinePlayer player) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta != null) {
            SkullMeta skullMeta = (SkullMeta)meta;
            skullMeta.setOwningPlayer(player);
            this.itemStack.setItemMeta((ItemMeta)skullMeta);
        }
        return this;
    }

    @Deprecated
    public ItemStacker setOwner(String owner) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta != null) {
            SkullMeta skullMeta = (SkullMeta)meta;
            skullMeta.setOwner(owner);
            this.itemStack.setItemMeta((ItemMeta)skullMeta);
        }
        return this;
    }

    @Deprecated
    public ItemStacker setSpawnedType(EntityType type) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta != null) {
            SpawnEggMeta eggMeta = (SpawnEggMeta)meta;
            eggMeta.setSpawnedType(type);
            this.itemStack.setItemMeta((ItemMeta)eggMeta);
        }
        return this;
    }

    public ItemStacker setBodyColor(DyeColor color) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta != null) {
            TropicalFishBucketMeta bucketMeta = (TropicalFishBucketMeta)meta;
            bucketMeta.setBodyColor(color);
            this.itemStack.setItemMeta((ItemMeta)bucketMeta);
        }
        return this;
    }

    public ItemStacker setPattern(TropicalFish.Pattern fishPattern) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta != null) {
            TropicalFishBucketMeta bucketMeta = (TropicalFishBucketMeta)meta;
            bucketMeta.setPattern(fishPattern);
            this.itemStack.setItemMeta((ItemMeta)bucketMeta);
        }
        return this;
    }

    public ItemStacker setPatternColor(DyeColor color) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta != null) {
            TropicalFishBucketMeta bucketMeta = (TropicalFishBucketMeta)meta;
            bucketMeta.setPatternColor(color);
            this.itemStack.setItemMeta((ItemMeta)bucketMeta);
        }
        return this;
    }

    public ItemStacker addStoredEnchant(Enchantment enchantment, int level, boolean force) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta != null) {
            EnchantmentStorageMeta storageMeta = (EnchantmentStorageMeta)meta;
            storageMeta.addStoredEnchant(enchantment, level, force);
            this.itemStack.setItemMeta((ItemMeta)storageMeta);
        }
        return this;
    }

    public ItemStacker addStoredEnchants(int level, boolean force, Enchantment ... enchantments) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta != null) {
            EnchantmentStorageMeta storageMeta = (EnchantmentStorageMeta)meta;
            for (Enchantment enchantment : enchantments) {
                storageMeta.addStoredEnchant(enchantment, level, force);
            }
            this.itemStack.setItemMeta((ItemMeta)storageMeta);
        }
        return this;
    }

    public ItemStacker removeStoredEnchant(Enchantment enchantment) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta != null) {
            EnchantmentStorageMeta storageMeta = (EnchantmentStorageMeta)meta;
            storageMeta.removeStoredEnchant(enchantment);
            this.itemStack.setItemMeta((ItemMeta)storageMeta);
        }
        return this;
    }

    public ItemStacker removeStoredEnchants(Enchantment ... enchantments) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta != null) {
            EnchantmentStorageMeta storageMeta = (EnchantmentStorageMeta)meta;
            for (Enchantment enchantment : enchantments) {
                storageMeta.removeStoredEnchant(enchantment);
            }
            this.itemStack.setItemMeta((ItemMeta)storageMeta);
        }
        return this;
    }

    public ItemStacker setBlockState(BlockState blockState) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta != null) {
            BlockStateMeta blockStateMeta = (BlockStateMeta)meta;
            blockStateMeta.setBlockState(blockState);
            this.itemStack.setItemMeta((ItemMeta)blockStateMeta);
        }
        return this;
    }

    public ItemStacker setBlockData(BlockData blockData) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta != null) {
            BlockDataMeta blockDataMeta = (BlockDataMeta)meta;
            blockDataMeta.setBlockData(blockData);
            this.itemStack.setItemMeta((ItemMeta)blockDataMeta);
        }
        return this;
    }

    public ItemStacker addChargedProjectile(ItemStack projectile) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta != null && this.itemStack.getType() == Material.CROSSBOW) {
            CrossbowMeta crossbowMeta = (CrossbowMeta)meta;
            crossbowMeta.addChargedProjectile(projectile);
            this.itemStack.setItemMeta((ItemMeta)crossbowMeta);
        }
        return this;
    }

    public ItemStacker setChargedProjectiles(ItemStack ... projectiles) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta != null && this.itemStack.getType() == Material.CROSSBOW) {
            CrossbowMeta crossbowMeta = (CrossbowMeta)meta;
            crossbowMeta.setChargedProjectiles(Arrays.asList(projectiles));
            this.itemStack.setItemMeta((ItemMeta)crossbowMeta);
        }
        return this;
    }

    public ItemStacker setPlaceableKeys(Namespaced ... keys) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta != null) {
            meta.setPlaceableKeys(Arrays.asList(keys));
            this.itemStack.setItemMeta(meta);
        }
        return this;
    }

    public ItemStacker setDestroyableKeys(Namespaced ... keys) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta != null) {
            meta.setDestroyableKeys(Arrays.asList(keys));
            this.itemStack.setItemMeta(meta);
        }
        return this;
    }

    public ItemStacker setGeneration(BookMeta.Generation generation) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta != null && (this.itemStack.getType() == Material.WRITABLE_BOOK || this.itemStack.getType() == Material.WRITTEN_BOOK)) {
            BookMeta bookMeta = (BookMeta)meta;
            bookMeta.setGeneration(generation);
            this.itemStack.setItemMeta((ItemMeta)bookMeta);
        }
        return this;
    }

    public ItemStacker setTitle(String title) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta != null && (this.itemStack.getType() == Material.WRITABLE_BOOK || this.itemStack.getType() == Material.WRITTEN_BOOK)) {
            BookMeta bookMeta = (BookMeta)meta;
            bookMeta.setTitle(title);
            this.itemStack.setItemMeta((ItemMeta)bookMeta);
        }
        return this;
    }

    public ItemStacker setAuthor(String author) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta != null && (this.itemStack.getType() == Material.WRITABLE_BOOK || this.itemStack.getType() == Material.WRITTEN_BOOK)) {
            BookMeta bookMeta = (BookMeta)meta;
            bookMeta.setAuthor(author);
            this.itemStack.setItemMeta((ItemMeta)bookMeta);
        }
        return this;
    }

    public ItemStacker setPage(int i, String page) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta != null && (this.itemStack.getType() == Material.WRITABLE_BOOK || this.itemStack.getType() == Material.WRITTEN_BOOK)) {
            BookMeta bookMeta = (BookMeta)meta;
            bookMeta.setPage(i, page);
            this.itemStack.setItemMeta((ItemMeta)bookMeta);
        }
        return this;
    }

    public ItemStacker addPage(String ... page) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta != null && (this.itemStack.getType() == Material.WRITABLE_BOOK || this.itemStack.getType() == Material.WRITTEN_BOOK)) {
            BookMeta bookMeta = (BookMeta)meta;
            bookMeta.addPage(page);
            this.itemStack.setItemMeta((ItemMeta)bookMeta);
        }
        return this;
    }

    public ItemStacker addPages(String ... pages) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta != null && (this.itemStack.getType() == Material.WRITABLE_BOOK || this.itemStack.getType() == Material.WRITTEN_BOOK)) {
            BookMeta bookMeta = (BookMeta)meta;
            bookMeta.addPage(pages);
            this.itemStack.setItemMeta((ItemMeta)bookMeta);
        }
        return this;
    }

    public ItemStacker setPages(String ... pages) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta != null && (this.itemStack.getType() == Material.WRITABLE_BOOK || this.itemStack.getType() == Material.WRITTEN_BOOK)) {
            BookMeta bookMeta = (BookMeta)meta;
            bookMeta.setPages(pages);
            this.itemStack.setItemMeta((ItemMeta)bookMeta);
        }
        return this;
    }

    public ItemStacker setPage(int i, BaseComponent ... page) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta != null && (this.itemStack.getType() == Material.WRITABLE_BOOK || this.itemStack.getType() == Material.WRITTEN_BOOK)) {
            BookMeta bookMeta = (BookMeta)meta;
            bookMeta.spigot().setPage(i, page);
            this.itemStack.setItemMeta((ItemMeta)bookMeta);
        }
        return this;
    }

    public ItemStacker setPages(int i, BaseComponent ... pages) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta != null && (this.itemStack.getType() == Material.WRITABLE_BOOK || this.itemStack.getType() == Material.WRITTEN_BOOK)) {
            BookMeta bookMeta = (BookMeta)meta;
            bookMeta.spigot().setPage(i, pages);
            this.itemStack.setItemMeta((ItemMeta)bookMeta);
        }
        return this;
    }

    public ItemStacker setPages(BaseComponent[] ... pages) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta != null && (this.itemStack.getType() == Material.WRITABLE_BOOK || this.itemStack.getType() == Material.WRITTEN_BOOK)) {
            BookMeta bookMeta = (BookMeta)meta;
            bookMeta.spigot().setPages(pages);
            this.itemStack.setItemMeta((ItemMeta)bookMeta);
        }
        return this;
    }

    public ItemStacker setPages(List<BaseComponent[]> pages) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta != null && (this.itemStack.getType() == Material.WRITABLE_BOOK || this.itemStack.getType() == Material.WRITTEN_BOOK)) {
            BookMeta bookMeta = (BookMeta)meta;
            bookMeta.spigot().setPages(pages);
            this.itemStack.setItemMeta((ItemMeta)bookMeta);
        }
        return this;
    }

    public ItemStacker addPage(BaseComponent[] ... page) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta != null && (this.itemStack.getType() == Material.WRITABLE_BOOK || this.itemStack.getType() == Material.WRITTEN_BOOK)) {
            BookMeta bookMeta = (BookMeta)meta;
            bookMeta.spigot().addPage(page);
            this.itemStack.setItemMeta((ItemMeta)bookMeta);
        }
        return this;
    }

    public ItemStacker addPages(BaseComponent[] ... pages) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta != null && (this.itemStack.getType() == Material.WRITABLE_BOOK || this.itemStack.getType() == Material.WRITTEN_BOOK)) {
            BookMeta bookMeta = (BookMeta)meta;
            bookMeta.spigot().addPage(pages);
            this.itemStack.setItemMeta((ItemMeta)bookMeta);
        }
        return this;
    }

    public ItemStacker setDurability(int i) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta instanceof Damageable) {
            Damageable damageable = (Damageable)meta;
            damageable.setDamage(i);
            this.itemStack.setItemMeta((ItemMeta)damageable);
        }
        return this;
    }

    public ItemStacker setDurability(double d) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta instanceof Damageable) {
            Damageable damageable = (Damageable)meta;
            short max = this.itemStack.getType().getMaxDurability();
            damageable.setDamage((int)Math.round((double)max * d));
            this.itemStack.setItemMeta((ItemMeta)damageable);
        }
        return this;
    }

    @Deprecated
    public ItemStacker setDurability(short s) {
        this.itemStack.setDurability(s);
        return this;
    }

    public ItemStacker addEnchantment(Enchantment enchantment, int level) {
        this.itemStack.addEnchantment(enchantment, level);
        return this;
    }

    public ItemStacker addEnchantments(Map<Enchantment, Integer> enchantments) {
        this.itemStack.addEnchantments(enchantments);
        return this;
    }

    public ItemStacker addUnsafeEnchantment(Enchantment enchantment, int level) {
        this.itemStack.addUnsafeEnchantment(enchantment, level);
        return this;
    }

    public ItemStacker addUnsafeEnchantments(Map<Enchantment, Integer> enchantments) {
        this.itemStack.addUnsafeEnchantments(enchantments);
        return this;
    }

    public boolean getBoolean(String tag) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta != null) {
            NamespacedKey key = Bedrock.getNamespacedKey(tag);
            int i = (Integer)meta.getPersistentDataContainer().getOrDefault(key, PersistentDataType.INTEGER, (Object)0);
            return i == 1;
        }
        return false;
    }

    public String getString(String tag) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta != null) {
            NamespacedKey key = Bedrock.getNamespacedKey(tag);
            return (String)meta.getPersistentDataContainer().get(key, PersistentDataType.STRING);
        }
        return null;
    }

    public Integer getInteger(String tag) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta != null) {
            NamespacedKey key = Bedrock.getNamespacedKey(tag);
            return (Integer)meta.getPersistentDataContainer().get(key, PersistentDataType.INTEGER);
        }
        return null;
    }

    public int getInt(String tag) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta != null) {
            NamespacedKey key = Bedrock.getNamespacedKey(tag);
            return (Integer)meta.getPersistentDataContainer().getOrDefault(key, PersistentDataType.INTEGER, (Object)0);
        }
        return 0;
    }

    public long getLong(String tag) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta != null) {
            NamespacedKey key = Bedrock.getNamespacedKey(tag);
            return (Long)meta.getPersistentDataContainer().getOrDefault(key, PersistentDataType.LONG, (Object)0L);
        }
        return 0L;
    }

    public double getDouble(String tag) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta != null) {
            NamespacedKey key = Bedrock.getNamespacedKey(tag);
            return (Double)meta.getPersistentDataContainer().getOrDefault(key, PersistentDataType.DOUBLE, (Object)0.0);
        }
        return 0.0;
    }

    public ItemStacker setInt(String tag, int value) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta != null) {
            NamespacedKey key = Bedrock.getNamespacedKey(tag);
            meta.getPersistentDataContainer().set(key, PersistentDataType.INTEGER, (Object)value);
            this.itemStack.setItemMeta(meta);
        }
        return this;
    }

    public ItemStacker setPersistent(String tag, String value) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta != null) {
            NamespacedKey key = Bedrock.getNamespacedKey(tag);
            meta.getPersistentDataContainer().set(key, PersistentDataType.STRING, (Object)value);
            this.itemStack.setItemMeta(meta);
        }
        return this;
    }

    public ItemStacker setPersistent(String tag, boolean value) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta != null) {
            NamespacedKey key = Bedrock.getNamespacedKey(tag);
            int i = 0;
            if (value) {
                i = 1;
            }
            meta.getPersistentDataContainer().set(key, PersistentDataType.INTEGER, (Object)i);
            this.itemStack.setItemMeta(meta);
        }
        return this;
    }

    public ItemStacker setPersistent(String tag, int value) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta != null) {
            NamespacedKey key = Bedrock.getNamespacedKey(tag);
            meta.getPersistentDataContainer().set(key, PersistentDataType.INTEGER, (Object)value);
            this.itemStack.setItemMeta(meta);
        }
        return this;
    }

    public ItemStacker setPersistent(String tag, double value) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta != null) {
            NamespacedKey key = Bedrock.getNamespacedKey(tag);
            meta.getPersistentDataContainer().set(key, PersistentDataType.DOUBLE, (Object)value);
            this.itemStack.setItemMeta(meta);
        }
        return this;
    }

    public ItemStacker setPersistent(String tag, float value) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta != null) {
            NamespacedKey key = Bedrock.getNamespacedKey(tag);
            meta.getPersistentDataContainer().set(key, PersistentDataType.FLOAT, (Object)Float.valueOf(value));
            this.itemStack.setItemMeta(meta);
        }
        return this;
    }

    public ItemStacker setPersistent(String tag, byte value) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta != null) {
            NamespacedKey key = Bedrock.getNamespacedKey(tag);
            meta.getPersistentDataContainer().set(key, PersistentDataType.BYTE, (Object)value);
            this.itemStack.setItemMeta(meta);
        }
        return this;
    }

    public ItemStacker setPersistent(String tag, long value) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta != null) {
            NamespacedKey key = Bedrock.getNamespacedKey(tag);
            meta.getPersistentDataContainer().set(key, PersistentDataType.LONG, (Object)value);
            this.itemStack.setItemMeta(meta);
        }
        return this;
    }

    public ItemStacker setPersistent(String tag, short value) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta != null) {
            NamespacedKey key = Bedrock.getNamespacedKey(tag);
            meta.getPersistentDataContainer().set(key, PersistentDataType.SHORT, (Object)value);
            this.itemStack.setItemMeta(meta);
        }
        return this;
    }

    public ItemStacker setPersistent(String tag, PersistentDataContainer value) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta != null) {
            NamespacedKey key = Bedrock.getNamespacedKey(tag);
            meta.getPersistentDataContainer().set(key, PersistentDataType.TAG_CONTAINER, (Object)value);
            this.itemStack.setItemMeta(meta);
        }
        return this;
    }

    public ItemStacker setPersistent(String tag, byte[] value) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta != null) {
            NamespacedKey key = Bedrock.getNamespacedKey(tag);
            meta.getPersistentDataContainer().set(key, PersistentDataType.BYTE_ARRAY, (Object)value);
            this.itemStack.setItemMeta(meta);
        }
        return this;
    }

    public ItemStacker setPersistent(String tag, int[] value) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta != null) {
            NamespacedKey key = Bedrock.getNamespacedKey(tag);
            meta.getPersistentDataContainer().set(key, PersistentDataType.INTEGER_ARRAY, (Object)value);
            this.itemStack.setItemMeta(meta);
        }
        return this;
    }

    public ItemStacker setPersistent(String tag, long[] value) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta != null) {
            NamespacedKey key = Bedrock.getNamespacedKey(tag);
            meta.getPersistentDataContainer().set(key, PersistentDataType.LONG_ARRAY, (Object)value);
            this.itemStack.setItemMeta(meta);
        }
        return this;
    }

    public ItemStacker addNBT(String nbt) {
        new NBTWrapperItem(this.itemStack).addNBT(nbt).clone(this.itemStack);
        return this;
    }

    public ItemStacker setNBTTag(String tag, Object value) {
        new NBTWrapperItem(this.itemStack).setValue(tag, value).clone(this.itemStack);
        return this;
    }

    public NBTWrapperItem getNBTWrapper() {
        return new NBTWrapperItem(this.itemStack);
    }

    @Deprecated
    public ItemStacker setData(MaterialData materialData) {
        this.itemStack.setData(materialData);
        return this;
    }

    public ItemMeta getItemMeta() {
        return this.itemStack.getItemMeta();
    }

    public ItemStacker setItemMeta(ItemMeta meta) {
        this.itemStack.setItemMeta(meta);
        return this;
    }

    public String serialise() {
        return new NBTWrapperItem(this.getItemStack()).toString();
    }
}

