/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.transk.syntax.blind.expression;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.moderocky.transk.api.TransAPI;
import java.util.ArrayList;
import javax.annotation.Nullable;
import org.bukkit.event.Event;

@Name(value="Converted Translation Key")
@Description(value={"Creates a translation entry of the style key.here[inputs='input','input'].\n  - You provide it with a list of strings. Element 1 is the key, the rest will be added as inputs."})
@Examples(value={"set {_x} to player's tool with translated lore \"menu.singleplayer\" and \"custom.key\"", "set {_x} to player's tool with translated lore \"menu.singleplayer[inputs='\u00a7hi, I'm an input!','hello there!','General Kenobi!']\"", "set {_x} to player's tool with translated lore \"another.custom.key\" and \"\u00a7cI will look like this.\" #if there's no matching lang entry, the client will see your translation string."})
@Since(value="0.1.2")
public class ConvertedKey
extends SimpleExpression<String> {
    private Expression<String> stringExpression;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.stringExpression = exprs[0];
        return true;
    }

    protected String[] get(Event event) {
        ArrayList<String> strings = new ArrayList<String>();
        strings.add(TransAPI.convertStrings((String[])this.stringExpression.getArray(event)));
        return strings.toArray(new String[0]);
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    public String toString(@Nullable Event event, boolean debug) {
        String string = "<none>";
        if (this.stringExpression != null) {
            string = this.stringExpression.toString(event, debug);
        }
        return "converted translation key " + string;
    }

    static {
        Skript.registerExpression(ConvertedKey.class, String.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[the] converted [translation] key %strings%"});
    }
}

