/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.transk.syntax.basic.effect;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.moderocky.misc.AccessiblePlayer;
import javax.annotation.Nullable;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

@Name(value="Translated Action Bars")
@Description(value={"Sends a translated action bar message to players.\n  - This message can be a default one from the Minecraft lang file.\n  - It can also be a custom one included via mod or resource pack.\n  - Inside the language files, you can use \u00a7 to colour messages."})
@Examples(value={"send translated action bar \"translation.test.none\" to player #Will send 'Hello, world!' in the player's locale.", "send translated action bar \"custom.message.specified.in.lang_file\" to all players #Will send whatever this corresponds to in a custom language file."})
@Since(value="0.1.8")
public class SendTranslatedActionBar
extends Effect {
    private Expression<String> stringExpression;
    private Expression<Player> playerExpression;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.stringExpression = exprs[0];
        this.playerExpression = exprs[1];
        return true;
    }

    protected void execute(Event event) {
        if (this.playerExpression == null || this.stringExpression == null) {
            return;
        }
        for (String string : (String[])this.stringExpression.getArray(event)) {
            for (Player player : (Player[])this.playerExpression.getArray(event)) {
                new AccessiblePlayer(player).sendActionBar(string);
            }
        }
    }

    public String toString(@Nullable Event event, boolean debug) {
        String string = "<none>";
        String player = "<none>";
        if (this.stringExpression != null) {
            string = this.stringExpression.toString(event, debug);
        }
        if (this.playerExpression != null) {
            player = this.playerExpression.toString(event, debug);
        }
        return "send translated action bars " + string + " to " + player;
    }

    static {
        Skript.registerEffect(SendTranslatedActionBar.class, (String[])new String[]{"send translated action[ ]bar[s] %strings% to %players%"});
    }
}

