/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.transk.mask.template;

import com.moderocky.transk.mask.annotation.API;
import com.moderocky.transk.mask.api.CaughtReflective;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

@API
public interface Reflective {
    public static CaughtReflective<Object> setField(@NotNull Object object, String fieldName, Object value) {
        try {
            Field field = object.getClass().getField(fieldName);
            field.setAccessible(true);
            field.set(object, value);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            return new CaughtReflective<Object>(false, e, null);
        }
        return new CaughtReflective<Object>(true, null, object);
    }

    public static CaughtReflective<Object> getField(@NotNull Object object, String fieldName) {
        try {
            Field field = object.getClass().getField(fieldName);
            field.setAccessible(true);
            field.get(object);
            return new CaughtReflective<Object>(true, null, field.get(object));
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            return new CaughtReflective<Object>(false, e, null);
        }
    }

    public static CaughtReflective<Object> getMethod(@NotNull Object object, String methodName) {
        for (Method declaredMethod : object.getClass().getDeclaredMethods()) {
            if (!declaredMethod.getName().equalsIgnoreCase(methodName)) continue;
            return new CaughtReflective<Object>(true, null, declaredMethod);
        }
        return new CaughtReflective<Object>(false, new NullPointerException(), null);
    }

    public static CaughtReflective<Object> getMethod(@NotNull Object object, String methodName, Class<?> ... params) {
        try {
            return new CaughtReflective<Object>(true, null, object.getClass().getDeclaredMethod(methodName, params));
        }
        catch (NoSuchMethodException e) {
            return new CaughtReflective<Object>(false, e, null);
        }
    }

    public static CaughtReflective<Object> getMethod(@NotNull Class<?> clarse, String methodName) {
        for (Method declaredMethod : clarse.getDeclaredMethods()) {
            if (!declaredMethod.getName().equalsIgnoreCase(methodName)) continue;
            return new CaughtReflective<Object>(true, null, declaredMethod);
        }
        return new CaughtReflective<Object>(false, new NullPointerException(), null);
    }

    public static CaughtReflective<Object> getMethod(@NotNull Class<?> clarse, String methodName, Class<?> ... params) {
        try {
            return new CaughtReflective<Object>(true, null, clarse.getDeclaredMethod(methodName, params));
        }
        catch (NoSuchMethodException e) {
            return new CaughtReflective<Object>(false, e, null);
        }
    }

    public static CaughtReflective<Object> callMethod(@NotNull Object object, String methodName, Object ... params) {
        ArrayList paramClasses = new ArrayList();
        for (Object parameter : params) {
            paramClasses.add(parameter.getClass());
        }
        Method method = (Method)Reflective.getMethod(object, methodName, paramClasses.toArray(new Class[0])).get();
        if (method == null) {
            return new CaughtReflective<Object>(false, new NullPointerException(), null);
        }
        method.setAccessible(true);
        try {
            return new CaughtReflective<Object>(true, null, method.invoke(object, params));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            return new CaughtReflective<Object>(false, e, null);
        }
    }

    public static CaughtReflective<Object> callMethod(@NotNull Class<?> clarse, String methodName, Object ... params) {
        ArrayList paramClasses = new ArrayList();
        for (Object parameter : params) {
            paramClasses.add(parameter.getClass());
        }
        Method method = (Method)Reflective.getMethod(clarse, methodName, paramClasses.toArray(new Class[0])).get();
        if (method == null) {
            return new CaughtReflective<Object>(false, new NullPointerException(), null);
        }
        method.setAccessible(true);
        try {
            return new CaughtReflective<Object>(true, null, method.invoke(clarse, params));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            return new CaughtReflective<Object>(false, e, null);
        }
    }

    public static <Z> CaughtReflective<Object> createInstance(@NotNull Class<Z> clarse) {
        try {
            Z inst = clarse.newInstance();
            return new CaughtReflective<Object>(true, null, inst);
        }
        catch (IllegalAccessException | InstantiationException e) {
            return new CaughtReflective<Object>(false, e, null);
        }
    }

    public static <Z> CaughtReflective<Object> createInstance(@NotNull Class<Z> clarse, Object ... parameters) {
        try {
            ArrayList paramClasses = new ArrayList();
            for (Object parameter : parameters) {
                paramClasses.add(parameter.getClass());
            }
            Constructor<Z> constructor = clarse.getDeclaredConstructor(paramClasses.toArray(new Class[0]));
            if (constructor == null) {
                return new CaughtReflective<Object>(false, new NullPointerException(), null);
            }
            Z inst = constructor.newInstance(parameters);
            return new CaughtReflective<Object>(true, null, inst);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            return new CaughtReflective<Object>(false, e, null);
        }
    }

    public static CaughtReflective<Object> getConstructor(@NotNull Class<?> clarse, Class<?> ... parameters) {
        try {
            clarse.getDeclaredConstructor(parameters);
            return new CaughtReflective<Object>(true, null, clarse.getDeclaredConstructor(parameters));
        }
        catch (NoSuchMethodException e) {
            return new CaughtReflective<Object>(false, e, null);
        }
    }

    public static <Z> CaughtReflective<Object> callConstructor(@NotNull Constructor<Z> constructor, Object ... parameters) {
        try {
            Z inst = constructor.newInstance(parameters);
            return new CaughtReflective<Object>(true, null, inst);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            return new CaughtReflective<Object>(false, e, null);
        }
    }

    public static List<Field> getStaticFields(Class<?> clarse) {
        Field[] declaredFields = clarse.getDeclaredFields();
        ArrayList<Field> staticFields = new ArrayList<Field>();
        for (Field field : declaredFields) {
            if (!Modifier.isStatic(field.getModifiers())) continue;
            staticFields.add(field);
        }
        return staticFields;
    }

    public static List<Field> getInstanceFields(Class<?> clarse) {
        Field[] declaredFields = clarse.getDeclaredFields();
        ArrayList<Field> instanceFields = new ArrayList<Field>();
        for (Field field : declaredFields) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            instanceFields.add(field);
        }
        return instanceFields;
    }

    public static List<Field> getFinalFields(Class<?> clarse) {
        Field[] declaredFields = clarse.getDeclaredFields();
        ArrayList<Field> finalFields = new ArrayList<Field>();
        for (Field field : declaredFields) {
            if (!Modifier.isFinal(field.getModifiers())) continue;
            finalFields.add(field);
        }
        return finalFields;
    }

    default public CaughtReflective<Reflective> setField(String fieldName, boolean value) {
        try {
            Field field = this.getClass().getField(fieldName);
            field.setAccessible(true);
            field.setBoolean(this, value);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            return new CaughtReflective<Object>(false, e, null);
        }
        return new CaughtReflective<Reflective>(true, null, this);
    }

    default public CaughtReflective<Reflective> setField(String fieldName, int value) {
        try {
            Field field = this.getClass().getField(fieldName);
            field.setAccessible(true);
            field.setInt(this, value);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            return new CaughtReflective<Object>(false, e, null);
        }
        return new CaughtReflective<Reflective>(true, null, this);
    }

    default public CaughtReflective<Reflective> setField(String fieldName, byte value) {
        try {
            Field field = this.getClass().getField(fieldName);
            field.setAccessible(true);
            field.setByte(this, value);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            return new CaughtReflective<Object>(false, e, null);
        }
        return new CaughtReflective<Reflective>(true, null, this);
    }

    default public CaughtReflective<Reflective> setField(String fieldName, long value) {
        try {
            Field field = this.getClass().getField(fieldName);
            field.setAccessible(true);
            field.setLong(this, value);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            return new CaughtReflective<Object>(false, e, null);
        }
        return new CaughtReflective<Reflective>(true, null, this);
    }

    default public CaughtReflective<Reflective> setField(String fieldName, double value) {
        try {
            Field field = this.getClass().getField(fieldName);
            field.setAccessible(true);
            field.setDouble(this, value);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            return new CaughtReflective<Object>(false, e, null);
        }
        return new CaughtReflective<Reflective>(true, null, this);
    }

    default public CaughtReflective<Reflective> setField(String fieldName, Object value) {
        try {
            Field field = this.getClass().getField(fieldName);
            field.setAccessible(true);
            field.set(this, value);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            return new CaughtReflective<Object>(false, e, null);
        }
        return new CaughtReflective<Reflective>(true, null, this);
    }

    default public CaughtReflective<Object> getField(String fieldName) {
        try {
            Field field = this.getClass().getField(fieldName);
            field.setAccessible(true);
            field.get(this);
            return new CaughtReflective<Object>(true, null, field.get(this));
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            return new CaughtReflective<Object>(false, e, null);
        }
    }

    default public boolean isFinal(int modifiers) {
        return Modifier.isFinal(modifiers);
    }

    default public boolean isStatic(int modifiers) {
        return Modifier.isStatic(modifiers);
    }

    default public boolean isInstance(int modifiers) {
        return !Modifier.isStatic(modifiers);
    }

    default public boolean isAbstract(int modifiers) {
        return Modifier.isAbstract(modifiers);
    }

    default public boolean isPublic(int modifiers) {
        return Modifier.isPublic(modifiers);
    }

    default public boolean isProtected(int modifiers) {
        return Modifier.isProtected(modifiers);
    }

    default public boolean isPrivate(int modifiers) {
        return Modifier.isPrivate(modifiers);
    }

    default public boolean isInterface(int modifiers) {
        return Modifier.isInterface(modifiers);
    }

    default public boolean isNative(int modifiers) {
        return Modifier.isNative(modifiers);
    }

    default public boolean isStrict(int modifiers) {
        return Modifier.isStrict(modifiers);
    }

    default public boolean isSynchronized(int modifiers) {
        return Modifier.isSynchronized(modifiers);
    }

    default public boolean isTransient(int modifiers) {
        return Modifier.isTransient(modifiers);
    }

    default public boolean isVolatile(int modifiers) {
        return Modifier.isVolatile(modifiers);
    }
}

