/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.transk.mask.template;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptAddon;
import com.moderocky.transk.mask.Mask;
import com.moderocky.transk.mask.annotation.API;
import com.moderocky.transk.mask.annotation.Internal;
import com.moderocky.transk.mask.annotation.Unsafe;
import com.moderocky.transk.mask.bstats.bukkit.Metrics;
import com.moderocky.transk.mask.template.CompleteCommand;
import com.moderocky.transk.mask.template.CompleteListener;
import com.moderocky.transk.mask.template.CompleteRecipe;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.inventory.Recipe;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.plugin.java.JavaPlugin;

@API
public abstract class Plugin
extends JavaPlugin {
    private static Plugin instance;
    private SkriptAddon addon;
    private Metrics metrics = new Metrics((org.bukkit.plugin.Plugin)this, 6786);

    @API
    public static Plugin getInstance() {
        return instance;
    }

    @Unsafe
    @Internal
    protected void setInstance(@Nullable Plugin plugin) {
        instance = plugin;
    }

    @API
    public static <Z extends Event> void callEvent(Z event) {
        Bukkit.getScheduler().runTask((org.bukkit.plugin.Plugin)Plugin.getInstance(), () -> Bukkit.getServer().getPluginManager().callEvent(event));
    }

    @API
    public static FixedMetadataValue getMetaValue(Object object) {
        return new FixedMetadataValue((org.bukkit.plugin.Plugin)Plugin.getInstance(), object);
    }

    @API
    public static NamespacedKey getNamespacedKey(String string) {
        return new NamespacedKey((org.bukkit.plugin.Plugin)Plugin.getInstance(), string);
    }

    public static boolean isPaper() {
        try {
            Class.forName("co.aikar.timings.Timing");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    @API
    public String getVersion() {
        return this.getDescription().getVersion();
    }

    @API
    public String getAPIVersion() {
        return this.getDescription().getAPIVersion();
    }

    @API
    public String getPluginDescription() {
        return this.getDescription().getDescription();
    }

    @API
    public String getFullName() {
        return this.getDescription().getFullName();
    }

    @API
    public String getPrefix() {
        return this.getDescription().getPrefix();
    }

    @API
    public boolean areDependenciesMet() {
        if (this.getDescription().getSoftDepend().size() > 0) {
            for (String string : this.getDescription().getSoftDepend()) {
                if (Bukkit.getPluginManager().getPlugin(string) != null) continue;
                return false;
            }
        }
        return true;
    }

    @API
    public String getCraftVersion() {
        return Bukkit.getServer().getClass().getPackage().getName().split("\\.")[3];
    }

    @API
    public void disablePlugin() {
        Bukkit.getPluginManager().disablePlugin((org.bukkit.plugin.Plugin)this);
    }

    @Internal
    public void onEnable() {
        this.setInstance(this);
        this.registerMask();
        this.registerAddon();
        this.startup();
        this.registerManagers();
        this.registerProtocol();
        this.registerListeners();
        this.registerRecipes();
        this.registerEvents();
        this.registerSyntax();
        this.registerCommands();
    }

    @Internal
    public void onDisable() {
        this.disable();
        this.setInstance(null);
        this.unregisterMask();
    }

    @API
    public abstract void startup();

    @API
    public abstract void disable();

    @API
    public SkriptAddon getAddon() {
        return this.addon;
    }

    @Internal
    private void unregisterMask() {
        Mask.setMask(null, null);
    }

    @Internal
    private void registerMask() {
        Mask.setMask(new Mask(), this);
        Mask.getMask().updateAddonConfig();
    }

    @Internal
    private void registerAddon() {
        this.addon = Mask.getMask().hasSkript() ? Skript.registerAddon((JavaPlugin)this) : null;
    }

    @API
    public String getConfigPath() {
        return this.getDataFolder().toString();
    }

    @API
    public void resetConfig() {
    }

    @API
    protected void register(CompleteCommand ... commands) {
        if (commands == null) {
            return;
        }
        for (CompleteCommand completeCommand : commands) {
            PluginCommand pluginCommand = this.getCommand(completeCommand.getCommand());
            if (pluginCommand == null) {
                return;
            }
            pluginCommand.setExecutor((CommandExecutor)completeCommand);
        }
    }

    @API
    protected void register(CompleteListener ... listeners) {
        if (listeners == null) {
            return;
        }
        for (CompleteListener completeListener : listeners) {
            Bukkit.getServer().getPluginManager().registerEvents((Listener)completeListener, (org.bukkit.plugin.Plugin)Plugin.getInstance());
        }
    }

    @API
    protected void register(CompleteRecipe ... recipes) {
        if (recipes == null) {
            return;
        }
        for (CompleteRecipe completeRecipe : recipes) {
            if (!completeRecipe.isEnabled()) continue;
            Bukkit.addRecipe((Recipe)completeRecipe.getRecipe());
        }
    }

    @API
    protected void registerRecipes() {
    }

    @API
    protected void registerListeners() {
    }

    @API
    protected void registerCommands() {
    }

    @API
    protected void registerManagers() {
    }

    @API
    protected void registerProtocol() {
    }

    @API
    protected void registerSyntax() {
    }

    @API
    protected void registerEvents() {
    }
}

