/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.transk.mask.template;

import com.moderocky.transk.mask.annotation.API;
import com.moderocky.transk.mask.annotation.Internal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.util.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@API
public interface CompleteCommand
extends CommandExecutor,
TabCompleter {
    @Internal
    @NotNull
    public String getCommand();

    @Nullable
    public List<String> getCompletions(int var1);

    @NotNull
    default public BaseComponent[] getHelpMessage(int i, @NotNull String[] args) {
        PluginCommand command = Bukkit.getPluginCommand((String)this.getCommand());
        if (command == null) {
            return new ComponentBuilder("No instructions found.").color(ChatColor.GRAY).create();
        }
        return new ComponentBuilder("Usage: ").color(ChatColor.WHITE).append(command.getUsage()).color(ChatColor.GRAY).create();
    }

    @Nullable
    default public List<String> getCompletions(int i, @NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        return this.getCompletions(i);
    }

    @Nullable
    default public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        List<String> strings = this.getCompletions(args.length, sender, command, alias, args);
        if (strings == null) {
            return null;
        }
        ArrayList<String> completions = new ArrayList<String>();
        StringUtil.copyPartialMatches((String)args[args.length - 1], strings, completions);
        Collections.sort(completions);
        return completions;
    }
}

