/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.transk.mask.api;

import com.moderocky.transk.mask.annotation.API;
import com.moderocky.transk.mask.annotation.Debug;
import com.moderocky.transk.mask.template.Reflective;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;

public class Debugger
implements Reflective {
    @API
    public String[] getDebug(Class<?> clarse) {
        String modifiers;
        Debug debug;
        ArrayList<String> strings = new ArrayList<String>();
        boolean debugAll = clarse.isAnnotationPresent(Debug.class) && clarse.getAnnotation(Debug.class).value();
        strings.add("Class: " + clarse.getCanonicalName() + " (" + clarse.getPackage() + ")");
        strings.add("  Fields:");
        for (Field field : clarse.getDeclaredFields()) {
            if (!Modifier.isStatic(field.getModifiers())) continue;
            debug = field.getAnnotation(Debug.class);
            if (!debugAll && (debug == null || !debug.value())) continue;
            modifiers = "";
            if (this.isPublic(field.getModifiers())) {
                modifiers = modifiers + "public ";
            } else if (this.isProtected(field.getModifiers())) {
                modifiers = modifiers + "protected ";
            } else if (this.isPrivate(field.getModifiers())) {
                modifiers = modifiers + "private ";
            }
            if (this.isFinal(field.getModifiers())) {
                modifiers = modifiers + "final ";
            }
            if (this.isStatic(field.getModifiers())) {
                modifiers = modifiers + "static ";
            }
            if (this.isVolatile(field.getModifiers())) {
                modifiers = modifiers + "volatile ";
            }
            if (this.isNative(field.getModifiers())) {
                modifiers = modifiers + "native ";
            }
            try {
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                strings.add("    " + modifiers + field.getType().getName() + " " + field.getName() + " = " + field.get(clarse));
            }
            catch (IllegalAccessException e) {
                strings.add("    " + modifiers + field.getType().getName() + " " + field.getName() + " = Unknown");
            }
        }
        strings.add("  Constructors:");
        for (AccessibleObject accessibleObject : clarse.getDeclaredConstructors()) {
            debug = ((Constructor)accessibleObject).getAnnotation(Debug.class);
            if (!debugAll && (debug == null || !debug.value())) continue;
            modifiers = "";
            if (this.isPublic(((Constructor)accessibleObject).getModifiers())) {
                modifiers = modifiers + "public ";
            } else if (this.isProtected(((Constructor)accessibleObject).getModifiers())) {
                modifiers = modifiers + "protected ";
            } else if (this.isPrivate(((Constructor)accessibleObject).getModifiers())) {
                modifiers = modifiers + "private ";
            }
            if (this.isFinal(((Constructor)accessibleObject).getModifiers())) {
                modifiers = modifiers + "final ";
            }
            if (this.isStatic(((Constructor)accessibleObject).getModifiers())) {
                modifiers = modifiers + "static ";
            }
            if (this.isVolatile(((Constructor)accessibleObject).getModifiers())) {
                modifiers = modifiers + "volatile ";
            }
            if (this.isNative(((Constructor)accessibleObject).getModifiers())) {
                modifiers = modifiers + "native ";
            }
            strings.add("    " + modifiers + ((Constructor)accessibleObject).getName() + "#" + Arrays.toString(((Executable)accessibleObject).getParameters()));
        }
        strings.add("  Static Methods:");
        for (AccessibleObject accessibleObject : clarse.getDeclaredMethods()) {
            if (!Modifier.isStatic(((Method)accessibleObject).getModifiers())) continue;
            debug = ((Method)accessibleObject).getAnnotation(Debug.class);
            if (!debugAll && (debug == null || !debug.value())) continue;
            modifiers = "";
            if (this.isPublic(((Method)accessibleObject).getModifiers())) {
                modifiers = modifiers + "public ";
            } else if (this.isProtected(((Method)accessibleObject).getModifiers())) {
                modifiers = modifiers + "protected ";
            } else if (this.isPrivate(((Method)accessibleObject).getModifiers())) {
                modifiers = modifiers + "private ";
            }
            if (this.isFinal(((Method)accessibleObject).getModifiers())) {
                modifiers = modifiers + "final ";
            }
            if (this.isStatic(((Method)accessibleObject).getModifiers())) {
                modifiers = modifiers + "static ";
            }
            if (this.isVolatile(((Method)accessibleObject).getModifiers())) {
                modifiers = modifiers + "volatile ";
            }
            if (this.isNative(((Method)accessibleObject).getModifiers())) {
                modifiers = modifiers + "native ";
            }
            strings.add("    " + modifiers + ((Method)accessibleObject).getReturnType().getName() + " " + ((Method)accessibleObject).getName() + "#" + Arrays.toString(((Executable)accessibleObject).getParameters()));
        }
        return strings.toArray(new String[0]);
    }

    @API
    public String[] getDebug(Object object) {
        String modifiers;
        Debug debug;
        Class<?> clarse = object.getClass();
        ArrayList<String> strings = new ArrayList<String>();
        boolean debugAll = clarse.isAnnotationPresent(Debug.class) && clarse.getAnnotation(Debug.class).value();
        strings.add("Object: " + object.getClass().getName() + " (" + clarse.getPackage() + ")");
        strings.add("  Instance Fields:");
        for (Field field : clarse.getDeclaredFields()) {
            debug = field.getAnnotation(Debug.class);
            if (!debugAll && (debug == null || !debug.value())) continue;
            modifiers = "";
            if (this.isPublic(field.getModifiers())) {
                modifiers = modifiers + "public ";
            } else if (this.isProtected(field.getModifiers())) {
                modifiers = modifiers + "protected ";
            } else if (this.isPrivate(field.getModifiers())) {
                modifiers = modifiers + "private ";
            }
            if (this.isFinal(field.getModifiers())) {
                modifiers = modifiers + "final ";
            }
            if (this.isStatic(field.getModifiers())) {
                modifiers = modifiers + "static ";
            }
            if (this.isVolatile(field.getModifiers())) {
                modifiers = modifiers + "volatile ";
            }
            if (this.isNative(field.getModifiers())) {
                modifiers = modifiers + "native ";
            }
            try {
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                if (!this.isInstance(field.getModifiers())) continue;
                strings.add("    " + modifiers + field.getType().getName() + " " + field.getName() + " = " + field.get(object));
            }
            catch (IllegalAccessException e) {
                if (!this.isInstance(field.getModifiers())) continue;
                strings.add("    " + modifiers + field.getType().getName() + " " + field.getName() + " = Unknown");
            }
        }
        strings.add("  Instance Methods:");
        for (AccessibleObject accessibleObject : clarse.getDeclaredMethods()) {
            debug = ((Method)accessibleObject).getAnnotation(Debug.class);
            if (!debugAll && (debug == null || !debug.value())) continue;
            modifiers = "";
            if (this.isPublic(((Method)accessibleObject).getModifiers())) {
                modifiers = modifiers + "public ";
            } else if (this.isProtected(((Method)accessibleObject).getModifiers())) {
                modifiers = modifiers + "protected ";
            } else if (this.isPrivate(((Method)accessibleObject).getModifiers())) {
                modifiers = modifiers + "private ";
            }
            if (this.isFinal(((Method)accessibleObject).getModifiers())) {
                modifiers = modifiers + "final ";
            }
            if (this.isStatic(((Method)accessibleObject).getModifiers())) {
                modifiers = modifiers + "static ";
            }
            if (this.isVolatile(((Method)accessibleObject).getModifiers())) {
                modifiers = modifiers + "volatile ";
            }
            if (this.isNative(((Method)accessibleObject).getModifiers())) {
                modifiers = modifiers + "native ";
            }
            if (!this.isInstance(((Method)accessibleObject).getModifiers())) continue;
            strings.add("    " + modifiers + ((Method)accessibleObject).getReturnType().getName() + " " + ((Method)accessibleObject).getName() + "#" + Arrays.toString(((Executable)accessibleObject).getParameters()));
        }
        return strings.toArray(new String[0]);
    }
}

