/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.transk.mask.api;

import com.moderocky.transk.mask.api.Completable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.jetbrains.annotations.NotNull;

public class CompletableFuture<Z>
implements Completable<Z> {
    private Z completion;
    private Consumer<? super Z> action;
    private long delay;

    public CompletableFuture(@NotNull Z completion, long delay) {
        this.completion = completion;
        this.action = a -> {};
        this.delay = delay;
    }

    public void runAsync(@Nullable Consumer<? super Z> success) {
        this.action = success;
        this.runAsync();
    }

    public void runAsync() {
        if (this.action == null) {
            this.action = a -> {};
        }
        Thread thread = new Thread(() -> {
            ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
            Runnable task = () -> this.action.accept(this.completion);
            scheduler.schedule(task, this.delay, TimeUnit.SECONDS);
            scheduler.shutdown();
        });
        thread.start();
    }

    @Override
    public void run(@Nullable Consumer<? super Z> success) {
        this.action = success;
        this.run();
    }

    @Override
    public void run() {
        if (this.action == null) {
            this.action = a -> {};
        }
        Thread thread = new Thread();
        ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
        Runnable task = () -> this.action.accept(this.completion);
        scheduler.schedule(task, this.delay, TimeUnit.SECONDS);
        scheduler.shutdown();
    }

    @Override
    @NotNull
    public final Z get() {
        this.action.accept(this.completion);
        return this.completion;
    }
}

