/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.transk.mask;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.SkriptCommand;
import ch.njol.skript.config.Config;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.lang.TriggerSection;
import ch.njol.skript.lang.VariableString;
import ch.njol.skript.log.RetainingLogHandler;
import ch.njol.skript.log.SkriptLogger;
import com.google.common.base.CaseFormat;
import com.moderocky.transk.mask.Mask;
import com.moderocky.transk.mask.annotation.API;
import com.moderocky.transk.mask.api.CaughtBreakable;
import com.moderocky.transk.mask.api.CaughtCompletable;
import com.moderocky.transk.mask.api.Debugger;
import com.moderocky.transk.mask.api.Property;
import com.moderocky.transk.mask.internal.evaluation.Javal;
import com.moderocky.transk.mask.internal.event.DummyEvent;
import com.moderocky.transk.mask.internal.event.DummyPlayerEvent;
import com.moderocky.transk.mask.internal.utility.FileManager;
import com.moderocky.transk.mask.template.Reflective;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerEvent;

@API
public class MaskAPI
implements Reflective {
    private Unsafe unsafe = new Unsafe();

    protected MaskAPI() {
    }

    @API
    @com.moderocky.transk.mask.annotation.Unsafe
    public Unsafe getUnsafe() {
        return this.unsafe;
    }

    @API
    public Debugger getDebugger() {
        return new Debugger();
    }

    @API
    public File getScript(String name) {
        return SkriptCommand.getScriptFromName((String)name);
    }

    @API
    public String[] getSyntaxes(String entry, String ... defaults) {
        FileConfiguration file = Mask.getMask().getAddonConfig();
        assert (file != null);
        List strings = file.getStringList(entry);
        if (strings.size() < 1) {
            return defaults;
        }
        return strings.toArray(new String[0]);
    }

    @API
    public void loadInternal(String fileName) {
        InputStream stream = Mask.getPlugin().getResource(fileName);
        this.loadScript(stream, fileName).run();
    }

    @API
    public void unloadInternal(String fileName) {
        this.unloadScript(fileName).run();
    }

    @API
    public CaughtBreakable<ScriptLoader.ScriptInfo> loadScript(InputStream stream, String name) {
        ScriptLoader.ScriptInfo info;
        try {
            Config config = ScriptLoader.loadStructure((InputStream)stream, (String)name);
            info = ScriptLoader.loadScripts((Config[])new Config[]{config});
        }
        catch (Exception e) {
            return new CaughtBreakable<Object>(false, e, null);
        }
        return new CaughtBreakable<ScriptLoader.ScriptInfo>(true, null, info);
    }

    @API
    public CaughtBreakable<ScriptLoader.ScriptInfo> loadScript(String fileContents, String name) {
        try {
            return this.loadScript(new FileInputStream(fileContents), name);
        }
        catch (Exception e) {
            return new CaughtBreakable<Object>(false, e, null);
        }
    }

    @API
    public CaughtBreakable<ScriptLoader.ScriptInfo> loadScript(File file) {
        ScriptLoader.ScriptInfo info;
        try {
            Config config = ScriptLoader.loadStructure((File)file);
            info = ScriptLoader.loadScripts((Config[])new Config[]{config});
        }
        catch (Exception e) {
            return new CaughtBreakable<Object>(false, e, null);
        }
        return new CaughtBreakable<ScriptLoader.ScriptInfo>(true, null, info);
    }

    @API
    public CaughtBreakable<ScriptLoader.ScriptInfo> unloadScript(File file) {
        ScriptLoader.ScriptInfo info;
        try {
            info = ScriptLoader.unloadScript((File)file);
        }
        catch (Exception e) {
            return new CaughtBreakable<Object>(false, e, null);
        }
        return new CaughtBreakable<ScriptLoader.ScriptInfo>(true, null, info);
    }

    @API
    public CaughtBreakable<ScriptLoader.ScriptInfo> loadScript(String path) {
        File file = new File(path);
        FileManager.putIfAbsent(file);
        return this.loadScript(file);
    }

    @API
    public CaughtBreakable<ScriptLoader.ScriptInfo> unloadScript(String path) {
        File file = new File(path);
        FileManager.putIfAbsent(file);
        return this.unloadScript(file);
    }

    @API
    public String[] getCommands(String scriptName) {
        ArrayList commands = new ArrayList();
        try {
            Map commandMap = (Map)this.getField("commandNames").get();
            Set strings = (Set)commandMap.get(scriptName);
            if (strings != null) {
                commands.addAll(strings);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return commands.toArray(new String[0]);
    }

    public CaughtBreakable<Object> runJava(String java) {
        return Javal.evaluate(java);
    }

    public CaughtBreakable<Object> runJava(String java, Player player, String ... imports) {
        return Javal.evaluate(java, player, imports);
    }

    public static class Unsafe
    implements Reflective {
        private Unsafe() {
        }

        public CaughtBreakable<List<String>> parseFileSafely(String path) {
            File file = new File(path);
            FileManager.putIfAbsent(file);
            return this.parseFileSafely(file);
        }

        public CaughtBreakable<List<String>> parseFileSafely(File file) {
            FileManager.putIfAbsent(file);
            try {
                FileInputStream stream = new FileInputStream(file);
                return this.parseSafely(stream);
            }
            catch (FileNotFoundException e) {
                return new CaughtBreakable<Object>(false, e, null);
            }
        }

        public CaughtBreakable<List<String>> parseFile(String path) {
            File file = new File(path);
            FileManager.putIfAbsent(file);
            return this.parseFile(file);
        }

        public CaughtBreakable<List<String>> parseFile(File file) {
            FileManager.putIfAbsent(file);
            try {
                FileInputStream stream = new FileInputStream(file);
                return this.parse(stream);
            }
            catch (FileNotFoundException e) {
                return new CaughtBreakable<Object>(false, e, null);
            }
        }

        public CaughtBreakable<List<String>> parse(InputStream stream) {
            try {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(stream, Charset.defaultCharset()));
                StringBuilder builder = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    builder.append(line);
                    builder.append('\n');
                }
                return this.parse(builder.toString());
            }
            catch (IOException e) {
                return new CaughtBreakable<Object>(false, e, null);
            }
        }

        public CaughtBreakable<List<String>> parseSafely(InputStream stream) {
            try {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(stream, Charset.defaultCharset()));
                StringBuilder builder = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    builder.append(line);
                    builder.append('\n');
                }
                return this.parseSafely(builder.toString());
            }
            catch (IOException e) {
                return new CaughtBreakable<Object>(false, e, null);
            }
        }

        public CaughtBreakable<List<String>> execute(String ... lines) {
            DummyEvent event = new DummyEvent();
            if (lines != null && lines.length > 0) {
                RetainingLogHandler log = SkriptLogger.startRetainingLog();
                ScriptLoader.setCurrentEvent((String)"evaluating", (Class[])new Class[]{((Object)((Object)event)).getClass()});
                ArrayList errors = new ArrayList();
                for (String line : lines) {
                    this.parseEffect(line).run();
                    log.getErrors().forEach(logEntry -> errors.add(logEntry.toString()));
                }
                ScriptLoader.deleteCurrentEvent();
                log.stop();
                return new CaughtBreakable<List<String>>(true, null, errors);
            }
            return new CaughtBreakable<Object>(false, new NullPointerException(), null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CaughtBreakable<List<String>> parse(String code) {
            DummyEvent event = new DummyEvent();
            ArrayList errors = new ArrayList();
            if (code != null && !code.isEmpty()) {
                RetainingLogHandler log = SkriptLogger.startRetainingLog();
                try {
                    VariableString variableString = VariableString.newInstance((String)code.replaceAll("\"", "\"\""));
                    if (variableString != null) {
                        code = variableString.getSingle((Event)event);
                    }
                    code = code.replaceAll("\\\\n(?=[^\"]*(?:\"[^\"]*\"[^\"]*)*$)", "\n").replaceAll("\\\\t(?=[^\"]*(?:\"[^\"]*\"[^\"]*)*$)", "\t");
                    Config config = new Config(code, "Mask/evaluation.sk", true, false, ":");
                    Reflective.setField(config, "file", new File("Mask/evaluation.sk"));
                    ScriptLoader.currentScript = config;
                    ScriptLoader.setCurrentEvent((String)"evaluating", (Class[])new Class[]{((Object)((Object)event)).getClass()});
                    TriggerSection triggerSection = new TriggerSection(config.getMainNode()){

                        protected TriggerItem walk(Event event) {
                            return this.walk(event, true);
                        }

                        public String toString(Event event, boolean b) {
                            return "evaluating";
                        }
                    };
                    ScriptLoader.deleteCurrentEvent();
                    ScriptLoader.currentScript = null;
                    log.getErrors().forEach(logEntry -> errors.add(logEntry.toString()));
                    TriggerItem.walk((TriggerItem)triggerSection, (Event)event);
                }
                catch (Exception e) {
                    CaughtBreakable<Object> caughtBreakable = new CaughtBreakable<Object>(false, e, null);
                    return caughtBreakable;
                }
                finally {
                    log.stop();
                }
                return new CaughtBreakable<List<String>>(true, null, errors);
            }
            return new CaughtBreakable<Object>(false, new NullPointerException(), null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CaughtBreakable<List<String>> parseSafely(String code) {
            DummyEvent event = new DummyEvent();
            ArrayList errors = new ArrayList();
            if (code != null && !code.isEmpty()) {
                RetainingLogHandler log = SkriptLogger.startRetainingLog();
                try {
                    VariableString variableString = VariableString.newInstance((String)code.replaceAll("\"", "\"\""));
                    if (variableString != null) {
                        code = variableString.getSingle((Event)event);
                    }
                    code = code.replaceAll("\\\\n(?=[^\"]*(?:\"[^\"]*\"[^\"]*)*$)", "\n").replaceAll("\\\\t(?=[^\"]*(?:\"[^\"]*\"[^\"]*)*$)", "\t");
                    Config config = new Config(code, "Mask/evaluation.sk", true, false, ":");
                    Reflective.setField(config, "file", new File("Mask/evaluation.sk"));
                    ScriptLoader.currentScript = config;
                    ScriptLoader.setCurrentEvent((String)"evaluating", (Class[])new Class[]{((Object)((Object)event)).getClass()});
                    ScriptLoader.deleteCurrentEvent();
                    ScriptLoader.currentScript = null;
                    log.getErrors().forEach(logEntry -> errors.add(logEntry.toString()));
                }
                catch (Exception e) {
                    CaughtBreakable<Object> caughtBreakable = new CaughtBreakable<Object>(false, e, null);
                    return caughtBreakable;
                }
                finally {
                    log.stop();
                }
                return new CaughtBreakable<List<String>>(true, null, errors);
            }
            return new CaughtBreakable<Object>(false, new NullPointerException(), null);
        }

        public boolean check(String cond) {
            Condition condition = Condition.parse((String)cond, (String)"An error has occurred.");
            return condition.run((Event)new DummyEvent());
        }

        public boolean check(String cond, @Nullable Event event, @Nullable String debug) {
            if (debug == null) {
                debug = "An error has occurred.";
            }
            if (event == null) {
                event = new DummyEvent();
            }
            Condition condition = Condition.parse((String)cond, (String)debug);
            return condition.run(event);
        }

        public boolean check(String cond, Player pov, @Nullable PlayerEvent event, @Nullable String debug) {
            if (debug == null) {
                debug = "An error has occurred.";
            }
            if (event == null) {
                event = new DummyPlayerEvent(pov);
            }
            Condition condition = Condition.parse((String)cond, (String)debug);
            return condition.run((Event)event);
        }

        public CaughtCompletable<Boolean> parseEffect(String eff) {
            Effect effect = Effect.parse((String)eff, (String)"An error has occurred.");
            return new CaughtCompletable<Boolean>(effect.run((Event)new DummyEvent()));
        }

        public CaughtCompletable<Boolean> parseEffect(String eff, @Nullable Event event, @Nullable String debug) {
            if (debug == null) {
                debug = "An error has occurred.";
            }
            if (event == null) {
                event = new DummyEvent();
            }
            Effect effect = Effect.parse((String)eff, (String)debug);
            return new CaughtCompletable<Boolean>(effect.run(event));
        }

        public CaughtCompletable<Boolean> parseEffect(String eff, Player pov, @Nullable PlayerEvent event, @Nullable String debug) {
            if (debug == null) {
                debug = "An error has occurred.";
            }
            if (event == null) {
                event = new DummyPlayerEvent(pov);
            }
            Effect effect = Effect.parse((String)eff, (String)debug);
            return new CaughtCompletable<Boolean>(effect.run((Event)event));
        }

        public Property[] getProperties(Class<?> clarse) {
            Property property;
            String string;
            ArrayList<Property> properties = new ArrayList<Property>();
            ArrayList<Method> methods = new ArrayList<Method>(Arrays.asList(clarse.getMethods()));
            ArrayList<Method> setters = new ArrayList<Method>(Arrays.asList(clarse.getMethods()));
            for (Method method : methods) {
                if (!method.getName().matches("get[A-Z].*")) continue;
                string = CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, method.getName()).replace("_", " ").replaceFirst("get ", "");
                property = new Property();
                property.setGetter(method).setSetter(null).setType(method.getReturnType()).setObject(clarse).setName(string);
                if (method.getReturnType().isArray() || method.getReturnType().isAssignableFrom(Collection.class)) {
                    property.setSingle(false);
                } else {
                    property.setSingle(true);
                }
                for (Method m2 : methods) {
                    if (!m2.getName().matches("set[A-Z].*") || !method.getName().replaceFirst("get", "").equalsIgnoreCase(m2.getName().replaceFirst("set", "")) || m2.getParameterCount() != 1 || m2.getParameterTypes()[0] != method.getReturnType()) continue;
                    setters.remove(m2);
                    property.setSetter(m2);
                }
                properties.add(property);
            }
            for (Method method : setters) {
                if (!method.getName().matches("set[A-Z].*") || method.getParameterCount() != 1) continue;
                string = CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, method.getName()).replace("_", " ").replaceFirst("set ", "");
                property = new Property();
                property.setGetter(method).setSetter(null).setType(method.getParameterTypes()[0]).setObject(clarse).setName(string);
                if (method.getParameterTypes()[0].isArray() || method.getParameterTypes()[0].isAssignableFrom(Collection.class)) {
                    property.setSingle(false);
                } else {
                    property.setSingle(true);
                }
                properties.add(property);
            }
            return properties.toArray(new Property[0]);
        }

        public String[] getPropertyGetters(Class<?> clarse) {
            ArrayList<String> strings = new ArrayList<String>();
            for (Method method : clarse.getMethods()) {
                if (!method.getName().matches("get[A-Z].*")) continue;
                String string = CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, method.getName()).replace("_", " ").replaceFirst("get ", "");
                strings.add(string);
            }
            return strings.toArray(new String[0]);
        }

        public String[] getPropertySetters(Class<?> clarse) {
            ArrayList<String> strings = new ArrayList<String>();
            for (Method method : clarse.getMethods()) {
                if (!method.getName().matches("set[A-Z].*")) continue;
                String string = CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, method.getName()).replace("_", " ").replaceFirst("get ", "");
                strings.add(string);
            }
            return strings.toArray(new String[0]);
        }
    }
}

